/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.search.controller;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.beans.ApplicationBean;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ExceptionResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassGroupDao;
import edu.cornell.mannlib.vitro.webapp.i18n.I18n;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngine;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchFacetField;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchQuery;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResponse;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResultDocument;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResultDocumentList;
import edu.cornell.mannlib.vitro.webapp.search.controller.FilterValue;
import edu.cornell.mannlib.vitro.webapp.search.controller.SearchFilter;
import edu.cornell.mannlib.vitro.webapp.search.controller.SearchFiltering;
import edu.cornell.mannlib.vitro.webapp.search.controller.SortConfiguration;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.LinkTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.searchresult.IndividualSearchResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="SearchController", urlPatterns={"/search", "/extendedsearch", "/search.jsp", "/fedsearch", "/searchcontroller"})
public class PagedSearchController
extends FreemarkerHttpServlet {
    private static final String HITS_PER_PAGE_OPTIONS = "hitsPerPageOptions";
    private static final String FACETS = "facets";
    static final Log log = LogFactory.getLog(PagedSearchController.class);
    protected static final int DEFAULT_HITS_PER_PAGE = 30;
    private static final int DEFAULT_DOCUMENTS_NUMBER = 500;
    private static Set<Integer> hitsPerPageOptions = Stream.of(10, 30, 50).collect(Collectors.toCollection(LinkedHashSet::new));
    protected static final int DEFAULT_MAX_HIT_COUNT = 1000;
    private static final String PARAM_XML_REQUEST = "xml";
    private static final String PARAM_CSV_REQUEST = "csv";
    private static final String PARAM_START_INDEX = "startIndex";
    private static final String PARAM_HITS_PER_PAGE = "hitsPerPage";
    private static final String PARAM_DOCUMENTS_NUMBER = "documentsNumber";
    public static final String PARAM_QUERY_TEXT = "querytext";
    public static final String PARAM_QUERY_SORT_BY = "sort";
    protected static final Map<Format, Map<Result, String>> templateTable = PagedSearchController.setupTemplateTable();
    public static final int MAX_QUERY_LENGTH = 500;

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        VitroRequest vreq = new VitroRequest(request);
        boolean wasXmlRequested = this.isRequestedFormatXml(vreq);
        boolean wasCSVRequested = this.isRequestedFormatCSV(vreq);
        if (!wasXmlRequested && !wasCSVRequested) {
            super.doGet((HttpServletRequest)vreq, response);
        } else if (wasXmlRequested) {
            try {
                ResponseValues rvalues = this.processRequest(vreq);
                response.setCharacterEncoding("UTF-8");
                response.setContentType("text/xml;charset=UTF-8");
                response.setHeader("Content-Disposition", "attachment; filename=search.xml");
                this.writeTemplate(rvalues.getTemplateName(), rvalues.getMap(), request, response);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        } else if (wasCSVRequested) {
            try {
                ResponseValues rvalues = this.processRequest(vreq);
                response.setCharacterEncoding("UTF-8");
                response.setContentType("text/csv;charset=UTF-8");
                response.setHeader("Content-Disposition", "attachment; filename=search.csv");
                this.writeTemplate(rvalues.getTemplateName(), rvalues.getMap(), request, response);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        Format format = this.getFormat(vreq);
        boolean wasXmlRequested = Format.XML == format;
        boolean wasCSVRequested = Format.CSV == format;
        log.debug((Object)("Requested format was " + (wasXmlRequested ? PARAM_XML_REQUEST : "html")));
        boolean wasHtmlRequested = !wasXmlRequested && !wasCSVRequested;
        long startTime = System.nanoTime();
        try {
            SearchResultDocumentList docs;
            int hitsPerPage;
            if (vreq.getWebappDaoFactory() == null || vreq.getWebappDaoFactory().getIndividualDao() == null) {
                log.error((Object)"Could not get webappDaoFactory or IndividualDao");
                throw new Exception("Could not access model.");
            }
            IndividualDao iDao = vreq.getWebappDaoFactory().getIndividualDao();
            VClassGroupDao grpDao = vreq.getWebappDaoFactory().getVClassGroupDao();
            VClassDao vclassDao = vreq.getWebappDaoFactory().getVClassDao();
            ApplicationBean appBean = vreq.getAppBean();
            log.debug((Object)("IndividualDao is " + iDao.toString() + " Public classes in the classgroup are " + grpDao.getPublicGroupsWithVClasses().toString()));
            log.debug((Object)("VClassDao is " + vclassDao.toString()));
            int startIndex = this.getStartIndex(vreq);
            int documentsToReturn = hitsPerPage = this.getHitsPerPage(vreq);
            if (!wasHtmlRequested) {
                documentsToReturn = this.getDocumentsNumber(vreq);
            }
            String queryText = PagedSearchController.getQueryText(vreq);
            log.debug((Object)("Query text is \"" + queryText + "\""));
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.getSpentTime(startTime) + "ms spent before read filter configurations."));
            }
            Set<String> currentRoles = SearchFiltering.getCurrentUserRoles(vreq);
            Map<String, SearchFilter> filterConfigurationsByField = SearchFiltering.readFilterConfigurations(currentRoles, vreq);
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.getSpentTime(startTime) + "ms spent before get sort configurations."));
            }
            for (SearchFilter filter : filterConfigurationsByField.values()) {
                filter.setInputText(SearchFiltering.getFilterInputText(vreq, filter.getId()));
                filter.setRangeValues(SearchFiltering.getFilterRangeText(vreq, filter.getId()));
            }
            Map<String, List<String>> requestFilters = SearchFiltering.getRequestFilters(vreq);
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.getSpentTime(startTime) + "ms spent after getRequestFilters."));
            }
            SearchFiltering.setSelectedFilters(filterConfigurationsByField, requestFilters);
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.getSpentTime(startTime) + "ms spent after setSelectedFilters."));
            }
            Map<String, SortConfiguration> sortConfigurations = SearchFiltering.getSortConfigurations(vreq);
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.getSpentTime(startTime) + "ms spent before get query configurations."));
            }
            SearchQuery query = this.getQuery(queryText, documentsToReturn, startIndex, vreq, filterConfigurationsByField, sortConfigurations);
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.getSpentTime(startTime) + "ms spent after get query configurations."));
            }
            SearchEngine search = ApplicationUtils.instance().getSearchEngine();
            SearchResponse response = null;
            try {
                response = search.query(query);
            }
            catch (Exception ex) {
                String msg = this.makeBadSearchMessage(queryText, ex.getMessage(), vreq);
                log.error((Object)"could not run search query", (Throwable)ex);
                return this.doFailedSearch(msg, queryText, format, vreq);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.getSpentTime(startTime) + "ms spent after get query execution."));
            }
            if (response == null) {
                log.error((Object)"Search response was null");
                return this.doFailedSearch(I18n.text((HttpServletRequest)vreq, "error_in_search_request", new Object[0]), queryText, format, vreq);
            }
            this.addFacetCountersFromRequest(response, filterConfigurationsByField, vreq);
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.getSpentTime(startTime) + "ms spent after addFacetCountersFromRequest."));
            }
            if ((docs = response.getResults()) == null) {
                log.error((Object)"Document list for a search was null");
                return this.doFailedSearch(I18n.text((HttpServletRequest)vreq, "error_in_search_request", new Object[0]), queryText, format, vreq);
            }
            long hitCount = docs.getNumFound();
            log.debug((Object)("Number of hits = " + hitCount));
            ArrayList<Individual> individuals = new ArrayList<Individual>(docs.size());
            for (SearchResultDocument doc : docs) {
                try {
                    String uri = doc.getStringValue("URI");
                    Individual ind = iDao.getIndividualByURI(uri);
                    if (ind == null) continue;
                    ind.setSearchSnippet(this.getSnippet(doc, response));
                    individuals.add(ind);
                }
                catch (Exception e) {
                    log.error((Object)"Problem getting usable individuals from search hits. ", (Throwable)e);
                }
            }
            UrlBuilder.ParamMap pagingLinkParams = new UrlBuilder.ParamMap();
            pagingLinkParams.put(PARAM_QUERY_TEXT, queryText);
            pagingLinkParams.put(PARAM_HITS_PER_PAGE, String.valueOf(hitsPerPage));
            Enumeration paramNames = vreq.getParameterNames();
            SearchFiltering.addFiltersToPageLinks(vreq, pagingLinkParams, paramNames);
            if (wasXmlRequested) {
                pagingLinkParams.put(PARAM_XML_REQUEST, "1");
            }
            HashMap<String, Object> body = new HashMap<String, Object>();
            if (wasHtmlRequested) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.getSpentTime(startTime) + "ms spent before sorting filterConfigurationsByField values."));
                }
                for (Map.Entry entry : filterConfigurationsByField.entrySet()) {
                    ((SearchFilter)entry.getValue()).sortValues();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.getSpentTime(startTime) + "ms spent after sorting filterConfigurationsByField values."));
                }
                Map<String, SearchFilter> filtersForTemplateById = SearchFiltering.getFiltersForTemplate(filterConfigurationsByField);
                body.put("filters", filtersForTemplateById);
                body.put("filterGroups", SearchFiltering.readFilterGroupsConfigurations(vreq, filtersForTemplateById));
                body.put("sorting", sortConfigurations.values());
                body.put("emptySearch", this.isEmptySearchFilters(filterConfigurationsByField));
            }
            body.put("individuals", IndividualSearchResult.getIndividualTemplateModels(individuals, vreq));
            body.put(PARAM_QUERY_TEXT, queryText);
            body.put("locale", vreq.getLocale().toLanguageTag());
            body.put("title", appBean.getApplicationName() + " - " + I18n.text((HttpServletRequest)vreq, "search_results_for", new Object[0]) + " '" + queryText + "'");
            body.put("hitCount", hitCount);
            body.put(PARAM_START_INDEX, startIndex);
            body.put(PARAM_HITS_PER_PAGE, hitsPerPage);
            body.put(HITS_PER_PAGE_OPTIONS, hitsPerPageOptions);
            body.put("pagingLinks", PagedSearchController.getPagingLinks(startIndex, hitsPerPage, hitCount, vreq.getServletPath(), pagingLinkParams, vreq));
            if (startIndex != 0) {
                body.put("prevPage", this.getPreviousPageLink(startIndex, hitsPerPage, vreq.getServletPath(), pagingLinkParams));
            }
            if ((long)startIndex < hitCount - (long)hitsPerPage) {
                body.put("nextPage", this.getNextPageLink(startIndex, hitsPerPage, vreq.getServletPath(), pagingLinkParams));
            }
            String template = templateTable.get((Object)format).get((Object)Result.PAGED);
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.getSpentTime(startTime) + "ms spent before TemplateResponseValues."));
            }
            TemplateResponseValues templateResponseValues = new TemplateResponseValues(template, body);
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.getSpentTime(startTime) + "ms spent after TemplateResponseValues."));
            }
            return templateResponseValues;
        }
        catch (Throwable e) {
            return this.doSearchError(e, format);
        }
    }

    private long getSpentTime(long startTime) {
        return (System.nanoTime() - startTime) / 1000000L;
    }

    private Object isEmptySearchFilters(Map<String, SearchFilter> filterConfigurationsByField) {
        for (SearchFilter filter : filterConfigurationsByField.values()) {
            if (!filter.isSelected()) continue;
            return false;
        }
        return true;
    }

    private void addFacetCountersFromRequest(SearchResponse response, Map<String, SearchFilter> filtersByField, VitroRequest vreq) {
        long startTime = System.nanoTime();
        List<SearchFacetField> resultfacetFields = response.getFacetFields();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.getSpentTime(startTime) + "ms spent after getFacetFields."));
        }
        Map<String, List<String>> requestFiltersById = SearchFiltering.getRequestFilters(vreq);
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.getSpentTime(startTime) + "ms spent after SearchFiltering.getRequestFilters."));
        }
        for (SearchFacetField resultField : resultfacetFields) {
            SearchFilter searchFilter = filtersByField.get(resultField.getName());
            if (searchFilter == null) continue;
            List<SearchFacetField.Count> values = resultField.getValues();
            for (SearchFacetField.Count value : values) {
                String label;
                if (value.getCount() == 0L) continue;
                String valueName = value.getName();
                FilterValue filterValue = searchFilter.getValue(valueName);
                if (filterValue == null) {
                    filterValue = new FilterValue(valueName);
                    searchFilter.addValue(filterValue);
                }
                if (requestFiltersById.containsKey(searchFilter.getId())) {
                    List<String> requestedValues = requestFiltersById.get(searchFilter.getId());
                    if (requestedValues.contains(valueName)) {
                        filterValue.setSelected(true);
                    }
                    if (!SearchFiltering.isEmptyValues(requestedValues)) {
                        searchFilter.setSelected(true);
                    }
                }
                if (searchFilter.isLocalizationRequired() && StringUtils.isBlank((CharSequence)filterValue.getName()) && !StringUtils.isBlank((CharSequence)(label = SearchFiltering.getUriLabel(value.getName(), vreq)))) {
                    filterValue.setName(label);
                }
                filterValue.setCount(value.getCount());
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)(this.getSpentTime(startTime) + "ms spent after SearchFacetField " + searchFilter.getName() + "processing."));
        }
    }

    public static String getQueryText(VitroRequest vreq) {
        String query = vreq.getParameter(PARAM_QUERY_TEXT);
        if (StringUtils.isBlank((CharSequence)query)) {
            return "";
        }
        return query;
    }

    private int getHitsPerPage(VitroRequest vreq) {
        int hitsPerPage = 30;
        try {
            int hits = Integer.parseInt(vreq.getParameter(PARAM_HITS_PER_PAGE));
            if (hitsPerPageOptions.contains(hits)) {
                hitsPerPage = hits;
            }
        }
        catch (Throwable e) {
            hitsPerPage = 30;
        }
        log.debug((Object)("hitsPerPage is " + hitsPerPage));
        return hitsPerPage;
    }

    private int getDocumentsNumber(VitroRequest vreq) {
        int documentsNumber = 500;
        try {
            documentsNumber = Integer.parseInt(vreq.getParameter(PARAM_DOCUMENTS_NUMBER));
        }
        catch (Throwable e) {
            documentsNumber = 500;
        }
        if (documentsNumber > 1000) {
            return 1000;
        }
        log.debug((Object)("documents number is " + documentsNumber));
        return documentsNumber;
    }

    private int getStartIndex(VitroRequest vreq) {
        int startIndex = 0;
        try {
            startIndex = Integer.parseInt(vreq.getParameter(PARAM_START_INDEX));
        }
        catch (Throwable e) {
            startIndex = 0;
        }
        log.debug((Object)("startIndex is " + startIndex));
        return startIndex;
    }

    private String getSnippet(SearchResultDocument doc, SearchResponse response) {
        List<String> snippets;
        String docId = doc.getStringValue("DocId");
        StringBuilder text = new StringBuilder();
        Map<String, Map<String, List<String>>> highlights = response.getHighlighting();
        if (highlights != null && highlights.get(docId) != null && (snippets = highlights.get(docId).get("ALLTEXT")) != null && snippets.size() > 0) {
            text.append("... ").append(snippets.get(0)).append(" ...");
        }
        return text.toString();
    }

    private SearchQuery getQuery(String queryText, int hitsPerPage, int startIndex, VitroRequest vreq, Map<String, SearchFilter> filtersByField, Map<String, SortConfiguration> sortOptions) {
        if (StringUtils.isBlank((CharSequence)queryText)) {
            queryText = "*:*";
        }
        SearchQuery query = ApplicationUtils.instance().getSearchEngine().createQuery(queryText);
        query.setStart(startIndex).setRows(hitsPerPage);
        this.addSortRules(vreq, query, sortOptions);
        this.addDefaultVitroFacets(vreq, query);
        SearchFiltering.addFacetFieldsToQuery(filtersByField, query);
        Map<String, SearchFilter> filtersById = SearchFiltering.getFiltersById(filtersByField);
        SearchFiltering.addFiltersToQuery(vreq, query, filtersById);
        log.debug((Object)("Query = " + query.toString()));
        return query;
    }

    private void addDefaultVitroFacets(VitroRequest vreq, SearchQuery query) {
        String[] facets = vreq.getParameterValues(FACETS);
        if (facets != null && facets.length > 0) {
            query.addFacetFields(facets);
        }
    }

    private void addSortRules(VitroRequest vreq, SearchQuery query, Map<String, SortConfiguration> sortOptions) {
        String sortType = this.getSortType(vreq);
        if (sortOptions.isEmpty()) {
            return;
        }
        HashSet<String> appliedSortOptions = new HashSet<String>();
        if (!StringUtils.isBlank((CharSequence)sortType) && sortOptions.containsKey(sortType)) {
            SortConfiguration conf = sortOptions.get(sortType);
            this.addSortField(vreq, query, conf, sortOptions, appliedSortOptions);
            conf.setSelected(true);
            return;
        }
        boolean textQueryIsEmpty = StringUtils.isBlank((CharSequence)PagedSearchController.getQueryText(vreq));
        if (textQueryIsEmpty) {
            SortConfiguration conf = sortOptions.entrySet().iterator().next().getValue();
            this.addSortField(vreq, query, conf, sortOptions, appliedSortOptions);
        }
    }

    private void addSortField(VitroRequest vreq, SearchQuery query, SortConfiguration conf, Map<String, SortConfiguration> sortOptions, Set<String> appliedSortOptions) {
        if (conf == null || appliedSortOptions.contains(conf.getId())) {
            return;
        }
        appliedSortOptions.add(conf.getId());
        String field = conf.getField(vreq.getLocale());
        if (StringUtils.isBlank((CharSequence)field)) {
            log.error((Object)String.format("Sort field is not set for '%s'", conf.getId()));
            return;
        }
        query.addSortField(field, conf.getSortOrder());
        if (sortOptions.containsKey(conf.getFallback())) {
            this.addSortField(vreq, query, sortOptions.get(conf.getFallback()), sortOptions, appliedSortOptions);
        }
    }

    private String getSortType(VitroRequest vreq) {
        return vreq.getParameter(PARAM_QUERY_SORT_BY);
    }

    protected static List<PagingLink> getPagingLinks(int startIndex, int hitsPerPage, long hitCount, String baseUrl, UrlBuilder.ParamMap params, VitroRequest vreq) {
        ArrayList<PagingLink> pagingLinks = new ArrayList<PagingLink>();
        if (hitCount <= (long)hitsPerPage) {
            return pagingLinks;
        }
        int maxHitCount = 1000;
        if (startIndex >= 1000 - hitsPerPage) {
            maxHitCount = startIndex + 1000;
        }
        int i = 0;
        while ((long)i < hitCount) {
            params.put(PARAM_START_INDEX, String.valueOf(i));
            if (i < maxHitCount - hitsPerPage) {
                boolean iIsCurrentPage;
                int pageNumber = i / hitsPerPage + 1;
                boolean bl = iIsCurrentPage = i >= startIndex && i < startIndex + hitsPerPage;
                if (iIsCurrentPage) {
                    pagingLinks.add(new PagingLink(pageNumber));
                } else {
                    pagingLinks.add(new PagingLink(pageNumber, baseUrl, params));
                }
            } else {
                pagingLinks.add(new PagingLink(I18n.text((HttpServletRequest)vreq, "paging_link_more", new Object[0]), baseUrl, params));
                break;
            }
            i += hitsPerPage;
        }
        return pagingLinks;
    }

    private String getPreviousPageLink(int startIndex, int hitsPerPage, String baseUrl, UrlBuilder.ParamMap params) {
        params.put(PARAM_START_INDEX, String.valueOf(startIndex - hitsPerPage));
        return UrlBuilder.getUrl(baseUrl, params);
    }

    private String getNextPageLink(int startIndex, int hitsPerPage, String baseUrl, UrlBuilder.ParamMap params) {
        params.put(PARAM_START_INDEX, String.valueOf(startIndex + hitsPerPage));
        return UrlBuilder.getUrl(baseUrl, params);
    }

    private ExceptionResponseValues doSearchError(Throwable e, Format f) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("message", "Search failed: " + e.getMessage());
        return new ExceptionResponseValues(PagedSearchController.getTemplate(f, Result.ERROR), body, e);
    }

    private TemplateResponseValues doFailedSearch(String message, String querytext, Format f, VitroRequest vreq) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("title", I18n.text((HttpServletRequest)vreq, "search_for", querytext));
        if (StringUtils.isEmpty((CharSequence)message)) {
            message = I18n.text((HttpServletRequest)vreq, "search_failed", new Object[0]);
        }
        body.put("message", message);
        return new TemplateResponseValues(PagedSearchController.getTemplate(f, Result.ERROR), body);
    }

    private String makeBadSearchMessage(String querytext, String exceptionMsg, VitroRequest vreq) {
        String rv = "";
        try {
            int post;
            int errorWindow;
            int coli = exceptionMsg.indexOf("column");
            if (coli == -1) {
                return "";
            }
            int numi = exceptionMsg.indexOf(".", coli + 7);
            if (numi == -1) {
                return "";
            }
            String part = exceptionMsg.substring(coli + 7, numi);
            int i = Integer.parseInt(part) - 1;
            int pre = i - (errorWindow = 5);
            if (pre < 0) {
                pre = 0;
            }
            if ((post = i + errorWindow) > querytext.length()) {
                post = querytext.length();
            }
            String before = querytext.substring(pre, i);
            String after = "";
            if (post > i) {
                after = querytext.substring(i + 1, post);
            }
            rv = I18n.text((HttpServletRequest)vreq, "search_term_error_near", new Object[0]) + " <span class='searchQuote'>" + before + "<span class='searchError'>" + querytext.charAt(i) + "</span>" + after + "</span>";
        }
        catch (Throwable ex) {
            return "";
        }
        return rv;
    }

    protected boolean isRequestedFormatXml(VitroRequest req) {
        if (req != null) {
            String param = req.getParameter(PARAM_XML_REQUEST);
            return param != null && "1".equals(param);
        }
        return false;
    }

    protected boolean isRequestedFormatCSV(VitroRequest req) {
        if (req != null) {
            String param = req.getParameter(PARAM_CSV_REQUEST);
            return param != null && "1".equals(param);
        }
        return false;
    }

    protected Format getFormat(VitroRequest req) {
        if (req != null && req.getParameter(PARAM_XML_REQUEST) != null && "1".equals(req.getParameter(PARAM_XML_REQUEST))) {
            return Format.XML;
        }
        if (req != null && req.getParameter(PARAM_CSV_REQUEST) != null && "1".equals(req.getParameter(PARAM_CSV_REQUEST))) {
            return Format.CSV;
        }
        return Format.HTML;
    }

    protected static String getTemplate(Format format, Result result) {
        if (format != null && result != null) {
            return templateTable.get((Object)format).get((Object)result);
        }
        log.error((Object)"getTemplate() must not have a null format or result.");
        return templateTable.get((Object)Format.HTML).get((Object)Result.ERROR);
    }

    protected static Map<Format, Map<Result, String>> setupTemplateTable() {
        HashMap table = new HashMap();
        HashMap<Result, String> resultsToTemplates = new HashMap<Result, String>();
        resultsToTemplates.put(Result.PAGED, "search-pagedResults.ftl");
        resultsToTemplates.put(Result.ERROR, "search-error.ftl");
        table.put(Format.HTML, Collections.unmodifiableMap(resultsToTemplates));
        resultsToTemplates = new HashMap();
        resultsToTemplates.put(Result.PAGED, "search-xmlResults.ftl");
        resultsToTemplates.put(Result.ERROR, "search-xmlError.ftl");
        table.put(Format.XML, Collections.unmodifiableMap(resultsToTemplates));
        resultsToTemplates = new HashMap();
        resultsToTemplates.put(Result.PAGED, "search-csvResults.ftl");
        resultsToTemplates.put(Result.ERROR, "search-csvError.ftl");
        table.put(Format.CSV, Collections.unmodifiableMap(resultsToTemplates));
        return Collections.unmodifiableMap(table);
    }

    protected static class PagingLink
    extends LinkTemplateModel {
        PagingLink(int pageNumber, String baseUrl, UrlBuilder.ParamMap params) {
            super(String.valueOf(pageNumber), baseUrl, params);
        }

        PagingLink(int pageNumber) {
            this.setText(String.valueOf(pageNumber));
        }

        PagingLink(String text, String baseUrl, UrlBuilder.ParamMap params) {
            super(text, baseUrl, params);
        }
    }

    protected static enum Result {
        PAGED,
        ERROR,
        BAD_QUERY;

    }

    protected static enum Format {
        HTML,
        XML,
        CSV;

    }
}

