/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.search.controller;

import edu.cornell.mannlib.vitro.webapp.search.controller.FilterValue;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.rdf.model.RDFNode;

public class SearchFilter {
    private static final String FILTER = "Filter";
    private static final String RANGE_FILTER = "RangeFilter";
    private String id;
    private String name = "";
    private String from = "";
    private String to = "";
    private String fromYear = "";
    private String toYear = "";
    private boolean isPublic = false;
    private String min = "0";
    private String max = "2000";
    private int moreLimit = 30;
    private int order = 0;
    private String field = "";
    private String endField = "";
    private String inputText = "";
    private boolean localizationRequired = false;
    private boolean multivalued = false;
    private boolean selected = false;
    private boolean input = false;
    private Map<String, FilterValue> values = new LinkedHashMap<String, FilterValue>();
    private boolean inputRegex = false;
    private boolean facetsRequired;
    private String type = "Filter";
    private String rangeText = "";
    private String rangeInput = "";
    private boolean hidden = false;

    public String getRangeInput() {
        return this.rangeInput;
    }

    public void setRangeInput(String range) {
        this.rangeInput = range;
    }

    public String getRangeText() {
        return this.rangeText;
    }

    public SearchFilter(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(RDFNode rdfNode) {
        if (rdfNode != null) {
            this.name = rdfNode.asLiteral().getLexicalForm().trim();
        }
    }

    public void setOrder(RDFNode rdfNode) {
        if (rdfNode != null) {
            this.order = rdfNode.asLiteral().getInt();
        }
    }

    public Integer getOrder() {
        return this.order;
    }

    public String getField() {
        return this.field;
    }

    public String getEndField() {
        return this.endField;
    }

    public void setEndField(String endField) {
        this.endField = endField;
    }

    public void addValue(FilterValue value) {
        this.values.put(value.getId(), value);
    }

    public FilterValue getValue(String name) {
        return this.values.get(name);
    }

    public Map<String, FilterValue> getValues() {
        return this.values;
    }

    public void setField(String fieldName) {
        this.field = fieldName;
    }

    public boolean contains(String valueId) {
        return this.values.containsKey(valueId);
    }

    public boolean isLocalizationRequired() {
        return this.localizationRequired;
    }

    public void setLocalizationRequired(boolean localizationRequired) {
        this.localizationRequired = localizationRequired;
    }

    public String getId() {
        return this.id;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean isSelected) {
        this.selected = isSelected;
    }

    public boolean isMultivalued() {
        return this.multivalued;
    }

    public void setMultivalued(boolean multivalued) {
        this.multivalued = multivalued;
    }

    public boolean isInput() {
        return this.input;
    }

    public boolean isRange() {
        return RANGE_FILTER.equals(this.type);
    }

    public void setInput(boolean input) {
        this.input = input;
    }

    public String getInputText() {
        return this.inputText;
    }

    public void setInputText(String inputText) {
        if (StringUtils.isBlank((CharSequence)inputText)) {
            return;
        }
        this.selected = true;
        this.inputText = inputText;
    }

    public void setInputRegex(boolean regex) {
        this.inputRegex = regex;
    }

    public boolean isInputRegex() {
        return this.inputRegex;
    }

    public void setFacetsRequired(boolean facetsRequired) {
        this.facetsRequired = facetsRequired;
    }

    public boolean isFacetsRequired() {
        return this.facetsRequired;
    }

    public void setType(RDFNode rdfNode) {
        String typeOntClass = rdfNode.toString();
        if (typeOntClass.contains(RANGE_FILTER)) {
            this.type = RANGE_FILTER;
        }
    }

    public String getType() {
        return this.type;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String fromValue) {
        this.from = fromValue;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String toValue) {
        this.to = toValue;
    }

    public void setRangeValues(String filterRangeText) {
        if (StringUtils.isBlank((CharSequence)filterRangeText)) {
            return;
        }
        this.rangeInput = filterRangeText;
        String[] dates = filterRangeText.trim().split(" ");
        if (dates.length != 2) {
            return;
        }
        this.setFrom(dates[0]);
        this.setFromYear(dates[0]);
        this.to = dates[1];
        this.setTo(this.to);
        this.setToYear(dates[1]);
        this.rangeText = "[" + this.from.trim() + " TO " + this.to.trim() + "]";
        this.selected = true;
    }

    public String getMin() {
        return this.min;
    }

    public void setMin(String min) {
        this.min = min;
    }

    public String getMax() {
        return this.max;
    }

    public void setMax(String max) {
        this.max = max;
    }

    private String getYear(String timeString) {
        Instant time = Instant.parse(timeString);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy").withZone(ZoneId.systemDefault());
        String formatted = formatter.format(time);
        return formatted;
    }

    public String getFromYear() {
        return this.fromYear;
    }

    public void setFromYear(String fromYear) {
        this.fromYear = this.getYear(fromYear);
    }

    public String getToYear() {
        return this.toYear;
    }

    public void setToYear(String toYear) {
        this.toYear = this.getYear(toYear);
    }

    public void sortValues() {
        LinkedList<Map.Entry<String, FilterValue>> list = new LinkedList<Map.Entry<String, FilterValue>>(this.values.entrySet());
        list.sort(new FilterValueComparator());
        this.values = list.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b, LinkedHashMap::new));
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public void removeValuesWithZeroCount() {
        Iterator<Map.Entry<String, FilterValue>> iterator = this.values.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, FilterValue> entry = iterator.next();
            FilterValue value = entry.getValue();
            if (value.getCount() != 0L) continue;
            iterator.remove();
        }
    }

    public boolean isEmpty() {
        return this.values.size() <= 0 && !this.isInput() && !this.isRange();
    }

    public void setHidden(boolean b) {
        this.hidden = b;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public int getMoreLimit() {
        return this.moreLimit;
    }

    public void setMoreLimit(int moreLimit) {
        this.moreLimit = moreLimit;
    }

    private class FilterValueComparator
    implements Comparator<Map.Entry<String, FilterValue>> {
        private FilterValueComparator() {
        }

        @Override
        public int compare(Map.Entry<String, FilterValue> obj1, Map.Entry<String, FilterValue> obj2) {
            FilterValue filter1 = obj1.getValue();
            FilterValue filter2 = obj2.getValue();
            int result = filter1.getOrder().compareTo(filter2.getOrder());
            if (result == 0) {
                return filter1.getName().toLowerCase().compareTo(filter2.getName().toLowerCase());
            }
            return result;
        }
    }
}

