/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.search.controller;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchQuery;
import edu.cornell.mannlib.vitro.webapp.search.controller.FilterValue;
import edu.cornell.mannlib.vitro.webapp.search.controller.PagedSearchController;
import edu.cornell.mannlib.vitro.webapp.search.controller.SearchFilter;
import edu.cornell.mannlib.vitro.webapp.search.controller.SearchFilterGroup;
import edu.cornell.mannlib.vitro.webapp.search.controller.SortConfiguration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResourceFactory;

public class SearchFiltering {
    private static final Log log = LogFactory.getLog(SearchFiltering.class);
    private static final String FILTER_RANGE = "filter_range_";
    private static final String FILTER_INPUT_PREFIX = "filter_input_";
    private static final String FILTERS = "filters";
    private static final String FILTER_QUERY = "PREFIX search: <https://vivoweb.org/ontology/vitro-search#>\nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nSELECT ?filter_id ?filter_type ?filter_label ?value_label ?value_id  ?field_name ?public ?filter_order ?value_order (STR(?isUriReq) as ?isUri ) ?multivalued ?input ?regex ?facet ?min ?max ?role ?value_public ?more_limit \nWHERE {\n    ?filter rdf:type search:Filter .\n    ?filter rdfs:label ?filter_label .\n    ?filter search:id ?filter_id .\n    ?filter a ?filter_type .\n    ?filter search:filterField ?field .\n    ?field search:indexField ?field_name .\n    OPTIONAL {\n        ?filter search:hasKnownValue ?value . \n        ?value rdfs:label ?value_label .\n        ?value search:id ?value_id .\n        OPTIONAL {            ?value search:order ?v_order .\n            bind(?v_order as ?value_order_found).\n        }\n        OPTIONAL {\n            ?value search:isDefaultForRole ?role .\n        }\n        OPTIONAL {\n            ?value search:public ?value_public .\n        }\n    }\n    OPTIONAL {?field search:multivalued ?multivalued}\n    OPTIONAL {?filter search:isUriValues ?isUriReq }\n    OPTIONAL {?filter search:userInput ?input }\n    OPTIONAL {?filter search:userInputRegex ?regex }\n    OPTIONAL {?filter search:facetResults ?facet }\n    OPTIONAL {?filter search:from ?min }\n    OPTIONAL {?filter search:public ?public }\n    OPTIONAL {?filter search:to ?max }\n    OPTIONAL {?filter search:moreLimit ?more_limit }\n    OPTIONAL {\n        ?filter search:order ?f_order \n        bind(?f_order as ?filter_order_found).\n    }\n    BIND(coalesce(?filter_order_found, 0) as ?filter_order)\n    BIND(coalesce(?value_order_found, 0) as ?value_order)\n} ORDER BY ?filter_id ?filter_order ?value_order";
    private static final String FILTER_GROUPS_QUERY = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX search: <https://vivoweb.org/ontology/vitro-search#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nSELECT ?group_id (STR(?group_l) AS ?group_label) ?filter_id ?order ?filter_order ?public\nWHERE {\n    ?filter_group rdf:type search:FilterGroup .\n    ?filter_group search:contains ?filter .\n    ?filter_group rdfs:label ?group_l .\n    ?filter_group search:id ?group_id .\n    OPTIONAL { ?filter_group search:order ?order . } \n    ?filter search:id ?filter_id .\n    OPTIONAL {?filter_group search:public ?public }\n    OPTIONAL{ ?filter search:order ?f_order .\n        bind(?f_order as ?filter_order_found).\n    }\n    BIND(coalesce(?filter_order_found, 0) as ?filter_order)\n}  ORDER BY ?order ?group_label ?filter_order";
    private static final String LABEL_QUERY = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nSELECT ?label\nWHERE {\n    ?uri rdfs:label ?label .\n} LIMIT 1";
    private static final String SORT_QUERY = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX search: <https://vivoweb.org/ontology/vitro-search#> \nSELECT ( STR(?sort_label) as ?label ) ?id ?searchField ?multilingual ?isAsc ?sort_order ?fallback ?display\nWHERE {\n    ?sort rdf:type search:Sort . \n    ?sort rdfs:label ?sort_label .\n    OPTIONAL {\n        ?sort search:sortField ?field .\n        ?field search:indexField ?searchField  .\n        OPTIONAL {\n            ?field search:isLanguageSpecific ?f_multilingual  .\n            BIND(?f_multilingual as ?bind_multilingual) .\n        }\n    }\n    OPTIONAL {\n        ?sort search:id ?id .\n    }\n    OPTIONAL {\n        ?sort search:isAscending ?f_ord  .\n        BIND(?f_ord as ?f_order) .\n    }\n    OPTIONAL {\n        ?sort search:hasFallback/search:id ?fallback .\n    }\n    OPTIONAL{         ?sort search:order ?s_order .\n        BIND(?s_order as ?sort_order_found).\n    }\n    OPTIONAL {?sort search:display ?display }\n    BIND(coalesce(?sort_order_found, 0) as ?sort_order)\n    BIND(COALESCE(?f_order, false) as ?isAsc)\n    BIND(COALESCE(?bind_multilingual, false) as ?multilingual)\n} ORDER BY ?sort_order ?label ";

    protected static void addFiltersToQuery(VitroRequest vreq, SearchQuery query, Map<String, SearchFilter> filterById) {
        Enumeration paramNames = vreq.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String[] filters;
            String paramFilterName = (String)paramNames.nextElement();
            if (StringUtils.isBlank((CharSequence)paramFilterName) || !paramFilterName.startsWith(FILTERS) || (filters = vreq.getParameterValues(paramFilterName)) == null || filters.length <= 0) continue;
            for (String filter : filters) {
                String[] pair = filter.split(":", 2);
                if (pair.length != 2) continue;
                String name = pair[0].replace("\"", "");
                String value = pair[1].replace("\"", "");
                SearchFilter searchFilter = filterById.get(name);
                if (searchFilter == null || searchFilter.getField() == null) continue;
                query.addFilterQuery(searchFilter.getField() + ":\"" + value + "\"");
            }
        }
        SearchFiltering.addPreconfiguredFiltersToQuery(query, filterById.values());
    }

    public static void addPreconfiguredFiltersToQuery(SearchQuery query, Collection<SearchFilter> collection) {
        for (SearchFilter searchFilter : collection) {
            if (searchFilter.isInput()) {
                SearchFiltering.addInputFilter(query, searchFilter);
            } else if (searchFilter.isRange()) {
                SearchFiltering.addRangeFilter(query, searchFilter);
            }
            for (FilterValue fv : searchFilter.getValues().values()) {
                if (!fv.isDefault()) continue;
                query.addFilterQuery(searchFilter.getField() + ":\"" + fv.getId() + "\"");
            }
        }
    }

    public static Map<String, List<String>> getRequestFilters(VitroRequest vreq) {
        HashMap<String, List<String>> requestFilters = new HashMap<String, List<String>>();
        Enumeration paramNames = vreq.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String[] filters;
            String paramFilterName = (String)paramNames.nextElement();
            if (StringUtils.isBlank((CharSequence)paramFilterName) || !paramFilterName.startsWith(FILTERS) || (filters = vreq.getParameterValues(paramFilterName)) == null || filters.length <= 0) continue;
            for (String filter : filters) {
                String[] pair = filter.split(":", 2);
                if (pair.length != 2) continue;
                String name = pair[0].replace("\"", "");
                String value = pair[1].replace("\"", "");
                if (requestFilters.containsKey(name)) {
                    List list = (List)requestFilters.get(name);
                    list.add(value);
                    continue;
                }
                requestFilters.put(name, new LinkedList<String>(Arrays.asList(value)));
            }
        }
        return requestFilters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, SearchFilter> readFilterConfigurations(Set<String> currentRoles, VitroRequest vreq) {
        long startTime = System.nanoTime();
        LinkedHashMap<String, SearchFilter> filtersByField = new LinkedHashMap<String, SearchFilter>();
        OntModel model = vreq != null ? ModelAccess.on((HttpServletRequest)vreq).getOntModelSelector(new ModelAccess.OntModelSelectorOption[0]).getDisplayModel() : ModelAccess.getInstance().getOntModelSelector().getDisplayModel();
        if (model == null) {
            return filtersByField;
        }
        model.enterCriticalSection(true);
        try {
            Query facetQuery = QueryFactory.create((String)FILTER_QUERY);
            QueryExecution qexec = QueryExecutionFactory.create((Query)facetQuery, (Model)model);
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                String roleUri;
                FilterValue value;
                QuerySolution solution = results.nextSolution();
                if (solution.get("filter_id") == null || solution.get("field_name") == null || solution.get("filter_type") == null) continue;
                String resultFilterId = solution.get("filter_id").toString();
                String resultFieldName = solution.get("field_name").toString();
                SearchFilter filter = null;
                filter = filtersByField.containsKey(resultFieldName) ? (SearchFilter)filtersByField.get(resultFieldName) : SearchFiltering.createSearchFilter(filtersByField, solution, resultFilterId, resultFieldName);
                if (solution.get("value_id") == null) continue;
                String valueId = solution.get("value_id").toString();
                if (!filter.contains(valueId)) {
                    value = new FilterValue(valueId);
                    value.setName(solution.get("value_label"));
                    value.setOrder(solution.get("value_order"));
                    value.setPubliclyAvailable(solution.get("value_public"));
                    filter.addValue(value);
                }
                value = filter.getValue(valueId);
                RDFNode role = solution.get("role");
                if (role == null || !role.isResource() || !currentRoles.contains(roleUri = role.asResource().getURI())) continue;
                value.setDefault(true);
            }
        }
        finally {
            model.leaveCriticalSection();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(SearchFiltering.getSpentTime(startTime) + "ms spent after FILTER QUERY request."));
        }
        return SearchFiltering.sortFilters(filtersByField);
    }

    public static void addDefaultFilters(SearchQuery query, Set<String> currentRoles) {
        Map<String, SearchFilter> filtersByField = SearchFiltering.readFilterConfigurations(currentRoles, null);
        SearchFiltering.addPreconfiguredFiltersToQuery(query, filtersByField.values());
    }

    public static Map<String, SearchFilter> sortFilters(Map<String, SearchFilter> filters) {
        LinkedList<Map.Entry<String, SearchFilter>> list = new LinkedList<Map.Entry<String, SearchFilter>>(filters.entrySet());
        list.sort(new FilterComparator());
        return list.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b, LinkedHashMap::new));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SearchFilterGroup> readFilterGroupsConfigurations(VitroRequest vreq, Map<String, SearchFilter> filtersById) {
        LinkedHashMap<String, SearchFilterGroup> groups = new LinkedHashMap<String, SearchFilterGroup>();
        OntModel model = ModelAccess.on((HttpServletRequest)vreq).getOntModelSelector(new ModelAccess.OntModelSelectorOption[0]).getDisplayModel();
        model.enterCriticalSection(true);
        try {
            Query facetQuery = QueryFactory.create((String)FILTER_GROUPS_QUERY);
            QueryExecution qexec = QueryExecutionFactory.create((Query)facetQuery, (Model)model);
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution solution = results.nextSolution();
                if (solution.get("filter_id") == null || solution.get("group_label") == null || solution.get("group_id") == null) continue;
                String filterId = solution.get("filter_id").toString();
                String groupId = solution.get("group_id").toString();
                String groupLabel = solution.get("group_label").toString();
                SearchFilterGroup group = null;
                if (groups.containsKey(groupId)) {
                    group = (SearchFilterGroup)groups.get(groupId);
                } else {
                    group = new SearchFilterGroup(groupId, groupLabel);
                    RDFNode publicNode = solution.get("public");
                    if (publicNode != null) {
                        group.setPublic(publicNode.asLiteral().getBoolean());
                    }
                    groups.put(groupId, group);
                }
                group.addFilterId(filterId);
                SearchFilter filter = filtersById.get(filterId);
                if (filter == null || filter.isHidden()) continue;
                group.setHidden(false);
            }
        }
        finally {
            model.leaveCriticalSection();
        }
        return new LinkedList<SearchFilterGroup>(groups.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, SortConfiguration> getSortConfigurations(VitroRequest vreq) {
        LinkedHashMap<String, SortConfiguration> sortConfigurations = new LinkedHashMap<String, SortConfiguration>();
        OntModel model = ModelAccess.on((HttpServletRequest)vreq).getOntModelSelector(new ModelAccess.OntModelSelectorOption[0]).getDisplayModel();
        model.enterCriticalSection(true);
        try {
            Query facetQuery = QueryFactory.create((String)SORT_QUERY);
            QueryExecution qexec = QueryExecutionFactory.create((Query)facetQuery, (Model)model);
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                RDFNode display;
                RDFNode order;
                RDFNode fallback;
                RDFNode isAsc;
                QuerySolution solution = results.nextSolution();
                RDFNode searchFieldNode = solution.get("searchField");
                RDFNode idNode = solution.get("id");
                if (solution.get("label") == null) continue;
                String field = searchFieldNode == null ? "" : searchFieldNode.toString();
                String id = idNode == null ? "" : idNode.toString();
                String label = solution.get("label").asLiteral().getLexicalForm();
                if (sortConfigurations.containsKey(id)) continue;
                SortConfiguration config = new SortConfiguration(id, label, field);
                RDFNode multilingual = solution.get("multilingual");
                if (multilingual != null) {
                    config.setMultilingual(multilingual.asLiteral().getBoolean());
                }
                if ((isAsc = solution.get("isAsc")) != null) {
                    config.setAscOrder(isAsc.asLiteral().getBoolean());
                }
                if ((fallback = solution.get("fallback")) != null && fallback.isLiteral()) {
                    config.setFallback(fallback.asLiteral().toString());
                }
                if ((order = solution.get("sort_order")) != null) {
                    config.setOrder(order.asLiteral().getInt());
                }
                if ((display = solution.get("display")) != null) {
                    config.setDisplay(display.asLiteral().getBoolean());
                }
                sortConfigurations.put(id, config);
            }
        }
        finally {
            model.leaveCriticalSection();
        }
        return sortConfigurations;
    }

    private static SearchFilter createSearchFilter(Map<String, SearchFilter> filtersByField, QuerySolution solution, String resultFilterId, String resultFieldName) {
        RDFNode moreLimit;
        RDFNode facet;
        RDFNode publicNode;
        RDFNode inputRegex;
        RDFNode input;
        RDFNode max;
        RDFNode min;
        SearchFilter filter = new SearchFilter(resultFilterId);
        filtersByField.put(resultFieldName, filter);
        filter.setName(solution.get("filter_label"));
        filter.setOrder(solution.get("filter_order"));
        filter.setType(solution.get("filter_type"));
        if (solution.get("isUri") != null && "true".equals(solution.get("isUri").toString())) {
            filter.setLocalizationRequired(true);
        }
        if ((min = solution.get("min")) != null) {
            filter.setMin(min.asLiteral().toString());
        }
        if ((max = solution.get("max")) != null) {
            filter.setMax(max.asLiteral().toString());
        }
        filter.setField(resultFieldName);
        RDFNode multivalued = solution.get("multivalued");
        if (multivalued != null) {
            filter.setMultivalued(multivalued.asLiteral().getBoolean());
        }
        if ((input = solution.get("input")) != null) {
            filter.setInput(input.asLiteral().getBoolean());
        }
        if ((inputRegex = solution.get("regex")) != null) {
            filter.setInputRegex(inputRegex.asLiteral().getBoolean());
        }
        if ((publicNode = solution.get("public")) != null) {
            filter.setPublic(publicNode.asLiteral().getBoolean());
        }
        if ((facet = solution.get("facet")) != null) {
            filter.setFacetsRequired(facet.asLiteral().getBoolean());
        }
        if ((moreLimit = solution.get("more_limit")) != null && moreLimit.isLiteral()) {
            filter.setMoreLimit(moreLimit.asLiteral().getInt());
        }
        return filter;
    }

    private static void addRangeFilter(SearchQuery query, SearchFilter searchFilter) {
        String rangeText = searchFilter.getRangeText();
        if (StringUtils.isBlank((CharSequence)rangeText)) {
            return;
        }
        query.addFilterQuery(searchFilter.getField() + ":\"" + rangeText + "\"");
    }

    private static void addInputFilter(SearchQuery query, SearchFilter searchFilter) {
        if (StringUtils.isBlank((CharSequence)searchFilter.getInputText()) || "querytext".equals(searchFilter.getId())) {
            return;
        }
        String searchText = searchFilter.getInputText();
        if (searchFilter.isInputRegex()) {
            searchText = searchText.replaceAll("([ )(:])", "\\\\$1") + "*";
            query.addFilterQuery(searchFilter.getField() + ":" + searchText);
        } else {
            query.addFilterQuery(searchFilter.getField() + ":\"" + searchText + "\"");
        }
    }

    static String getFilterInputText(VitroRequest vreq, String name) {
        if ("querytext".equals(name)) {
            return PagedSearchController.getQueryText(vreq);
        }
        String[] values = vreq.getParameterValues(FILTER_INPUT_PREFIX + name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return "";
    }

    static String getFilterRangeText(VitroRequest vreq, String name) {
        String[] values = vreq.getParameterValues(FILTER_RANGE + name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return "";
    }

    public static void setSelectedFilters(Map<String, SearchFilter> filtersByField, Map<String, List<String>> requestFilters) {
        for (SearchFilter filter : filtersByField.values()) {
            List<String> requestValues;
            if (!requestFilters.containsKey(filter.getId()) || SearchFiltering.isEmptyValues(requestValues = requestFilters.get(filter.getId()))) continue;
            filter.setSelected(true);
            for (String requestValue : requestValues) {
                if (!filter.getValues().containsKey(requestValue)) continue;
                FilterValue value = filter.getValue(requestValue);
                value.setSelected(true);
            }
        }
    }

    public static Set<String> getCurrentUserRoles(VitroRequest vreq) {
        UserAccount user = LoginStatusBean.getCurrentUser((HttpServletRequest)vreq);
        if (user == null) {
            return Collections.singleton("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PUBLIC");
        }
        return user.getPermissionSetUris();
    }

    static boolean isEmptyValues(List<String> requestedValues) {
        if (requestedValues.isEmpty()) {
            return true;
        }
        for (String value : requestedValues) {
            if (StringUtils.isBlank((CharSequence)value)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getUriLabel(String uri, VitroRequest vreq) {
        String result = "";
        OntModel model = ModelAccess.on((HttpServletRequest)vreq).getOntModelSelector(new ModelAccess.OntModelSelectorOption[0]).getFullModel();
        model.enterCriticalSection(true);
        try {
            QuerySolutionMap initialBindings = new QuerySolutionMap();
            initialBindings.add("uri", (RDFNode)ResourceFactory.createResource((String)uri));
            Query facetQuery = QueryFactory.create((String)LABEL_QUERY);
            QueryExecution qexec = QueryExecutionFactory.create((Query)facetQuery, (Model)model, (QuerySolution)initialBindings);
            ResultSet results = qexec.execSelect();
            if (results.hasNext()) {
                QuerySolution solution = results.nextSolution();
                RDFNode rdfNode = solution.get("label");
                Literal literal = rdfNode.asLiteral();
                result = literal.getLexicalForm();
            } else {
                result = uri;
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        finally {
            model.leaveCriticalSection();
        }
        return result;
    }

    static void addFacetFieldsToQuery(Map<String, SearchFilter> filters, SearchQuery query) {
        for (String fieldId : filters.keySet()) {
            SearchFilter filter = filters.get(fieldId);
            if (!filter.isFacetsRequired()) continue;
            query.addFacetFields(fieldId);
        }
    }

    public static Map<String, SearchFilter> getFiltersById(Map<String, SearchFilter> filtersByField) {
        Map<String, SearchFilter> filtersById = filtersByField.values().stream().collect(Collectors.toMap(SearchFilter::getId, Function.identity()));
        return filtersById;
    }

    static Map<String, SearchFilter> getFiltersForTemplate(Map<String, SearchFilter> filtersByField) {
        for (Map.Entry<String, SearchFilter> entry : filtersByField.entrySet()) {
            SearchFilter searchFilter = entry.getValue();
            searchFilter.removeValuesWithZeroCount();
            if (!searchFilter.isEmpty()) continue;
            searchFilter.setHidden(true);
        }
        return filtersByField.values().stream().collect(Collectors.toMap(SearchFilter::getId, Function.identity()));
    }

    static void addFiltersToPageLinks(VitroRequest vreq, UrlBuilder.ParamMap pagingLinkParams, Enumeration<String> paramNames) {
        while (paramNames.hasMoreElements()) {
            String[] values;
            String paramFilterName = paramNames.nextElement();
            if (StringUtils.isBlank((CharSequence)paramFilterName) || !paramFilterName.startsWith(FILTERS) && !paramFilterName.startsWith(FILTER_RANGE) && !paramFilterName.startsWith(FILTER_INPUT_PREFIX) && !paramFilterName.startsWith("sort") || (values = vreq.getParameterValues(paramFilterName)).length <= 0) continue;
            pagingLinkParams.put(paramFilterName, values[0]);
        }
    }

    private static long getSpentTime(long startTime) {
        return (System.nanoTime() - startTime) / 1000000L;
    }

    public static class FilterComparator
    implements Comparator<Map.Entry<String, SearchFilter>> {
        @Override
        public int compare(Map.Entry<String, SearchFilter> obj1, Map.Entry<String, SearchFilter> obj2) {
            SearchFilter filter1 = obj1.getValue();
            SearchFilter filter2 = obj2.getValue();
            int result = filter1.getOrder().compareTo(filter2.getOrder());
            if (result == 0) {
                return filter1.getName().toLowerCase().compareTo(filter2.getName().toLowerCase());
            }
            return result;
        }
    }
}

