/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.search.controller;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.api.NotAuthorizedToUseApiException;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ExceptionResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.modules.searchIndexer.SearchIndexer;
import edu.cornell.mannlib.vitro.webapp.search.controller.UpdateUrisInIndex;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="SearchServiceController", urlPatterns={"/searchService/*"})
public class SearchServiceController
extends FreemarkerHttpServlet {
    private static final Log log = LogFactory.getLog(SearchServiceController.class);

    @Override
    public long maximumMultipartFileSize() {
        return 0x40000000L;
    }

    @Override
    protected ResponseValues processRequest(VitroRequest req) {
        try {
            this.confirmAuthorization(req);
            switch (this.figureActionVerb(req)) {
                case UPDATE_URIS_IN_SEARCH: {
                    return this.doUpdateUrisInSearch((HttpServletRequest)req);
                }
            }
            return this.doHelpForm();
        }
        catch (NotAuthorizedToUseApiException e) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("errorMessage", e.getMessage());
            return new TemplateResponseValues("error-message.ftl", map, 403);
        }
        catch (Exception e) {
            return new ExceptionResponseValues(e, 500);
        }
    }

    private ResponseValues doUpdateUrisInSearch(HttpServletRequest req) throws IOException, ServletException {
        SearchIndexer indexer = ApplicationUtils.instance().getSearchIndexer();
        int uriCount = new UpdateUrisInIndex().doUpdateUris(req, indexer);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("msg", "Received " + uriCount + " URIs.");
        return new TemplateResponseValues("searchService-help.ftl", body);
    }

    private ResponseValues doHelpForm() {
        return new TemplateResponseValues("searchService-help.ftl");
    }

    private void confirmAuthorization(VitroRequest vreq) throws NotAuthorizedToUseApiException {
        Verb verb = this.figureActionVerb(vreq);
        String pw = vreq.getParameter("password");
        String email = vreq.getParameter("email");
        if (verb == Verb.VIEW_HELP_FORM) {
            return;
        }
        if (PolicyHelper.isAuthorizedForActions((HttpServletRequest)vreq, email, pw, SimplePermission.MANAGE_SEARCH_INDEX.ACTION)) {
            return;
        }
        throw new NotAuthorizedToUseApiException(email + " is not authorized to manage the search index.");
    }

    private Verb figureActionVerb(VitroRequest vreq) {
        String pathInfo = vreq.getPathInfo();
        if (pathInfo == null) {
            pathInfo = "";
        }
        if (pathInfo.startsWith("/")) {
            pathInfo = pathInfo.substring(1);
        }
        return Verb.fromString(pathInfo);
    }

    public static enum Verb {
        VIEW_HELP_FORM("viewHelpForm"),
        UPDATE_URIS_IN_SEARCH("updateUrisInSearch");

        public final String verb;

        private Verb(String verb) {
            this.verb = verb;
        }

        static Verb fromString(String s) {
            for (Verb v : Verb.values()) {
                if (!v.verb.equals(s)) continue;
                return v;
            }
            return VIEW_HELP_FORM;
        }
    }
}

