/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.search.controller;

import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchQuery;
import java.util.Locale;

public class SortConfiguration {
    private String id = "";
    private String field = "";
    private boolean multilingual = false;
    private boolean ascOrder = false;
    private boolean selected = false;
    private String label = "";
    private int order = 0;
    private String fallback;
    private boolean display = false;

    public SortConfiguration(String id, String label, String field) {
        this.id = id;
        this.setLabel(label);
        this.field = field;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public boolean isMultilingual() {
        return this.multilingual;
    }

    public void setMultilingual(boolean multilingual) {
        this.multilingual = multilingual;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getField(Locale locale) {
        String languageTag = locale.toLanguageTag();
        if (this.multilingual) {
            return languageTag + this.field;
        }
        return this.field;
    }

    public SearchQuery.Order getSortOrder() {
        if (this.ascOrder) {
            return SearchQuery.Order.ASC;
        }
        return SearchQuery.Order.DESC;
    }

    public void setAscOrder(boolean ascOrder) {
        this.ascOrder = ascOrder;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getFallback() {
        return this.fallback;
    }

    public void setFallback(String id) {
        this.fallback = id;
    }

    public void setDisplay(boolean display) {
        this.display = display;
    }

    public boolean isDisplay() {
        return this.display;
    }
}

