/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchengine.solr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrClient;
import org.apache.solr.client.solrj.request.schema.FieldTypeDefinition;
import org.apache.solr.client.solrj.request.schema.SchemaRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.schema.SchemaResponse;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.SimpleOrderedMap;

public class SolrFieldInitializer {
    private static Log log = LogFactory.getLog(SolrFieldInitializer.class);
    private static final String DATE_RANGE_FIELD_TYPE = "dateRange";

    static void initializeFields(SolrClient queryEngine, ConcurrentUpdateSolrClient updateEngine) throws Exception {
        SolrFieldInitializer.initializeStringFields(queryEngine, updateEngine);
        SolrFieldInitializer.initializeDateRangeFields(queryEngine, updateEngine);
    }

    private static void initializeStringFields(SolrClient queryEngine, ConcurrentUpdateSolrClient updateEngine) throws Exception {
        HashSet<String> fieldSuffixes = new HashSet<String>(Arrays.asList("_label_sort", "_label_display"));
        SolrFieldInitializer.excludeMatchedFields(fieldSuffixes, queryEngine, "dynamicFields");
        SolrFieldInitializer.excludeMatchedFields(fieldSuffixes, queryEngine, "fields");
        SolrFieldInitializer.createStringFields(fieldSuffixes, updateEngine);
    }

    private static void createStringFields(Set<String> fieldSuffixes, ConcurrentUpdateSolrClient updateEngine) throws Exception {
        for (String suffix : fieldSuffixes) {
            Map<String, Object> fieldAttributes = SolrFieldInitializer.getFieldAttributes(suffix);
            SchemaRequest.AddDynamicField request = new SchemaRequest.AddDynamicField(fieldAttributes);
            SchemaResponse.UpdateResponse response = (SchemaResponse.UpdateResponse)request.process((SolrClient)updateEngine);
            if (response.getStatus() != 0) {
                throw new SolrFieldCreationException("Creation of missing solr field '*" + suffix + "' failed");
            }
            log.info((Object)("Solr dynamic field '*" + suffix + "' has been created."));
        }
    }

    private static Map<String, Object> getFieldAttributes(String suffix) {
        HashMap<String, Object> fieldAttributes = new HashMap<String, Object>();
        fieldAttributes.put("type", "string");
        fieldAttributes.put("stored", "true");
        fieldAttributes.put("indexed", "true");
        fieldAttributes.put("name", "*" + suffix);
        return fieldAttributes;
    }

    private static void excludeMatchedFields(Set<String> fieldSuffixes, SolrClient queryEngine, String fieldType) throws Exception {
        SolrQuery query = new SolrQuery();
        query.add("qt", new String[]{"/schema/" + fieldType.toLowerCase()});
        QueryResponse response = queryEngine.query((SolrParams)query);
        ArrayList fieldList = (ArrayList)response.getResponse().get(fieldType);
        if (fieldList == null) {
            return;
        }
        HashSet<String> it = new HashSet<String>(fieldSuffixes);
        for (String target : it) {
            for (SimpleOrderedMap field : fieldList) {
                String fieldName = (String)field.get("name");
                if (!fieldName.endsWith(target)) continue;
                fieldSuffixes.remove(target);
            }
        }
    }

    private static void initializeDateRangeFields(SolrClient queryEngine, ConcurrentUpdateSolrClient updateEngine) throws Exception {
        if (!SolrFieldInitializer.isFieldTypeExists(DATE_RANGE_FIELD_TYPE, queryEngine, updateEngine)) {
            log.info((Object)"Solr field type 'dateRange' not found. Trying to create.");
            SolrFieldInitializer.createDateRangeFieldType(updateEngine);
        }
        if (!SolrFieldInitializer.isDynamicFieldExists("*_drsim", queryEngine, updateEngine)) {
            log.info((Object)"Solr dynamic field '*_drsim' of type dateRange not found. Trying to create.");
            SolrFieldInitializer.createDateRangeField("_drsim", updateEngine);
        }
    }

    private static boolean isFieldTypeExists(String typeName, SolrClient queryEngine, ConcurrentUpdateSolrClient updateEngine) throws Exception {
        try {
            SolrQuery query = new SolrQuery();
            query.add("qt", new String[]{"/schema/fieldtypes"});
            QueryResponse response = queryEngine.query((SolrParams)query);
            ArrayList typeList = (ArrayList)response.getResponse().get("fieldTypes");
            if (typeList == null) {
                return false;
            }
            for (SimpleOrderedMap type : typeList) {
                String name = (String)type.get("name");
                if (!name.equals(typeName)) continue;
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return false;
    }

    private static boolean isDynamicFieldExists(String fieldName, SolrClient queryEngine, ConcurrentUpdateSolrClient updateEngine) throws Exception {
        try {
            SolrQuery query = new SolrQuery();
            query.add("qt", new String[]{"/schema/dynamicfields"});
            QueryResponse response = queryEngine.query((SolrParams)query);
            ArrayList fieldList = (ArrayList)response.getResponse().get("dynamicFields");
            if (fieldList == null) {
                return false;
            }
            for (SimpleOrderedMap field : fieldList) {
                String name = (String)field.get("name");
                if (!name.equals(fieldName)) continue;
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return false;
    }

    private static void createDateRangeFieldType(ConcurrentUpdateSolrClient updateEngine) throws Exception {
        SchemaRequest.AddFieldType fieldTyperequest = new SchemaRequest.AddFieldType(SolrFieldInitializer.getDateRangeFieldTypeDefinition());
        SchemaResponse.UpdateResponse response = (SchemaResponse.UpdateResponse)fieldTyperequest.process((SolrClient)updateEngine);
        if (response.getStatus() != 0) {
            throw new SolrFieldCreationException("Creation of missing solr field type 'dateRange' failed");
        }
        log.info((Object)"Solr field type 'dateRange' has been created.");
    }

    private static void createDateRangeField(String suffix, ConcurrentUpdateSolrClient updateEngine) throws Exception {
        Map<String, Object> fieldAttributes = SolrFieldInitializer.getDateRangeFieldAttributes(suffix);
        SchemaRequest.AddDynamicField dynamicFieldrequest = new SchemaRequest.AddDynamicField(fieldAttributes);
        SchemaResponse.UpdateResponse response = (SchemaResponse.UpdateResponse)dynamicFieldrequest.process((SolrClient)updateEngine);
        if (response.getStatus() != 0) {
            throw new SolrFieldCreationException("Creation of missing solr field '*" + suffix + "' failed");
        }
        log.info((Object)"Solr dateRange dynamic field '*_drsim' has been created.");
    }

    private static FieldTypeDefinition getDateRangeFieldTypeDefinition() {
        HashMap<String, String> fieldAttributes = new HashMap<String, String>();
        fieldAttributes.put("class", "solr.DateRangeField");
        fieldAttributes.put("name", DATE_RANGE_FIELD_TYPE);
        FieldTypeDefinition ftd = new FieldTypeDefinition();
        ftd.setAttributes(fieldAttributes);
        return ftd;
    }

    private static Map<String, Object> getDateRangeFieldAttributes(String suffix) {
        HashMap<String, Object> fieldAttributes = new HashMap<String, Object>();
        fieldAttributes.put("type", DATE_RANGE_FIELD_TYPE);
        fieldAttributes.put("stored", "true");
        fieldAttributes.put("indexed", "true");
        fieldAttributes.put("name", "*" + suffix);
        return fieldAttributes;
    }

    public static class SolrFieldCreationException
    extends RuntimeException {
        public SolrFieldCreationException(String message) {
            super(message);
        }
    }
}

