/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.servlet.setup;

import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.VitroModelFactory;
import edu.cornell.mannlib.vitro.webapp.servlet.setup.RDFFilesLoader;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Model;

public class ConfigurationModelsSetup
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(ConfigurationModelsSetup.class);

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext ctx = sce.getServletContext();
        StartupStatus ss = StartupStatus.getBean(ctx);
        try {
            this.setupModel(ctx, "http://vitro.mannlib.cornell.edu/default/vitro-kb-displayMetadata", "display");
            this.setupModel(ctx, "http://vitro.mannlib.cornell.edu/default/vitro-kb-displayMetadataTBOX", "displayTbox");
            this.setupModel(ctx, "http://vitro.mannlib.cornell.edu/default/vitro-kb-displayMetadata-displayModel", "displayDisplay");
            this.setupModel(ctx, "http://vitro.mannlib.cornell.edu/default/vitro-kb-userAccounts", "auth");
            this.setupModel(ctx, "http://vitro.mannlib.cornell.edu/default/access-control", "accessControl");
            this.setupModel(ctx, "http://vitro.mannlib.cornell.edu/default/interface-i18n", "interface-i18n");
            ss.info(this, "Set up the display models and the user accounts model.");
        }
        catch (Exception e) {
            ss.fatal(this, e.getMessage(), e.getCause());
        }
    }

    private void setupModel(ServletContext ctx, String modelUri, String modelPath) {
        try {
            OntModel ontModel = ModelAccess.on(ctx).getOntModel(modelUri);
            if (ontModel.isEmpty()) {
                this.loadFirstTimeFiles(ctx, modelPath, ontModel);
                OntModel baseModelFirsttime = ModelAccess.on(ctx).getOntModel(modelUri + "FirsttimeBackup");
                baseModelFirsttime.add((Model)ontModel);
            } else {
                this.applyFirstTimeChanges(ctx, modelPath, modelUri, ontModel);
            }
            this.loadEveryTimeFiles(ctx, modelPath, ontModel);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create the '" + modelPath + "' model (" + modelUri + ").", e);
        }
    }

    private void loadFirstTimeFiles(ServletContext ctx, String modelPath, OntModel baseModel) {
        RDFFilesLoader.loadFirstTimeFiles(ctx, modelPath, (Model)baseModel, baseModel.isEmpty());
    }

    private void loadEveryTimeFiles(ServletContext ctx, String modelPath, OntModel memoryModel) {
        RDFFilesLoader.loadEveryTimeFiles(ctx, modelPath, memoryModel);
    }

    private void applyFirstTimeChanges(ServletContext ctx, String modelPath, String modelUri, OntModel userModel) {
        log.info((Object)("Reload firsttime files on start-up if changed: '" + modelPath + "', URI: '" + modelUri + "'"));
        boolean updatedFiles = false;
        OntModel baseModelFirsttimeBackup = ModelAccess.on(ctx).getOntModel(modelUri + "FirsttimeBackup");
        log.debug((Object)("compare firsttime files with configuration models (backup from first start) for " + modelPath));
        OntModel baseModelFirsttime = VitroModelFactory.createOntologyModel();
        RDFFilesLoader.loadFirstTimeFiles(ctx, modelPath, (Model)baseModelFirsttime, true);
        if (RDFFilesLoader.areIsomporphic((Model)baseModelFirsttime, (Model)baseModelFirsttimeBackup)) {
            log.debug((Object)("They are the same, so do nothing: '" + modelPath + "'"));
        } else {
            log.debug((Object)("They differ:" + modelPath + ", compare values in configuration models with user's triplestore"));
            updatedFiles = this.applyChanges((Model)baseModelFirsttimeBackup, (Model)baseModelFirsttime, (Model)userModel, modelPath);
            if (updatedFiles) {
                log.info((Object)("The model was updated, " + modelPath));
            }
        }
    }

    private boolean applyChanges(Model baseModel, Model newModel, Model userModel, String modelIdString) {
        boolean updatedFiles = false;
        StringWriter out = new StringWriter();
        StringWriter out2 = new StringWriter();
        Model difOldNew = baseModel.difference(newModel);
        Model difNewOld = newModel.difference(baseModel);
        if (modelIdString.equals("display")) {
            RDFFilesLoader.removeBlankTriples(difOldNew);
            RDFFilesLoader.removeBlankTriples(difNewOld);
        }
        if (difOldNew.isEmpty() && difNewOld.isEmpty()) {
            log.debug((Object)("For the " + modelIdString + " model, there is no difference in both directions. So do nothing."));
        } else {
            if (!difOldNew.isEmpty()) {
                difOldNew.write((Writer)out, "TTL");
                log.debug((Object)("Difference for " + modelIdString + " (old -> new), these triples should be removed: " + out));
                RDFFilesLoader.removeChangesThatConflictWithUIEdits(baseModel, userModel, difOldNew);
                if (userModel.containsAny(difOldNew)) {
                    log.debug((Object)"Some of these triples are in the user triples store, so they will be removed now");
                    userModel.remove(difOldNew);
                    updatedFiles = true;
                }
                baseModel.remove(difOldNew);
            }
            if (!difNewOld.isEmpty()) {
                difNewOld.write((Writer)out2, "TTL");
                log.debug((Object)("Difference for " + modelIdString + " (new -> old), these triples should be added: " + out2));
                RDFFilesLoader.removeChangesThatConflictWithUIEdits(baseModel, userModel, difNewOld);
                if (!userModel.containsAll(difNewOld)) {
                    log.debug((Object)"Some of these triples are not in the user triples store, so they will be added now");
                    Model tmp = difNewOld.difference(userModel);
                    userModel.add(tmp);
                    updatedFiles = true;
                }
                baseModel.add(difNewOld);
            }
        }
        return updatedFiles;
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

