/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.triplesource.impl.tdb;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceDataset;
import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceModelMaker;
import edu.cornell.mannlib.vitro.webapp.modelaccess.adapters.MemoryMappingModelMaker;
import edu.cornell.mannlib.vitro.webapp.modelaccess.adapters.ModelMakerWithPersistentEmptyModels;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ontmodels.OntModelCache;
import edu.cornell.mannlib.vitro.webapp.modules.Application;
import edu.cornell.mannlib.vitro.webapp.modules.ComponentStartupStatus;
import edu.cornell.mannlib.vitro.webapp.modules.tripleSource.ConfigurationTripleSource;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceFactory;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceFactorySingle;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.tdb.RDFServiceTDB;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.logging.LoggingRDFServiceFactory;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.ModelMaker;
import org.apache.jena.tdb.TDB;

public class ConfigurationTripleSourceTDB
extends ConfigurationTripleSource {
    private static final String DIRECTORY_TDB = "tdbModels";
    private volatile RDFService rdfService;
    private RDFServiceFactory rdfServiceFactory;
    private RDFService unclosableRdfService;
    private Dataset dataset;
    private ModelMaker modelMaker;

    @Override
    public void startup(Application application, ComponentStartupStatus ss) {
        this.configureTDB();
        Path vitroHome = ApplicationUtils.instance().getHomeDirectory().getPath();
        String tdbPath = vitroHome.resolve(DIRECTORY_TDB).toString();
        try {
            this.rdfService = new RDFServiceTDB(tdbPath);
            this.rdfServiceFactory = this.createRDFServiceFactory();
            this.unclosableRdfService = this.rdfServiceFactory.getRDFService();
            this.dataset = new RDFServiceDataset(this.unclosableRdfService);
            this.modelMaker = this.createModelMaker();
            ss.info("Initialized the RDF source for TDB");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to set up the RDF source for TDB", e);
        }
    }

    private void configureTDB() {
        TDB.getContext().setTrue(TDB.symUnionDefaultGraph);
    }

    private RDFServiceFactory createRDFServiceFactory() {
        return new LoggingRDFServiceFactory(new RDFServiceFactorySingle(this.rdfService));
    }

    private ModelMaker createModelMaker() {
        ModelMakerWithPersistentEmptyModels longTermModelMaker = new ModelMakerWithPersistentEmptyModels(new MemoryMappingModelMaker(new RDFServiceModelMaker(this.unclosableRdfService), CONFIGURATION_MODELS));
        return this.addConfigurationDecorators(longTermModelMaker);
    }

    @Override
    public RDFServiceFactory getRDFServiceFactory() {
        return this.rdfServiceFactory;
    }

    @Override
    public RDFService getRDFService() {
        return this.unclosableRdfService;
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public ModelMaker getModelMaker() {
        return this.modelMaker;
    }

    @Override
    public OntModelCache getShortTermOntModels(RDFService shortTermRdfService, OntModelCache longTermOntModelCache) {
        return longTermOntModelCache;
    }

    public String toString() {
        return "ConfigurationTripleSourceTDB[" + ToString.hashHex(this) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(Application application) {
        ConfigurationTripleSourceTDB configurationTripleSourceTDB = this;
        synchronized (configurationTripleSourceTDB) {
            if (this.rdfService != null) {
                this.rdfService.close();
                this.rdfService = null;
            }
        }
    }
}

