/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.dataGetter;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.jena.JenaIngestController;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetter;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.rdf.model.Model;

public abstract class DataGetterBase
implements DataGetter {
    public static final String REQUEST_DISPLAY_MODEL = "vitro:requestDisplayModel";
    public static final String REQUEST_JENA_ONT_MODEL = "vitro:requestJenaOntModel";
    public static final String CONTEXT_DISPLAY_MODEL = "vitro:contextDisplayModel";

    protected Model getModel(VitroRequest vreq, String modelName) {
        if (StringUtils.isEmpty((CharSequence)modelName)) {
            return vreq.getJenaOntModel();
        }
        if (REQUEST_DISPLAY_MODEL.equals(modelName)) {
            return vreq.getDisplayModel();
        }
        if (REQUEST_JENA_ONT_MODEL.equals(modelName)) {
            return vreq.getJenaOntModel();
        }
        if (CONTEXT_DISPLAY_MODEL.equals(modelName)) {
            return ModelAccess.getInstance().getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-displayMetadata");
        }
        Model model = JenaIngestController.getModel(modelName, (HttpServletRequest)vreq);
        if (model == null) {
            throw new IllegalAccessError("Cannot get model <" + modelName + "> for DataGetter.");
        }
        return model;
    }
}

