/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.dataGetter;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.jena.QueryUtils;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetter;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetterBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.sparql.ARQException;

public class SparqlQueryDataGetter
extends DataGetterBase
implements DataGetter {
    private static final Log log = LogFactory.getLog(SparqlQueryDataGetter.class);
    private static final String queryPropertyURI = "<http://vitro.mannlib.cornell.edu/ontologies/display/1.1#query>";
    private static final String saveToVarPropertyURI = "<http://vitro.mannlib.cornell.edu/ontologies/display/1.1#saveToVar>";
    private static final String queryModelPropertyURI = "<http://vitro.mannlib.cornell.edu/ontologies/display/1.1#queryModel>";
    private static final String uriParam = "<http://vitro.mannlib.cornell.edu/ontologies/display/1.1#uri>";
    private static final String stringParam = "<http://vitro.mannlib.cornell.edu/ontologies/display/1.1#string>";
    private static final String intParam = "<http://vitro.mannlib.cornell.edu/ontologies/display/1.1#int>";
    private static final String longParam = "<http://vitro.mannlib.cornell.edu/ontologies/display/1.1#long>";
    private static final String floatParam = "<http://vitro.mannlib.cornell.edu/ontologies/display/1.1#float>";
    private static final String doubleParam = "<http://vitro.mannlib.cornell.edu/ontologies/display/1.1#double>";
    private static final String booleanParam = "<http://vitro.mannlib.cornell.edu/ontologies/display/1.1#boolean>";
    public static final String defaultVarNameForResults = "results";
    private static final String defaultTemplate = "menupage--defaultSparql.ftl";
    String dataGetterURI;
    String queryText;
    String saveToVar;
    String modelURI;
    Set<String> uriParams = new HashSet<String>();
    Set<String> stringParams = new HashSet<String>();
    Set<String> intParams = new HashSet<String>();
    Set<String> longParams = new HashSet<String>();
    Set<String> floatParams = new HashSet<String>();
    Set<String> doubleParams = new HashSet<String>();
    Set<String> booleanParams = new HashSet<String>();
    VitroRequest vreq;
    private static final String dataGetterQuery = "PREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \nSELECT ?query ?saveToVar ?queryModel ?uriParam ?stringParam ?intParam ?longParam ?floatParam ?doubleParam ?booleanParam \nWHERE { \n  ?dataGetterURI <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#query> ?query . \n  OPTIONAL{ ?dataGetterURI <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#saveToVar> ?saveToVar } \n   OPTIONAL{ ?dataGetterURI <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#queryModel> ?queryModel } \n  OPTIONAL{ ?dataGetterURI <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#uri> ?uriParam } \n  OPTIONAL{ ?dataGetterURI <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#string> ?stringParam } \n  OPTIONAL{ ?dataGetterURI <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#int> ?intParam } \n  OPTIONAL{ ?dataGetterURI <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#long> ?longParam } \n  OPTIONAL{ ?dataGetterURI <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#float> ?floatParam } \n  OPTIONAL{ ?dataGetterURI <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#double> ?doubleParam } \n  OPTIONAL{ ?dataGetterURI <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#boolean> ?booleanParam } \n}";

    public SparqlQueryDataGetter(VitroRequest vreq, Model displayModel, String dataGetterURI) {
        this.configure(vreq, displayModel, dataGetterURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configure(VitroRequest vreq, Model displayModel, String dataGetterURI) {
        if (vreq == null) {
            throw new IllegalArgumentException("VitroRequest  may not be null.");
        }
        if (displayModel == null) {
            throw new IllegalArgumentException("Display Model may not be null.");
        }
        if (dataGetterURI == null) {
            throw new IllegalArgumentException("PageUri may not be null.");
        }
        this.vreq = vreq;
        this.dataGetterURI = dataGetterURI;
        QuerySolutionMap initBindings = new QuerySolutionMap();
        initBindings.add("dataGetterURI", (RDFNode)ResourceFactory.createResource((String)this.dataGetterURI));
        Query dataGetterConfigurationQuery = QueryFactory.create((String)dataGetterQuery);
        displayModel.enterCriticalSection(true);
        try {
            QueryExecution qexec = QueryExecutionFactory.create((Query)dataGetterConfigurationQuery, (Model)displayModel, (QuerySolution)initBindings);
            ResultSet res = qexec.execSelect();
            try {
                while (res.hasNext()) {
                    QuerySolution soln = res.next();
                    Literal value = soln.getLiteral("query");
                    if (dataGetterConfigurationQuery == null) {
                        log.error((Object)("no query defined for page " + this.dataGetterURI));
                    } else {
                        this.queryText = value.getLexicalForm();
                    }
                    RDFNode node = soln.get("queryModel");
                    this.modelURI = node != null && node.isURIResource() ? node.asResource().getURI() : (node != null && node.isLiteral() ? node.asLiteral().getLexicalForm() : null);
                    Literal saveTo = soln.getLiteral("saveToVar");
                    this.saveToVar = saveTo != null && saveTo.isLiteral() ? saveTo.asLiteral().getLexicalForm() : defaultVarNameForResults;
                    this.addTypedParameter("uriParam", this.uriParams, soln);
                    this.addTypedParameter("stringParam", this.stringParams, soln);
                    this.addTypedParameter("intParam", this.intParams, soln);
                    this.addTypedParameter("longParam", this.longParams, soln);
                    this.addTypedParameter("floatParam", this.floatParams, soln);
                    this.addTypedParameter("doubleParam", this.doubleParams, soln);
                    this.addTypedParameter("booleanParam", this.booleanParams, soln);
                }
            }
            finally {
                qexec.close();
            }
        }
        finally {
            displayModel.leaveCriticalSection();
        }
    }

    private void addTypedParameter(String name, Set<String> set, QuerySolution soln) {
        String uriParam;
        RDFNode uriNode = soln.get(name);
        if (uriNode != null && uriNode.isLiteral() && !StringUtils.isBlank((CharSequence)(uriParam = uriNode.asLiteral().getLexicalForm()))) {
            set.add(uriParam);
        }
    }

    @Override
    public Map<String, Object> getData(Map<String, Object> pageData) {
        Map<String, String> merged = this.mergeParameters(this.vreq.getParameterMap(), pageData);
        merged = this.filterUnavailableParameters(merged);
        String boundQueryText = this.bindParameters(this.queryText, merged);
        if (this.modelURI != null) {
            Model modelByUri = this.getModel(this.vreq, this.modelURI);
            return this.doQueryOnModel(boundQueryText, modelByUri);
        }
        return this.doQueryOnRDFService(boundQueryText);
    }

    protected Map<String, String> filterUnavailableParameters(Map<String, String> merged) {
        return merged.entrySet().stream().filter(entry -> this.queryText.contains("?" + (String)entry.getKey())).collect(Collectors.toMap(map -> (String)map.getKey(), map -> (String)map.getValue()));
    }

    private Map<String, String> mergeParameters(Map<String, String[]> parameterMap, Map<String, Object> pageData) {
        HashMap<String, String> merged = new HashMap<String, String>();
        for (String key : parameterMap.keySet()) {
            merged.put(key, parameterMap.get(key)[0]);
        }
        for (String key : pageData.keySet()) {
            merged.put(key, String.valueOf(pageData.get(key)));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Merging request parameters " + parameterMap + " with page data " + pageData + " results in " + merged));
        }
        return merged;
    }

    private String bindParameters(String text, Map<String, String> parameters) {
        ParameterizedSparqlString queryText = new ParameterizedSparqlString(text);
        if (!this.isLegacyMode()) {
            this.substitute(parameters, this.uriParams, queryText, (pss, key, value) -> pss.setIri(key, value));
            this.substitute(parameters, this.stringParams, queryText, (pss, key, value) -> pss.setLiteral(key, value));
            this.substitute(parameters, this.intParams, queryText, (pss, key, value) -> pss.setLiteral(key, Integer.parseInt(value)));
            this.substitute(parameters, this.longParams, queryText, (pss, key, value) -> pss.setLiteral(key, Long.parseLong(value)));
            this.substitute(parameters, this.floatParams, queryText, (pss, key, value) -> pss.setLiteral(key, Float.parseFloat(value)));
            this.substitute(parameters, this.doubleParams, queryText, (pss, key, value) -> pss.setLiteral(key, Double.parseDouble(value)));
            this.substitute(parameters, this.booleanParams, queryText, (pss, key, value) -> pss.setLiteral(key, Boolean.parseBoolean(value)));
        } else {
            this.substitute(parameters, parameters.keySet(), queryText, (pss, key, value) -> pss.setIri(key, value));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("parameters: " + parameters));
            log.debug((Object)("query before binding parameters:" + text));
            log.debug((Object)("query after binding parameters: " + queryText.toString()));
        }
        return queryText.toString();
    }

    private void substitute(Map<String, String> parameters, Set<String> keys, ParameterizedSparqlString pss, Substitution<ParameterizedSparqlString, String, String> substitution) {
        for (String key : keys) {
            String value = parameters.get(key);
            if (value == null) continue;
            try {
                substitution.apply(pss, key, value);
            }
            catch (ARQException arcException) {
                log.error((Object)String.format("Exception happend while trying to substitute value %s of variable %s in query\n%s", value, key, pss.toString()));
                throw arcException;
            }
        }
    }

    private boolean isLegacyMode() {
        return this.uriParams.isEmpty() && this.stringParams.isEmpty() && this.intParams.isEmpty() && this.longParams.isEmpty() && this.floatParams.isEmpty() && this.doubleParams.isEmpty() && this.booleanParams.isEmpty();
    }

    protected Map<String, Object> doQueryOnRDFService(String q) {
        log.debug((Object)("Going to RDFService with " + q));
        ResultSet results = QueryUtils.getQueryResults(q, this.vreq);
        return this.assembleMap(this.parseResults(results));
    }

    protected Map<String, Object> doQueryOnModel(String q, Model queryModel) {
        log.debug((Object)("Going to model " + this.modelURI + " with " + q));
        if (q == null) {
            return Collections.emptyMap();
        }
        Query query = this.makeQuery(q);
        if (query == null) {
            return Collections.emptyMap();
        }
        return this.assembleMap(this.executeQuery(query, queryModel));
    }

    private Query makeQuery(String q) {
        try {
            return QueryFactory.create((String)q);
        }
        catch (Exception e) {
            log.error((Object)"Failed to build a query from ''", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, String>> executeQuery(Query query, Model model) {
        model.enterCriticalSection(true);
        try {
            List<Map<String, String>> list;
            QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)model);
            ResultSet results = qexec.execSelect();
            try {
                list = this.parseResults(results);
            }
            catch (Throwable throwable) {
                qexec.close();
                throw throwable;
            }
            qexec.close();
            return list;
        }
        finally {
            model.leaveCriticalSection();
        }
    }

    private List<Map<String, String>> parseResults(ResultSet results) {
        ArrayList<Map<String, String>> rows = new ArrayList<Map<String, String>>();
        while (results.hasNext()) {
            QuerySolution soln = results.nextSolution();
            rows.add(this.toRow(soln));
        }
        return rows;
    }

    private Map<String, String> toRow(QuerySolution soln) {
        HashMap<String, String> row = new HashMap<String, String>();
        Iterator varNames = soln.varNames();
        while (varNames.hasNext()) {
            String varname = (String)varNames.next();
            row.put(varname, this.toCell(soln.get(varname)));
        }
        return row;
    }

    private String toCell(RDFNode rdfNode) {
        if (rdfNode == null) {
            return "";
        }
        if (rdfNode.isLiteral()) {
            return rdfNode.asLiteral().getLexicalForm();
        }
        if (rdfNode.isResource()) {
            Resource resource = (Resource)rdfNode;
            if (!resource.isAnon()) {
                return resource.getURI();
            }
            return resource.getId().getLabelString();
        }
        return rdfNode.toString();
    }

    private Map<String, Object> assembleMap(List<Map<String, String>> results) {
        HashMap<String, Object> rmap = new HashMap<String, Object>();
        rmap.put(this.saveToVar, results);
        rmap.put("variableName", this.saveToVar);
        rmap.put("bodyTemplate", defaultTemplate);
        return rmap;
    }

    @FunctionalInterface
    static interface Substitution<Pss, Key, Value> {
        public void apply(ParameterizedSparqlString var1, String var2, String var3);
    }
}

