/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.developer;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.ajax.VitroAjaxController;
import edu.cornell.mannlib.vitro.webapp.services.freemarker.FreemarkerProcessingService;
import edu.cornell.mannlib.vitro.webapp.services.freemarker.FreemarkerProcessingServiceSetup;
import edu.cornell.mannlib.vitro.webapp.utils.developer.DeveloperSettings;
import edu.cornell.mannlib.vitro.webapp.utils.developer.Key;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="DeveloperAjax", urlPatterns={"/admin/developerAjax"})
public class DeveloperSettingsServlet
extends VitroAjaxController {
    private static final Log log = LogFactory.getLog(DeveloperSettingsServlet.class);

    @Override
    protected void doRequest(VitroRequest vreq, HttpServletResponse resp) throws ServletException, IOException {
        DeveloperSettings settings = DeveloperSettings.getInstance();
        if (this.isAuthorized(vreq)) {
            settings.updateFromRequest(vreq.getParameterMap());
        } else {
            log.debug((Object)"Not authorized to update settings.");
        }
        try {
            Map<String, Object> bodyMap = this.buildBodyMap(this.isAuthorized(vreq), settings);
            String rendered = this.renderTemplate(vreq, bodyMap);
            resp.getWriter().write(rendered);
        }
        catch (Exception e) {
            this.doError(resp, e.toString(), 500);
        }
    }

    private Map<String, Object> buildBodyMap(boolean authorized, DeveloperSettings settings) {
        HashMap<String, Object> settingsMap = new HashMap<String, Object>();
        settingsMap.putAll(settings.getRawSettingsMap());
        settingsMap.put("mayControl", authorized);
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put("settings", settingsMap);
        return bodyMap;
    }

    private String renderTemplate(VitroRequest vreq, Map<String, Object> bodyMap) throws FreemarkerProcessingService.TemplateProcessingException {
        return FreemarkerProcessingServiceSetup.getService(this.getServletContext()).renderTemplate("developerPanel.ftl", bodyMap, (HttpServletRequest)vreq);
    }

    private boolean isAuthorized(VitroRequest vreq) {
        boolean authBySetting = DeveloperSettings.getInstance().getBoolean(Key.PERMIT_ANONYMOUS_CONTROL);
        boolean authByPolicy = PolicyHelper.isAuthorizedForActions((HttpServletRequest)vreq, (AuthorizationRequest)SimplePermission.ENABLE_DEVELOPER_PANEL.ACTION);
        return authBySetting || authByPolicy;
    }
}

