/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.developer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public enum Key {
    ENABLED("developer.enabled", true),
    PERMIT_ANONYMOUS_CONTROL("developer.permitAnonymousControl", true),
    DEFEAT_FREEMARKER_CACHE("developer.defeatFreemarkerCache", true),
    INSERT_FREEMARKER_DELIMITERS("developer.insertFreemarkerDelimiters", true),
    I18N_DEFEAT_CACHE("developer.i18n.defeatCache", true),
    I18N_ONLINE_TRANSLATION("developer.i18n.onlineTranslation", true),
    I18N_LOG_STRINGS("developer.i18n.logStringRequests", true),
    LOGGING_RDF_ENABLE("developer.loggingRDFService.enable", true),
    LOGGING_RDF_STACK_TRACE("developer.loggingRDFService.stackTrace", true),
    LOGGING_RDF_QUERY_RESTRICTION("developer.loggingRDFService.queryRestriction", false),
    LOGGING_RDF_STACK_RESTRICTION("developer.loggingRDFService.stackRestriction", false),
    PAGE_CONTENTS_LOG_CUSTOM_LIST_VIEW("developer.pageContents.logCustomListView", true),
    PAGE_CONTENTS_LOG_CUSTOM_SHORT_VIEW("developer.pageContents.logCustomShortView", true),
    SEARCH_INDEX_ENABLE("developer.searchIndex.enable", true),
    SEARCH_INDEX_SHOW_DOCUMENTS("developer.searchIndex.showDocuments", true),
    SEARCH_INDEX_URI_OR_NAME_RESTRICTION("developer.searchIndex.uriOrNameRestriction", false),
    SEARCH_INDEX_DOCUMENT_RESTRICTION("developer.searchIndex.documentRestriction", false),
    SEARCH_INDEX_LOG_INDEXING_BREAKDOWN_TIMINGS("developer.searchIndex.logIndexingBreakdownTimings", true),
    SEARCH_INDEX_SUPPRESS_MODEL_CHANGE_LISTENER("developer.searchIndex.suppressModelChangeListener", true),
    SEARCH_DELETIONS_ENABLE("developer.searchDeletions.enable", true),
    SEARCH_ENGINE_ENABLE("developer.searchEngine.enable", true),
    SEARCH_ENGINE_ADD_STACK_TRACE("developer.searchEngine.addStackTrace", true),
    SEARCH_ENGINE_ADD_RESULTS("developer.searchEngine.addResults", true),
    SEARCH_ENGINE_QUERY_RESTRICTION("developer.searchEngine.queryRestriction", false),
    SEARCH_ENGINE_STACK_RESTRICTION("developer.searchEngine.stackRestriction", false),
    AUTHORIZATION_LOG_DECISIONS_ENABLE("developer.authorization.logDecisions.enable", true),
    AUTHORIZATION_LOG_DECISIONS_ADD_IDENTIFERS("developer.authorization.logDecisions.addIdentifiers", true),
    AUTHORIZATION_LOG_DECISIONS_SKIP_INCONCLUSIVE("developer.authorization.logDecisions.skipInconclusive", true),
    AUTHORIZATION_LOG_DECISIONS_ACTION_RESTRICTION("developer.authorization.logDecisions.actionRestriction", false),
    AUTHORIZATION_LOG_DECISIONS_USER_RESTRICTION("developer.authorization.logDecisions.userRestriction", false),
    AUTHORIZATION_LOG_DECISIONS_POLICY_RESTRICTION("developer.authorization.logDecisions.policyRestriction", false);

    private static final Log log;
    private final String propertyName;
    private final boolean bool;

    private Key(String propertyName, boolean bool) {
        this.propertyName = propertyName;
        this.bool = bool;
    }

    public String propertyName() {
        return this.propertyName;
    }

    public String elementId() {
        return this.propertyName.replace('.', '_');
    }

    boolean isBoolean() {
        return this.bool;
    }

    public String toString() {
        return this.propertyName;
    }

    static Key fromElementId(String id) {
        return Key.fromPropertyName(id.replace('_', '.'));
    }

    static Key fromPropertyName(String name) {
        for (Key k : Key.values()) {
            if (!k.propertyName.equals(name)) continue;
            return k;
        }
        log.error((Object)("Can't find key for property name: '" + name + "'"));
        return null;
    }

    static {
        log = LogFactory.getLog(Key.class);
    }
}

