/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.directives;

import freemarker.core.Environment;
import freemarker.template.SimpleScalar;
import freemarker.template.Template;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseTemplateDirectiveModel
implements TemplateDirectiveModel {
    private static final Log log = LogFactory.getLog(BaseTemplateDirectiveModel.class);

    public abstract Map<String, Object> help(String var1);

    public static String processTemplateToString(String templateName, Map<String, Object> map, Environment env) {
        Template template = BaseTemplateDirectiveModel.getTemplate(templateName, env);
        StringWriter sw = new StringWriter();
        try {
            template.process(map, (Writer)sw);
        }
        catch (TemplateException e) {
            log.error((Object)"Template Exception creating processing environment", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"IOException creating processing environment", (Throwable)e);
        }
        return sw.toString();
    }

    private static Template getTemplate(String templateName, Environment env) {
        Template template = null;
        try {
            template = env.getConfiguration().getTemplate(templateName);
        }
        catch (IOException e) {
            log.error((Object)("Cannot get template " + templateName), (Throwable)e);
        }
        return template;
    }

    protected String getRequiredSimpleScalarParameter(Map<?, ?> params, String name) throws TemplateModelException {
        Object o = params.get(name);
        if (o == null) {
            throw new TemplateModelException("The '" + name + "' parameter is required.");
        }
        if (!(o instanceof SimpleScalar)) {
            throw new TemplateModelException("The '" + name + "' parameter must be a string value.");
        }
        return o.toString();
    }

    protected String getOptionalSimpleScalarParameter(Map<?, ?> params, String name) throws TemplateModelException {
        Object o = params.get(name);
        if (o == null) {
            return null;
        }
        if (!(o instanceof SimpleScalar)) {
            throw new TemplateModelException("The '" + name + "' parameter must be a string value.");
        }
        return o.toString();
    }

    protected Map<String, Object> getOptionalHashModelParameter(Map<?, ?> params, String name) throws TemplateModelException {
        Object object = params.get(name);
        if (object == null) {
            return Collections.emptyMap();
        }
        if (!(object instanceof TemplateHashModelEx)) {
            throw new TemplateModelException(String.format("The %s parameter must be a string value.", name));
        }
        TemplateHashModelEx hashModel = (TemplateHashModelEx)object;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (TemplateModel key : hashModel.keys()) {
            TemplateModel value = hashModel.get(key.toString());
            map.put(key.toString(), value);
        }
        return map;
    }
}

