/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.directives;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetter;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetterUtils;
import edu.cornell.mannlib.vitro.webapp.web.directives.BaseTemplateDirectiveModel;
import freemarker.core.Environment;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Model;

public class DataGetterDirective
extends BaseTemplateDirectiveModel {
    private static final Log log = LogFactory.getLog(DataGetterDirective.class);

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        long startTime = System.nanoTime();
        String dataGetterUri = this.getRequiredSimpleScalarParameter(params, "uri");
        String variableName = this.getOptionalSimpleScalarParameter(params, "var");
        HttpServletRequest req = (HttpServletRequest)env.getCustomAttribute("request");
        VitroRequest vreq = new VitroRequest(req);
        try {
            OntModel model = vreq.getDisplayModel();
            DataGetterDirective.debug(DataGetterDirective.getTimeSince(startTime) + "ms spent before DataGetter retrieval.");
            DataGetter dataGetter = DataGetterUtils.dataGetterForURI(vreq, (Model)model, dataGetterUri);
            DataGetterDirective.debug(DataGetterDirective.getTimeSince(startTime) + "ms spent after DataGetter retrieval.");
            Map<String, Object> parameters = this.getOptionalHashModelParameter(params, "parameters");
            DataGetterDirective.debug(DataGetterDirective.getTimeSince(startTime) + "ms spent before DataGetter execution.");
            DataGetterDirective.applyDataGetter(dataGetter, env, parameters, variableName);
            DataGetterDirective.debug(DataGetterDirective.getTimeSince(startTime) + "ms spent after DataGetter execution.");
        }
        catch (Exception e) {
            this.handleException(dataGetterUri, "Could not process data getter '%s'", e);
        }
    }

    private static void applyDataGetter(DataGetter dataGetter, Environment env, Map<String, Object> parameters, String overrideVariableName) throws TemplateModelException {
        Object key;
        Map<String, Object> data = dataGetter.getData(parameters);
        if (data != null && (key = data.get("variableName")) != null) {
            Object value = data.get(key.toString());
            DataGetterDirective.setVariable(env, overrideVariableName, key.toString(), value);
        }
    }

    private static void setVariable(Environment env, String overriddenVariable, String defaultVariable, Object value) throws TemplateModelException {
        ObjectWrapper wrapper = env.getObjectWrapper();
        if (!StringUtils.isBlank((CharSequence)overriddenVariable)) {
            env.setVariable(overriddenVariable, wrapper.wrap(value));
            DataGetterDirective.debug(String.format("Stored overridden variable in Freemarker environment: '%s' = '%s'", overriddenVariable, value));
        } else {
            env.setVariable(defaultVariable, wrapper.wrap(value));
            DataGetterDirective.debug(String.format("Stored default variable in Freemarker environment: '%s' = '%s'", defaultVariable, value));
        }
    }

    private void handleException(String templateName, String messageTemplate, Exception e) {
        log.error((Object)String.format(messageTemplate, templateName));
        log.error((Object)e, (Throwable)e);
    }

    @Override
    public Map<String, Object> help(String name) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("effect", "Find the freemarker template and optional DataGetters. Apply parameter substitutions in DataGetters.Execute the DataGetters and render the template.");
        map.put("comments", "");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("template", "Freemarker template file name");
        params.put("parameters", "Map of parameters and values");
        map.put("parameters", params);
        ArrayList<String> examples = new ArrayList<String>();
        examples.add("<@dataGetter uri = \"http://dataGetterUri\" \nvar = \"foobar\" \nparameters = { \"object\": \"http://objUri\", \"property\": \"http://propUri\" } />");
        map.put("examples", examples);
        return map;
    }

    private static long getTimeSince(long previousTime) {
        return (System.nanoTime() - previousTime) / 1000000L;
    }

    private static void debug(String message) {
        if (log.isDebugEnabled()) {
            log.debug((Object)message);
        }
    }
}

