/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.jsptags;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.VitroHttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfirmAuthorization
extends BodyTagSupport {
    private static final Log log = LogFactory.getLog(ConfirmAuthorization.class);

    public int doEndTag() throws JspException {
        if (this.isAuthorized()) {
            return 6;
        }
        if (this.isLoggedIn()) {
            return this.showInsufficientAuthorizationMessage();
        }
        return this.redirectToLoginPage();
    }

    private boolean isAuthorized() {
        return PolicyHelper.isAuthorizedForActions(this.getRequest(), this.getActionsFromRequestAttribute());
    }

    private AuthorizationRequest getActionsFromRequestAttribute() {
        Object attribute = this.getRequest().getAttribute("requestedActions");
        this.getRequest().removeAttribute("requestedActions");
        if (attribute == null) {
            return AuthorizationRequest.AUTHORIZED;
        }
        if (attribute instanceof AuthorizationRequest) {
            AuthorizationRequest ra = (AuthorizationRequest)attribute;
            log.debug((Object)("requested action was " + ra.getClass().getSimpleName()));
            return ra;
        }
        throw new IllegalStateException("Expected request.getAttribute(\"requestedActions\") to be either a RequestedAction or a RequestedAction[], but found " + attribute.getClass().getCanonicalName());
    }

    private boolean isLoggedIn() {
        return LoginStatusBean.getBean(this.getRequest()).isLoggedIn();
    }

    private int showInsufficientAuthorizationMessage() {
        VitroHttpServlet.redirectToInsufficientAuthorizationPage(this.getRequest(), this.getResponse());
        return 5;
    }

    private int redirectToLoginPage() {
        VitroHttpServlet.redirectToLoginPage(this.getRequest(), this.getResponse());
        return 5;
    }

    private HttpServletRequest getRequest() {
        return (HttpServletRequest)this.pageContext.getRequest();
    }

    private HttpServletResponse getResponse() {
        return (HttpServletResponse)this.pageContext.getResponse();
    }
}

