/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.RequestIdentifiers;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.common.HasProfile;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.RevisionInfoController;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.SiteAdminController;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.search.controller.IndexController;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.BaseTemplateModel;
import java.util.Collection;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class User
extends BaseTemplateModel {
    private final VitroRequest vreq;
    private final UserAccount currentUser;
    private final String profileUrl;

    public User(VitroRequest vreq) {
        this.vreq = vreq;
        this.currentUser = LoginStatusBean.getCurrentUser((HttpServletRequest)vreq);
        this.profileUrl = this.figureAssociatedProfileUrl();
    }

    private String figureAssociatedProfileUrl() {
        IdentifierBundle ids = RequestIdentifiers.getIdBundleForRequest((ServletRequest)this.vreq);
        Collection<String> uris = HasProfile.getProfileUris(ids);
        if (uris.isEmpty()) {
            return "";
        }
        String uri = uris.iterator().next();
        String url = UrlBuilder.getIndividualProfileUrl(uri, this.vreq);
        if (url == null) {
            return "";
        }
        return url;
    }

    public boolean isLoggedIn() {
        return this.currentUser != null;
    }

    public String getEmailAddress() {
        return this.currentUser == null ? "" : this.currentUser.getEmailAddress();
    }

    public String getLoginName() {
        if (this.currentUser == null) {
            return "";
        }
        if (this.currentUser.getFirstName().isEmpty()) {
            return this.currentUser.getEmailAddress();
        }
        return this.currentUser.getFirstName();
    }

    public String getFirstName() {
        return this.currentUser == null ? "" : this.currentUser.getFirstName();
    }

    public String getLastName() {
        return this.currentUser == null ? "" : this.currentUser.getLastName();
    }

    public boolean getHasSiteAdminAccess() {
        return PolicyHelper.isAuthorizedForActions((HttpServletRequest)this.vreq, SiteAdminController.REQUIRED_ACTIONS);
    }

    public boolean getHasRevisionInfoAccess() {
        return PolicyHelper.isAuthorizedForActions((HttpServletRequest)this.vreq, RevisionInfoController.REQUIRED_ACTIONS);
    }

    public boolean isAuthorizedToRebuildSearchIndex() {
        return PolicyHelper.isAuthorizedForActions((HttpServletRequest)this.vreq, IndexController.REQUIRED_ACTIONS);
    }

    public boolean getHasProfile() {
        return !this.profileUrl.isEmpty();
    }

    public String getProfileUrl() {
        return this.profileUrl;
    }
}

