/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.objects.AccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.ObjectPropertyStatementAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.SimpleAuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyStatementDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.reasoner.SimpleReasoner;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.BaseTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.GroupedPropertyList;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.NameStatementTemplateModel;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Model;

public abstract class BaseIndividualTemplateModel
extends BaseTemplateModel {
    private static final Log log = LogFactory.getLog(BaseIndividualTemplateModel.class);
    private static final String EDIT_PATH = "editRequestDispatch";
    protected final Individual individual;
    protected final LoginStatusBean loginStatusBean;
    protected final VitroRequest vreq;
    private final ServletContext ctx;
    private final boolean editing;
    protected GroupedPropertyList propertyList;

    public BaseIndividualTemplateModel(Individual individual, VitroRequest vreq) {
        this.vreq = vreq;
        this.ctx = vreq.getSession().getServletContext();
        this.individual = individual;
        this.loginStatusBean = LoginStatusBean.getBean((HttpServletRequest)vreq);
        this.editing = this.isEditable();
    }

    protected boolean isVClass(String vClassUri) {
        boolean isVClass = this.individual.isVClass(vClassUri);
        SimpleReasoner simpleReasoner = (SimpleReasoner)this.ctx.getAttribute(SimpleReasoner.class.getName());
        if (!isVClass && simpleReasoner != null && simpleReasoner.isABoxReasoningAsynchronous()) {
            log.debug((Object)("Checking superclasses to see if individual is a " + vClassUri + " because reasoning is asynchronous"));
            List<VClass> directVClasses = this.individual.getVClasses(true);
            for (VClass directVClass : directVClasses) {
                VClassDao vcDao = this.vreq.getWebappDaoFactory().getVClassDao();
                List<String> superClassUris = vcDao.getAllSuperClassURIs(directVClass.getURI());
                if (!superClassUris.contains(vClassUri)) continue;
                isVClass = true;
                break;
            }
        }
        return isVClass;
    }

    public String getProfileUrl() {
        return UrlBuilder.getIndividualProfileUrl(this.individual, this.vreq);
    }

    public String getImageUrl() {
        String imageUrl = this.individual.getImageUrl();
        return imageUrl == null ? null : this.getUrl(imageUrl);
    }

    public String getThumbUrl() {
        String thumbUrl = this.individual.getThumbUrl();
        return thumbUrl == null ? null : this.getUrl(thumbUrl);
    }

    public String getRdfUrl() {
        String individualUri = this.getUri();
        String profileUrl = this.getProfileUrl();
        if (UrlBuilder.isUriInDefaultNamespace(individualUri, this.vreq)) {
            return UrlBuilder.getUrl("/individual/" + this.getLocalName() + "/" + this.getLocalName() + ".rdf");
        }
        return UrlBuilder.addParams(profileUrl, "format", "rdfxml");
    }

    public GroupedPropertyList getPropertyList() {
        if (this.propertyList == null) {
            this.propertyList = new GroupedPropertyList(this.individual, this.vreq, this.editing);
        }
        return this.propertyList;
    }

    public boolean isEditable() {
        ObjectPropertyStatementAccessObject aops = new ObjectPropertyStatementAccessObject((Model)this.vreq.getJenaOntModel(), this.individual.getURI(), AccessObject.SOME_PREDICATE, AccessObject.SOME_URI);
        SimpleAuthorizationRequest editSomeObjectProperty = new SimpleAuthorizationRequest(aops, AccessOperation.EDIT);
        return PolicyHelper.isAuthorizedForActions((HttpServletRequest)this.vreq, (AuthorizationRequest)editSomeObjectProperty);
    }

    public boolean getShowAdminPanel() {
        return PolicyHelper.isAuthorizedForActions((HttpServletRequest)this.vreq, (AuthorizationRequest)SimplePermission.SEE_INDVIDUAL_EDITING_PANEL.ACTION);
    }

    public NameStatementTemplateModel getNameStatement() {
        return new NameStatementTemplateModel(this.getUri(), this.vreq);
    }

    public String getName() {
        return this.individual.getName();
    }

    public String getDeleteUrl() {
        Collection<String> types = this.getMostSpecificTypes();
        UrlBuilder.ParamMap params = new UrlBuilder.ParamMap("objectUri", this.individual.getURI(), "cmd", "delete", "individualName", this.getNameStatement().getValue());
        Iterator<String> typesIterator = types.iterator();
        if (types.iterator().hasNext()) {
            String type = typesIterator.next();
            params.put("individualType", type);
        }
        return UrlBuilder.getUrl(EDIT_PATH, params);
    }

    public Collection<String> getMostSpecificTypes() {
        ObjectPropertyStatementDao opsDao = this.vreq.getWebappDaoFactory().getObjectPropertyStatementDao();
        Map<String, String> types = opsDao.getMostSpecificTypesInClassgroupsForIndividual(this.getUri());
        return types.values();
    }

    public String getUri() {
        return this.individual.getURI();
    }

    public String getLocalName() {
        return this.individual.getLocalName();
    }

    public String selfEditingId() {
        WebappDaoFactory wdf;
        Collection<DataPropertyStatement> ids;
        String id = null;
        String idMatchingProperty = ConfigurationProperties.getBean(this.ctx).getProperty("selfEditing.idMatchingProperty");
        if (!StringUtils.isBlank((CharSequence)idMatchingProperty) && (ids = (wdf = this.vreq.getUnfilteredWebappDaoFactory()).getDataPropertyStatementDao().getDataPropertyStatementsForIndividualByDataPropertyURI(this.individual, idMatchingProperty)).size() > 0) {
            id = ids.iterator().next().getData();
        }
        return id;
    }

    public String controlPanelUrl() {
        return UrlBuilder.getUrl(UrlBuilder.Route.INDIVIDUAL_EDIT, "uri", this.getUri());
    }
}

