/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.objects.AccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.DataPropertyStatementAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.FauxDataPropertyStatementAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatementImpl;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.RdfLiteralHash;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.PropertyStatementTemplateModel;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Literal;

public class DataPropertyStatementTemplateModel
extends PropertyStatementTemplateModel {
    private static final Log log = LogFactory.getLog(DataPropertyStatementTemplateModel.class);
    private final Literal literalValue;
    private final String deleteUrl;
    private final String editUrl;
    private final String templateName;

    public DataPropertyStatementTemplateModel(String subjectUri, Property property, Literal literal, String templateName, VitroRequest vreq) {
        super(subjectUri, property, vreq);
        this.literalValue = literal;
        this.templateName = templateName;
        this.deleteUrl = this.makeDeleteUrl();
        this.editUrl = this.makeEditUrl();
    }

    private String makeDeleteUrl() {
        DataPropertyStatement dps = this.makeStatement();
        AccessObject ao = this.isFaux() ? new FauxDataPropertyStatementAccessObject(this.vreq.getJenaOntModel(), this.subjectUri, this.fauxProperty, this.literalValue.getLexicalForm()) : new DataPropertyStatementAccessObject(this.vreq.getJenaOntModel(), dps);
        if (!PolicyHelper.isAuthorizedForActions((HttpServletRequest)this.vreq, ao, AccessOperation.DROP)) {
            return "";
        }
        UrlBuilder.ParamMap params = new UrlBuilder.ParamMap("subjectUri", this.subjectUri, "predicateUri", this.property.getURI(), "datapropKey", this.makeHash(dps), "cmd", "delete");
        if (this.isFaux()) {
            params.put("fauxContextUri", this.fauxProperty.getContextUri());
        }
        params.put("templateName", this.templateName);
        params.putAll(UrlBuilder.getModelParams(this.vreq));
        return UrlBuilder.getUrl("editRequestDispatch", params);
    }

    private String makeEditUrl() {
        if ("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#moniker".equals(this.property.getURI())) {
            return "";
        }
        DataPropertyStatement dps = this.makeStatement();
        AccessObject ao = this.isFaux() ? new FauxDataPropertyStatementAccessObject(this.vreq.getJenaOntModel(), this.subjectUri, this.fauxProperty, this.literalValue.getLexicalForm()) : new DataPropertyStatementAccessObject(this.vreq.getJenaOntModel(), dps);
        if (!PolicyHelper.isAuthorizedForActions((HttpServletRequest)this.vreq, ao, AccessOperation.EDIT)) {
            return "";
        }
        UrlBuilder.ParamMap params = new UrlBuilder.ParamMap("subjectUri", this.subjectUri, "predicateUri", this.property.getURI(), "datapropKey", this.makeHash(dps));
        if (this.isFaux()) {
            params.put("fauxContextUri", this.fauxProperty.getContextUri());
        }
        if (this.deleteUrl.isEmpty()) {
            params.put("deleteProhibited", "prohibited");
        }
        params.putAll(UrlBuilder.getModelParams(this.vreq));
        return UrlBuilder.getUrl("editRequestDispatch", params);
    }

    private DataPropertyStatement makeStatement() {
        DataPropertyStatementImpl dps = new DataPropertyStatementImpl(this.subjectUri, this.property.getURI(), this.literalValue.getLexicalForm());
        dps.setLanguage(this.literalValue.getLanguage());
        dps.setDatatypeURI(this.literalValue.getDatatypeURI());
        return dps;
    }

    private String makeHash(DataPropertyStatement dps) {
        return String.valueOf(RdfLiteralHash.makeRdfLiteralHash(dps));
    }

    public String getValue() {
        return this.cleanTextForDisplay(this.literalValue.getLexicalForm());
    }

    @Override
    public String getDeleteUrl() {
        return this.deleteUrl;
    }

    @Override
    public String getEditUrl() {
        return this.editUrl;
    }
}

