/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.objects.AccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.DataPropertyStatementAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.FauxDataPropertyStatementAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.FauxObjectPropertyStatementAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.ObjectPropertyStatementAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.FauxProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.BaseTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.DataPropertyTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.FauxDataPropertyWrapper;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.FauxObjectPropertyWrapper;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.ObjectPropertyTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.PropertyTemplateModel;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Model;

public class PropertyGroupTemplateModel
extends BaseTemplateModel {
    private static final Log log = LogFactory.getLog(PropertyGroupTemplateModel.class);
    private final String name;
    private final List<PropertyTemplateModel> properties;

    PropertyGroupTemplateModel(VitroRequest vreq, PropertyGroup group, Individual subject, boolean editing, List<DataProperty> populatedDataPropertyList, List<ObjectProperty> populatedObjectPropertyList) {
        this.name = group.getName();
        List<Property> propertyList = group.getPropertyList();
        this.properties = new ArrayList<PropertyTemplateModel>(propertyList.size());
        for (Property p : propertyList) {
            if (p instanceof ObjectProperty) {
                ObjectPropertyTemplateModel tm;
                ObjectProperty op = (ObjectProperty)p;
                if (!this.allowedToDisplay(vreq, op, subject) || (tm = ObjectPropertyTemplateModel.getObjectPropertyTemplateModel(op, subject, vreq, editing, populatedObjectPropertyList)).isEmpty() && (!editing || tm.getAddUrl().isEmpty())) continue;
                this.properties.add(tm);
                continue;
            }
            if (p instanceof DataProperty) {
                DataProperty dp = (DataProperty)p;
                if (!this.allowedToDisplay(vreq, dp, subject)) continue;
                this.properties.add(new DataPropertyTemplateModel(dp, subject, vreq, editing, populatedDataPropertyList));
                continue;
            }
            log.debug((Object)(p.getURI() + " is neither an ObjectProperty nor a DataProperty; skipping display"));
        }
    }

    private boolean allowedToDisplay(VitroRequest vreq, ObjectProperty op, Individual subject) {
        AccessObject ao;
        if (op instanceof FauxObjectPropertyWrapper) {
            FauxProperty fauxProperty = ((FauxObjectPropertyWrapper)op).getFauxProperty();
            ao = new FauxObjectPropertyStatementAccessObject((Model)vreq.getJenaOntModel(), subject.getURI(), fauxProperty, AccessObject.SOME_URI);
        } else {
            ao = new ObjectPropertyStatementAccessObject((Model)vreq.getJenaOntModel(), subject.getURI(), op, AccessObject.SOME_URI);
        }
        return PolicyHelper.isAuthorizedForActions((HttpServletRequest)vreq, ao, AccessOperation.DISPLAY);
    }

    private boolean allowedToDisplay(VitroRequest vreq, DataProperty dp, Individual subject) {
        AccessObject ao;
        if (dp instanceof FauxDataPropertyWrapper) {
            FauxProperty fauxProperty = ((FauxDataPropertyWrapper)dp).getFauxProperty();
            ao = new FauxDataPropertyStatementAccessObject(vreq.getJenaOntModel(), subject.getURI(), fauxProperty, AccessObject.SOME_LITERAL);
        } else {
            ao = new DataPropertyStatementAccessObject(vreq.getJenaOntModel(), subject.getURI(), dp, AccessObject.SOME_LITERAL);
        }
        return PolicyHelper.isAuthorizedForActions((HttpServletRequest)vreq, ao, AccessOperation.DISPLAY);
    }

    protected boolean isEmpty() {
        return this.properties.isEmpty();
    }

    protected void remove(PropertyTemplateModel ptm) {
        this.properties.remove(ptm);
    }

    public String toString() {
        StringBuilder ptmStr = new StringBuilder();
        for (PropertyTemplateModel ptm : this.properties) {
            String spacer = "\n  ";
            if (ptm == null) continue;
            ptmStr.append(spacer).append(ptm.toString());
        }
        return String.format("\nPropertyGroupTemplateModel %s[%s] ", this.name, ptmStr.toString());
    }

    public String getName() {
        return this.name;
    }

    public String getName(String otherGroupName) {
        if (this.name == null || this.name.isEmpty()) {
            return otherGroupName;
        }
        return this.name;
    }

    public List<PropertyTemplateModel> getProperties() {
        return this.properties;
    }
}

