/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.widgets;

import edu.cornell.mannlib.vitro.webapp.web.templatemodels.Tags;
import freemarker.core.Environment;
import freemarker.core.Macro;
import freemarker.template.Template;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateSequenceModel;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Widget {
    private static final Log log = LogFactory.getLog(Widget.class);

    public String doAssets(Environment env, Map params) {
        String widgetName = params.get("name").toString();
        Macro assetsMacro = this.getMacroFromTemplate(this.getAssetsMacroName(), widgetName, env);
        if (assetsMacro == null) {
            return "";
        }
        TemplateHashModel dataModel = env.getDataModel();
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("stylesheets", dataModel.get("stylesheets"));
            map.put("scripts", dataModel.get("scripts"));
            map.put("headScripts", dataModel.get("headScripts"));
            map.put("metaTags", new Tags().wrap());
            map.put("urls", dataModel.get("urls"));
        }
        catch (TemplateModelException e) {
            log.error((Object)"Error getting asset values from data model.");
        }
        return this.processMacroToString(env, widgetName, assetsMacro, map);
    }

    public String doMarkup(Environment env, Map params) {
        HttpServletRequest request = (HttpServletRequest)env.getCustomAttribute("request");
        ServletContext context = request.getSession().getServletContext();
        WidgetTemplateValues values = null;
        try {
            values = this.process(env, params, request, context);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        if (values == null) {
            return "";
        }
        String widgetName = params.get("name").toString();
        return this.processMacroToString(env, widgetName, values);
    }

    protected String getTemplateName(String widgetName) {
        return "widget-" + widgetName + ".ftl";
    }

    protected String getAssetsMacroName() {
        return "assets";
    }

    protected String getMarkupMacroName() {
        return "markup";
    }

    protected abstract WidgetTemplateValues process(Environment var1, Map var2, HttpServletRequest var3, ServletContext var4) throws Exception;

    private String processMacroToString(Environment env, String widgetName, Macro macro, Map<String, Object> map) {
        StringWriter out = new StringWriter();
        try {
            String templateString = this.getTemplateString(macro);
            Template template = new Template("widget", (Reader)new StringReader(templateString), env.getConfiguration());
            template.process(map, (Writer)out);
        }
        catch (Exception e) {
            log.error((Object)("Could not process widget " + widgetName), (Throwable)e);
        }
        String output = out.toString();
        log.debug((Object)("Macro output: " + output));
        return output;
    }

    private String getTemplateString(Macro macro) throws TemplateModelException {
        TemplateSequenceModel childNodes = macro.getChildNodes();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < childNodes.size(); ++i) {
            sb.append(childNodes.get(i));
        }
        String template = sb.toString();
        return template;
    }

    private String processMacroToString(Environment env, String widgetName, String macroName, Map<String, Object> map) {
        Macro macro = this.getMacroFromTemplate(macroName, widgetName, env);
        return this.processMacroToString(env, widgetName, macro, map);
    }

    private String processMacroToString(Environment env, String widgetName, WidgetTemplateValues values) {
        return this.processMacroToString(env, widgetName, values.getMacroName(), values.getMap());
    }

    private Macro getMacroFromTemplate(String macroName, String widgetName, Environment env) {
        String templateName = this.getTemplateName(widgetName);
        Template template = null;
        Macro macro = null;
        try {
            template = env.getConfiguration().getTemplate(templateName);
            macro = (Macro)template.getMacros().get(macroName);
        }
        catch (IOException e) {
            log.error((Object)("Cannot get template " + templateName));
        }
        return macro;
    }

    protected class WidgetProcessingException
    extends Exception {
        WidgetProcessingException(String message) {
            super(message);
        }
    }

    protected static class WidgetTemplateValues {
        private final String macroName;
        private final Map<String, Object> map;

        public WidgetTemplateValues(String macroName) {
            this.macroName = macroName;
            this.map = new HashMap<String, Object>();
        }

        public WidgetTemplateValues(String macroName, Map<String, Object> map) {
            this.macroName = macroName;
            this.map = map;
        }

        public WidgetTemplateValues put(String key, Object value) {
            this.map.put(key, value);
            return this;
        }

        public Map<String, Object> getMap() {
            return Collections.unmodifiableMap(this.map);
        }

        public String getMacroName() {
            return this.macroName;
        }
    }
}

