/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.filtering.filters;

import edu.cornell.mannlib.vitro.webapp.beans.IndividualImpl;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.BaseFiltering;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.filters.VitroFilterUtils;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.filters.VitroFilters;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VitroFiltersFactoryTest {
    private boolean ACCEPT = true;
    private boolean REJECT = false;

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testGetTestFilter() {
        String[] names;
        VitroFilters vf = VitroFilterUtils.getTestFilter();
        this.checkFilterForNull(vf);
        ArrayList<IndividualImpl> ents = new ArrayList<IndividualImpl>();
        for (String name : names = new String[]{"Greg", "gary", "bob", "Sue", "jim"}) {
            IndividualImpl ent = new IndividualImpl();
            ent.setName(name);
            ents.add(ent);
        }
        BaseFiltering bf = new BaseFiltering();
        List filteredEnts = bf.filter(ents, vf.getIndividualFilter());
        Assert.assertNotNull((Object)filteredEnts);
        Assert.assertEquals((String)"did not filter correctly", (long)2L, (long)filteredEnts.size());
    }

    public void checkFilterForNull(VitroFilters vf) {
        Assert.assertNotNull((String)"filter was null", (Object)vf);
        Assert.assertNotNull((String)"getClassFilter was null", (Object)vf.getClassFilter());
        Assert.assertNotNull((String)"getDataPropertyFilter was null", (Object)vf.getDataPropertyFilter());
        Assert.assertNotNull((String)"getDataPropertyStatementFilter was null", (Object)vf.getDataPropertyStatementFilter());
        Assert.assertNotNull((String)"getObjectPropertyFilter was null", (Object)vf.getObjectPropertyFilter());
        Assert.assertNotNull((String)"getObjectPropertyStatementFilter was null", (Object)vf.getObjectPropertyStatementFilter());
        Assert.assertNotNull((String)"getIndividualFilter was null", (Object)vf.getIndividualFilter());
        Assert.assertNotNull((String)"getVClassGroupFilter was null", (Object)vf.getVClassGroupFilter());
    }

    @Test
    public void testRoleLevelFilter() {
    }
}

