/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.i18n;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.i18n.I18n;
import edu.cornell.mannlib.vitro.webapp.i18n.selection.SelectedLocale;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.javax.servlet.ServletContextStub;

public class I18nTest
extends AbstractTestClass {
    private static final List<Locale> SELECTABLE_LOCALES = I18nTest.locales("es_MX", "en_US");
    ServletContextStub ctx;

    @Before
    public void setup() {
        this.ctx = new ServletContextStub();
    }

    @Test
    public void noMatchOnLanguageRegion() {
        this.assertLocales("fr_CA", SELECTABLE_LOCALES, "fr_CA", "fr", "");
    }

    @Test
    public void noMatchOnLanguage() {
        this.assertLocales("fr", SELECTABLE_LOCALES, "fr", "");
    }

    @Test
    public void noMatchOnRoot() {
        this.assertLocales("", SELECTABLE_LOCALES, "");
    }

    @Test
    public void matchOnLanguageRegion() {
        this.assertLocales("es_ES", SELECTABLE_LOCALES, "es_ES", "es", "es_MX", "");
    }

    @Test
    public void matchOnLanguage() {
        this.assertLocales("es", SELECTABLE_LOCALES, "es", "es_MX", "");
    }

    private void assertLocales(String requested, List<Locale> selectable, String ... expected) {
        SelectedLocale.setSelectableLocales((ServletContext)this.ctx, selectable);
        List<Locale> expectedLocales = I18nTest.locales(expected);
        I18n.ThemeBasedControl control = new I18n.ThemeBasedControl((ServletContext)this.ctx, "bogusThemeDirectory");
        List actualLocales = control.getCandidateLocales("bogusBaseName", I18nTest.locale(requested));
        Assert.assertEquals((String)"Expected locales", expectedLocales, (Object)actualLocales);
    }

    private static List<Locale> locales(String ... strings) {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (String s : strings) {
            locales.add(I18nTest.locale(s));
        }
        return locales;
    }

    private static Locale locale(String s) {
        String[] parts = s.split("_");
        String language = parts.length > 0 ? parts[0] : "";
        String country = parts.length > 1 ? parts[1] : "";
        String variant = parts.length > 2 ? parts[2] : "";
        return new Locale(language, country, variant);
    }
}

