/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.imageprocessor.jai;

import com.sun.media.jai.codec.MemoryCacheSeekableStream;
import com.sun.media.jai.codec.SeekableStream;
import edu.cornell.mannlib.vitro.webapp.imageprocessor.jai.JaiImageProcessor;
import edu.cornell.mannlib.vitro.webapp.modules.imageProcessor.ImageProcessor;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.StreamDescriptor;
import javax.media.jai.widget.ImageCanvas;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class JaiImageProcessorTester
extends Frame {
    private static final int BUFFER_SIZE = 160000;
    private static final ImageProcessor.Dimensions THUMBNAIL_SIZE = new ImageProcessor.Dimensions(200, 200);
    private static final ImageCropData[] THUMBNAIL_DATA = new ImageCropData[]{new ImageCropData("/Users/jeb228/Pictures/JimBlake_20010915.jpg", 50, 50, 115), new ImageCropData("/Users/jeb228/Pictures/brazil_collab.png", 600, 250, 400), new ImageCropData("/Users/jeb228/Pictures/wheel.png", 0, 0, 195), new ImageCropData("/Users/jeb228/Pictures/DSC04203w-trans.gif", 400, 1200, 800)};
    private final JaiImageProcessor thumbnailer = new JaiImageProcessor();

    private JaiImageProcessorTester() {
        this.setTitle("Alpha Killer Test");
        this.addWindowListener(new CloseWindowListener());
        this.setLayout(this.createLayout());
        for (ImageCropData icd : THUMBNAIL_DATA) {
            try {
                FileInputStream mainStream = new FileInputStream(icd.filename);
                File thumbFile = this.writeToTempFile(this.thumbnailer.cropAndScale((InputStream)mainStream, icd.crop, THUMBNAIL_SIZE));
                System.out.println(thumbFile.getAbsolutePath());
                MemoryCacheSeekableStream thumbFileStream = new MemoryCacheSeekableStream((InputStream)new FileInputStream(thumbFile));
                RenderedOp thumbImage = StreamDescriptor.create((SeekableStream)thumbFileStream, null, null);
                this.add((Component)new ImageCanvas((RenderedImage)thumbImage));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.pack();
        this.setVisible(true);
    }

    private File writeToTempFile(InputStream thumbStream) throws IOException, FileNotFoundException {
        File thumbFile = File.createTempFile("ImageUploaderThumbnailerTester", "");
        FileOutputStream imageOutputStream = new FileOutputStream(thumbFile);
        byte[] buffer = new byte[160000];
        int howMany = thumbStream.read(buffer);
        ((OutputStream)imageOutputStream).write(buffer, 0, howMany);
        ((OutputStream)imageOutputStream).close();
        return thumbFile;
    }

    private GridLayout createLayout() {
        GridLayout layout = new GridLayout(1, THUMBNAIL_DATA.length);
        layout.setHgap(10);
        return layout;
    }

    public static void main(String[] args) {
        Logger.getLogger(JaiImageProcessor.class).setLevel(Level.DEBUG);
        new JaiImageProcessorTester();
    }

    private class CloseWindowListener
    extends WindowAdapter {
        private CloseWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            JaiImageProcessorTester.this.setVisible(false);
            JaiImageProcessorTester.this.dispose();
            System.exit(0);
        }
    }

    private static class ImageCropData {
        final String filename;
        final ImageProcessor.CropRectangle crop;

        ImageCropData(String filename, int x, int y, int size) {
            this.filename = filename;
            this.crop = new ImageProcessor.CropRectangle(x, y, size, size);
        }
    }
}

