/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.modelaccess.adapters;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.ModelReader;
import com.hp.hpl.jena.shared.AlreadyExistsException;
import com.hp.hpl.jena.shared.CannotCreateException;
import com.hp.hpl.jena.shared.DoesNotExistException;
import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.modelaccess.adapters.ListCachingModelMaker;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.com.hp.hpl.jena.rdf.model.ModelMaker.ModelMakerStub;

public class ListCachingModelMakerTest
extends AbstractTestClass {
    private static final String URI_ONE = "http://model.one";
    private static final String URI_TWO = "http://model.two";
    private static final String URI_NONE = "http://model.does.not.exist";
    private static final Model MODEL_ONE = ListCachingModelMakerTest.createModel();
    private static final Model MODEL_TWO = ListCachingModelMakerTest.createModel();
    private static final Model MODEL_DEFAULT = ListCachingModelMakerTest.createModel();
    private static final Model MODEL_FRESH = ListCachingModelMakerTest.createModel();
    private ModelMaker rigorous;
    private ModelMaker relaxed;
    private ModelMaker mm;
    private ModelReader modelReader;

    private static Model createModel() {
        return ModelFactory.createDefaultModel();
    }

    @Before
    public void setup() {
        this.rigorous = ModelMakerStub.rigorous(MODEL_DEFAULT, MODEL_FRESH).put(URI_ONE, MODEL_ONE).put(URI_TWO, MODEL_TWO);
        this.relaxed = ModelMakerStub.relaxed(MODEL_DEFAULT, MODEL_FRESH).put(URI_ONE, MODEL_ONE).put(URI_TWO, MODEL_TWO);
        this.relaxed();
    }

    @Test(expected=NullPointerException.class)
    public void nullInnerModel() {
        new ListCachingModelMaker(null);
    }

    @Test
    public void listModels() {
        this.assertList(URI_ONE, URI_TWO);
    }

    @Test
    public void hasModelExist() {
        Assert.assertTrue((boolean)this.mm.hasModel(URI_ONE));
    }

    @Test
    public void hasModelNonExist() {
        Assert.assertFalse((boolean)this.mm.hasModel(URI_NONE));
    }

    @Test
    public void createModelExist() {
        Assert.assertEquals((Object)MODEL_ONE, (Object)this.mm.createModel(URI_ONE));
        this.assertList(URI_ONE, URI_TWO);
    }

    @Test
    public void createModelNonExist() {
        Assert.assertEquals((Object)MODEL_FRESH, (Object)this.mm.createModel(URI_NONE));
        this.assertList(URI_ONE, URI_TWO, URI_NONE);
    }

    @Test(expected=AlreadyExistsException.class)
    public void createModelStrictExist() {
        this.mm.createModel(URI_ONE, true);
    }

    @Test
    public void createModelStrictNonExist() {
        Assert.assertEquals((Object)MODEL_FRESH, (Object)this.mm.createModel(URI_NONE, true));
        this.assertList(URI_ONE, URI_TWO, URI_NONE);
    }

    @Test
    public void openModelExist() {
        Assert.assertEquals((Object)MODEL_TWO, (Object)this.mm.openModel(URI_TWO));
        this.assertList(URI_ONE, URI_TWO);
    }

    @Test(expected=DoesNotExistException.class)
    public void openModelRigorousNonExist() {
        this.rigorous();
        this.mm.openModel(URI_NONE);
    }

    @Test
    public void openModelRelaxedNonExist() {
        Assert.assertEquals((Object)MODEL_FRESH, (Object)this.mm.openModel(URI_NONE));
        this.assertList(URI_ONE, URI_TWO, URI_NONE);
    }

    @Test
    public void openModelIfPresentExist() {
        Assert.assertEquals((Object)MODEL_TWO, (Object)this.mm.openModelIfPresent(URI_TWO));
        this.assertList(URI_ONE, URI_TWO);
    }

    @Test
    public void openModelIfPresentNonExist() {
        Assert.assertNull((Object)this.mm.openModelIfPresent(URI_NONE));
        this.assertList(URI_ONE, URI_TWO);
    }

    @Test
    public void openModelStrictExist() {
        Assert.assertEquals((Object)MODEL_ONE, (Object)this.mm.openModel(URI_ONE, true));
        this.assertList(URI_ONE, URI_TWO);
    }

    @Test
    public void openModelNonStrictExist() {
        Assert.assertEquals((Object)MODEL_ONE, (Object)this.mm.openModel(URI_ONE, false));
        this.assertList(URI_ONE, URI_TWO);
    }

    @Test
    public void openModelNonStrictNonExist() {
        Assert.assertEquals((Object)MODEL_FRESH, (Object)this.mm.openModel(URI_NONE, false));
        this.assertList(URI_ONE, URI_TWO, URI_NONE);
    }

    @Test
    public void removeModelExist() {
        this.mm.removeModel(URI_ONE);
        this.assertList(URI_TWO);
    }

    @Test(expected=DoesNotExistException.class)
    public void removeModelNonExist() {
        this.mm.removeModel(URI_NONE);
    }

    @Test
    public void getModelExist() {
        Assert.assertEquals((Object)MODEL_TWO, (Object)this.mm.getModel(URI_TWO));
        this.assertList(URI_ONE, URI_TWO);
    }

    @Test
    public void getModelRigorousNonExist() {
        this.rigorous();
        Assert.assertNull((Object)this.mm.getModel(URI_NONE));
        this.assertList(URI_ONE, URI_TWO);
    }

    @Test
    public void getModelRelaxedNonExist() {
        Assert.assertEquals((Object)MODEL_FRESH, (Object)this.mm.getModel(URI_NONE));
        this.assertList(URI_ONE, URI_TWO, URI_NONE);
    }

    @Test
    public void getModelLoadIfAbsentExist() {
        Assert.assertEquals((Object)MODEL_TWO, (Object)this.mm.getModel(URI_TWO, this.modelReader));
        this.assertList(URI_ONE, URI_TWO);
    }

    @Test(expected=CannotCreateException.class)
    public void getModelLoadIfAbsentRigorousNonExist() {
        this.rigorous();
        this.mm.getModel(URI_NONE, this.modelReader);
    }

    @Test
    public void getModelLoadIfAbsentRelaxedNonExist() {
        Assert.assertEquals((Object)MODEL_FRESH, (Object)this.mm.getModel(URI_NONE, this.modelReader));
        this.assertList(URI_ONE, URI_TWO, URI_NONE);
    }

    private void relaxed() {
        this.mm = new ListCachingModelMaker(this.relaxed);
    }

    private void rigorous() {
        this.mm = new ListCachingModelMaker(this.rigorous);
    }

    private void assertList(String ... expectedArray) {
        HashSet<String> expected = new HashSet<String>(Arrays.asList(expectedArray));
        Set actual = this.mm.listModels().toSet();
        Assert.assertEquals(expected, (Object)actual);
    }
}

