/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts.user;

import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.UserAccountsPage;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.user.UserAccountsFirstTimeExternalPage;
import edu.cornell.mannlib.vitro.webapp.email.FreemarkerEmailFactory;
import edu.cornell.mannlib.vitro.webapp.email.FreemarkerEmailMessage;
import java.util.HashMap;
import java.util.Map;
import javax.mail.Message;

public abstract class UserAccountsFirstTimeExternalPageStrategy
extends UserAccountsPage {
    private UserAccountsFirstTimeExternalPage page;

    public static UserAccountsFirstTimeExternalPageStrategy getInstance(VitroRequest vreq, UserAccountsFirstTimeExternalPage page, boolean emailEnabled) {
        if (emailEnabled) {
            return new EmailStrategy(vreq, page);
        }
        return new NoEmailStrategy(vreq, page);
    }

    public UserAccountsFirstTimeExternalPageStrategy(VitroRequest vreq, UserAccountsFirstTimeExternalPage page) {
        super(vreq);
        this.page = page;
    }

    public abstract void addMoreBodyValues(Map<String, Object> var1);

    public abstract void notifyUser(UserAccount var1);

    public static class NoEmailStrategy
    extends UserAccountsFirstTimeExternalPageStrategy {
        public NoEmailStrategy(VitroRequest vreq, UserAccountsFirstTimeExternalPage page) {
            super(vreq, page);
        }

        @Override
        public void addMoreBodyValues(Map<String, Object> body) {
        }

        @Override
        public void notifyUser(UserAccount ua) {
        }
    }

    public static class EmailStrategy
    extends UserAccountsFirstTimeExternalPageStrategy {
        private static final String EMAIL_TEMPLATE = "userAccounts-firstTimeExternalEmail.ftl";

        public EmailStrategy(VitroRequest vreq, UserAccountsFirstTimeExternalPage page) {
            super(vreq, page);
        }

        @Override
        public void addMoreBodyValues(Map<String, Object> body) {
            body.put("emailIsEnabled", Boolean.TRUE);
        }

        @Override
        public void notifyUser(UserAccount ua) {
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("userAccount", ua);
            body.put("siteName", this.getSiteName());
            FreemarkerEmailMessage email = FreemarkerEmailFactory.createNewMessage(this.vreq);
            email.addRecipient(Message.RecipientType.TO, ua.getEmailAddress());
            email.setSubject(this.i18n.text("account_created_subject", this.getSiteName()));
            email.setTemplate(EMAIL_TEMPLATE);
            email.setBodyMap(body);
            email.processTemplate();
            email.send();
        }
    }
}

