/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit.listing;

import edu.cornell.mannlib.vedit.beans.ButtonForm;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IndividualsListingController
extends BaseEditController {
    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        if (!this.isAuthorizedToDisplayPage(request, response, SimplePermission.EDIT_ONTOLOGY.ACTION)) {
            return;
        }
        VitroRequest vrequest = new VitroRequest(request);
        String assertedOnlyStr = request.getParameter("assertedOnly");
        WebappDaoFactory wadf = null;
        if (assertedOnlyStr != null && assertedOnlyStr.equalsIgnoreCase("true")) {
            wadf = vrequest.getUnfilteredAssertionsWebappDaoFactory();
        }
        if (wadf == null) {
            wadf = vrequest.getUnfilteredWebappDaoFactory();
        }
        IndividualDao dao = wadf.getIndividualDao();
        VClassDao vcDao = wadf.getVClassDao();
        String vclassURI = request.getParameter("VClassURI");
        VClass vc = vcDao.getVClassByURI(vclassURI);
        List<Individual> inds = dao.getIndividualsByVClassURI(vclassURI);
        ArrayList<String> results = new ArrayList<String>();
        results.add("XX");
        results.add("Individual");
        results.add("class");
        if (inds != null && inds.size() > 0) {
            for (Individual ind : inds) {
                results.add("XX");
                if (ind.getName() != null) {
                    try {
                        String individualName = ind.getName() == null || ind.getName().length() == 0 ? ind.getURI() : ind.getName();
                        results.add("<a href=\"./entityEdit?uri=" + URLEncoder.encode(ind.getURI(), "UTF-8") + "\">" + individualName + "</a>");
                    }
                    catch (Exception e) {
                        results.add(ind.getName());
                    }
                } else {
                    results.add("");
                }
                if (vc != null) {
                    try {
                        String vclassName = vc.getName() == null || vc.getName().length() == 0 ? vc.getURI() : vc.getName();
                        results.add("<a href=\"./vclassEdit?uri=" + URLEncoder.encode(vc.getURI(), "UTF-8") + "\">" + vclassName + "</a>");
                    }
                    catch (Exception e) {
                        results.add(vc.getName());
                    }
                    continue;
                }
                results.add(vclassURI);
            }
        } else {
            results.add("XX");
            results.add("No individuals to display");
        }
        request.setAttribute("results", results);
        request.setAttribute("columncount", (Object)new Integer(3));
        request.setAttribute("suppressquery", (Object)"true");
        request.setAttribute("title", (Object)("Individuals in Class " + (vc != null ? vc.getName() : vclassURI)));
        request.setAttribute("bodyJsp", (Object)"/templates/edit/fetch/horizontal.jsp");
        ArrayList<ButtonForm> buttons = new ArrayList<ButtonForm>();
        HashMap<String, String> newIndividualParams = new HashMap<String, String>();
        newIndividualParams.put("VClassURI", vclassURI);
        newIndividualParams.put("controller", "Entity");
        ButtonForm newIndividualButton = new ButtonForm("editForm", "buttonForm", "Add instance", newIndividualParams);
        buttons.add(newIndividualButton);
        request.setAttribute("topButtons", buttons);
        RequestDispatcher rd = request.getRequestDispatcher("/templates/page/basicPage.jsp");
        try {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doGet(request, response);
    }
}

