/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import com.github.jsonldjava.core.JSONLD;
import com.github.jsonldjava.core.JSONLDProcessingError;
import com.github.jsonldjava.core.RDFParser;
import com.github.jsonldjava.impl.JenaRDFParser;
import com.github.jsonldjava.utils.JSONUtils;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.ApplicationBean;
import edu.cornell.mannlib.vitro.webapp.beans.DisplayMessage;
import edu.cornell.mannlib.vitro.webapp.controller.VitroHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerComponentGenerator;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.HomePageController;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.TemplateProcessingHelper;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ExceptionResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ForwardResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.NotAuthorizedResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.RdfResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.RedirectResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.email.FreemarkerEmailFactory;
import edu.cornell.mannlib.vitro.webapp.email.FreemarkerEmailMessage;
import edu.cornell.mannlib.vitro.webapp.freemarker.config.FreemarkerConfiguration;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.Tags;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.User;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.menu.MainMenu;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.utility.DeepUnwrap;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.mail.Message;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FreemarkerHttpServlet
extends VitroHttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(FreemarkerHttpServlet.class);
    public static final String PAGE_TEMPLATE_TYPE = "page";
    public static final String BODY_TEMPLATE_TYPE = "body";

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        super.doGet(request, response);
        VitroRequest vreq = new VitroRequest(request);
        ResponseValues responseValues = null;
        try {
            if (!this.isAuthorizedToDisplayPage(request, response, this.requiredActions(vreq))) {
                return;
            }
            responseValues = this.processRequest(vreq);
            this.doResponse(vreq, response, responseValues);
        }
        catch (Throwable e) {
            if (e instanceof IOException || e instanceof ServletException) {
                try {
                    throw e;
                }
                catch (Throwable e1) {
                    this.handleException(vreq, response, e);
                }
            }
            this.handleException(vreq, response, e);
        }
    }

    protected void handleException(VitroRequest vreq, HttpServletResponse response, Throwable t) throws ServletException {
        try {
            String cause;
            HashMap<String, Object> templateMap = new HashMap<String, Object>();
            String templateName = Template.ERROR_DISPLAY.toString();
            int statusCode = 500;
            HashMap<String, Object> adminErrorData = new HashMap<String, Object>();
            StringBuffer requestedUrl = vreq.getRequestURL();
            String queryString = vreq.getQueryString();
            if (queryString != null) {
                requestedUrl.append(queryString);
            }
            adminErrorData.put("requestedUrl", requestedUrl);
            String errorMessage = t.getMessage();
            adminErrorData.put("errorMessage", errorMessage);
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            String stackTrace = sw.toString();
            adminErrorData.put("stackTrace", stackTrace);
            sw = new StringWriter();
            Throwable c = t.getCause();
            if (c != null) {
                c.printStackTrace(new PrintWriter(sw));
                cause = sw.toString();
            } else {
                cause = "";
            }
            adminErrorData.put("cause", cause);
            adminErrorData.put("datetime", new Date());
            templateMap.put("errorOnHomePage", this instanceof HomePageController);
            boolean sentEmail = false;
            if (PolicyHelper.isAuthorizedForActions((HttpServletRequest)vreq, new AuthorizationRequest[]{SimplePermission.USE_MISCELLANEOUS_ADMIN_PAGES.ACTION})) {
                templateMap.put("adminErrorData", adminErrorData);
            } else if (FreemarkerEmailFactory.isConfigured((HttpServletRequest)vreq)) {
                FreemarkerEmailMessage email = FreemarkerEmailFactory.createNewMessage(vreq);
                email.addRecipient(Message.RecipientType.TO, email.getReplyToAddress());
                email.setTemplate(Template.ERROR_EMAIL.toString());
                email.setBodyMap(adminErrorData);
                email.processTemplate();
                sentEmail = email.send();
            }
            templateMap.put("sentEmail", sentEmail);
            ExceptionResponseValues rv = new ExceptionResponseValues(templateName, templateMap, t, statusCode);
            this.doResponse(vreq, response, rv);
        }
        catch (TemplateProcessingHelper.TemplateProcessingException e) {
            throw new ServletException();
        }
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return AuthorizationRequest.AUTHORIZED;
    }

    protected ResponseValues processRequest(VitroRequest vreq) throws Exception {
        return null;
    }

    protected void doResponse(VitroRequest vreq, HttpServletResponse response, ResponseValues values) throws TemplateProcessingHelper.TemplateProcessingException {
        try {
            int statusCode = values.getStatusCode();
            if (statusCode > 0) {
                response.setStatus(statusCode);
            }
            if (values instanceof NotAuthorizedResponseValues) {
                this.doNotAuthorized(vreq, response, (NotAuthorizedResponseValues)values);
            } else if (values instanceof ExceptionResponseValues) {
                this.doException(vreq, response, values);
            } else if (values instanceof TemplateResponseValues) {
                this.doTemplate(vreq, response, values);
            } else if (values instanceof RedirectResponseValues) {
                this.doRedirect((HttpServletRequest)vreq, response, values);
            } else if (values instanceof ForwardResponseValues) {
                this.doForward((HttpServletRequest)vreq, response, values);
            } else if (values instanceof RdfResponseValues) {
                this.doRdf((HttpServletRequest)vreq, response, values);
            }
        }
        catch (ServletException e) {
            log.error((Object)"ServletException in doResponse()", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"IOException in doResponse()", (Throwable)e);
        }
    }

    private void doNotAuthorized(VitroRequest vreq, HttpServletResponse response, NotAuthorizedResponseValues values) {
        this.isAuthorizedToDisplayPage((HttpServletRequest)vreq, response, values.getUnauthorizedAction());
    }

    protected void doTemplate(VitroRequest vreq, HttpServletResponse response, ResponseValues values) throws TemplateProcessingHelper.TemplateProcessingException {
        String bodyString;
        HashMap<String, Object> templateDataModel = new HashMap<String, Object>();
        templateDataModel.putAll(this.getPageTemplateValues(vreq));
        templateDataModel.putAll(values.getMap());
        String bodyTemplate = values.getTemplateName();
        if (bodyTemplate != null) {
            templateDataModel.put("templateType", BODY_TEMPLATE_TYPE);
            bodyString = this.processTemplateToString(bodyTemplate, templateDataModel, (HttpServletRequest)vreq);
        } else {
            bodyString = "";
        }
        templateDataModel.put(BODY_TEMPLATE_TYPE, bodyString);
        templateDataModel.put("templateType", PAGE_TEMPLATE_TYPE);
        this.writePage(templateDataModel, (HttpServletRequest)vreq, response, values.getStatusCode(), values);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void doRedirect(HttpServletRequest request, HttpServletResponse response, ResponseValues values) throws ServletException, IOException {
        String redirectUrl = values.getRedirectUrl();
        if (values.getStatusCode() != 0) {
            if (values.getStatusCode() != 302) {
                response.setStatus(values.getStatusCode());
                response.setHeader("Location", redirectUrl);
                return;
            }
        }
        this.setResponseStatus(response, values.getStatusCode());
        response.sendRedirect(redirectUrl);
    }

    private void setResponseStatus(HttpServletResponse response, int statusCode) {
        if (statusCode > 0) {
            response.setStatus(statusCode);
        }
    }

    protected void doForward(HttpServletRequest request, HttpServletResponse response, ResponseValues values) throws ServletException, IOException {
        String forwardUrl = values.getForwardUrl();
        if (forwardUrl.contains("://")) {
            response.sendRedirect(forwardUrl);
        } else {
            request.getRequestDispatcher(forwardUrl).forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected void doRdf(HttpServletRequest request, HttpServletResponse response, ResponseValues values) throws IOException {
        String mediaType = values.getContentType().getMediaType();
        response.setContentType(mediaType);
        if ("application/json".equals(mediaType) || "application/ld+json".equals(mediaType)) {
            try {
                JenaRDFParser parser = new JenaRDFParser();
                Object json = JSONLD.fromRDF((Object)values.getModel(), (RDFParser)parser);
                JSONUtils.write((Writer)response.getWriter(), (Object)json);
            }
            catch (JSONLDProcessingError e) {
                throw new IOException("Could not convert from Jena model to JSON-LD", e);
            }
        } else {
            String format = "";
            if ("application/rdf+xml".equals(mediaType)) {
                format = "RDF/XML";
            } else if ("text/n3".equals(mediaType)) {
                format = "N3";
            } else if ("text/turtle".equals(mediaType)) {
                format = "TTL";
            }
            values.getModel().write((OutputStream)response.getOutputStream(), format);
        }
    }

    protected void doException(VitroRequest vreq, HttpServletResponse response, ResponseValues values) throws TemplateProcessingHelper.TemplateProcessingException {
        log.error((Object)values.getException(), values.getException());
        this.doTemplate(vreq, response, values);
    }

    public String getThemeDir(ApplicationBean appBean) {
        return appBean.getThemeDir().replaceAll("/$", "");
    }

    private Map<String, Object> buildRequestUrls(VitroRequest vreq) {
        HashMap<String, Object> requestUrls = new HashMap<String, Object>();
        Configuration config = FreemarkerConfiguration.getConfig((HttpServletRequest)vreq);
        TemplateModel urlModel = config.getSharedVariable("urls");
        try {
            Map configUrls = (Map)DeepUnwrap.permissiveUnwrap((TemplateModel)urlModel);
            requestUrls.putAll(configUrls);
            if (FreemarkerEmailFactory.isConfigured((HttpServletRequest)vreq)) {
                requestUrls.put("contact", UrlBuilder.getUrl(UrlBuilder.Route.CONTACT));
            }
            requestUrls.put("currentPage", this.getCurrentPageUrl((HttpServletRequest)vreq));
            requestUrls.put("referringPage", this.getReferringPageUrl((HttpServletRequest)vreq));
            if (PolicyHelper.isAuthorizedForActions((HttpServletRequest)vreq, new AuthorizationRequest[]{SimplePermission.EDIT_OWN_ACCOUNT.ACTION})) {
                requestUrls.put("myAccount", UrlBuilder.getUrl("/accounts/myAccount"));
            }
        }
        catch (TemplateModelException e) {
            log.error((Object)e, (Throwable)e);
        }
        return requestUrls;
    }

    private String getCurrentPageUrl(HttpServletRequest request) {
        String path = request.getServletPath().replaceFirst("/", "");
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            path = path + pathInfo;
        }
        path = this.normalizeServletName(path);
        return UrlBuilder.getUrl(path);
    }

    private String getReferringPageUrl(HttpServletRequest request) {
        String referrer = request.getHeader("referer");
        return referrer == null ? UrlBuilder.getHomeUrl() : referrer;
    }

    protected TemplateModel wrap(Object obj, int exposureLevel) throws TemplateModelException {
        BeansWrapper wrapper = this.getBeansWrapper(exposureLevel);
        return wrapper.wrap(obj);
    }

    protected TemplateModel wrap(Object obj, BeansWrapper wrapper) throws TemplateModelException {
        return wrapper.wrap(obj);
    }

    protected BeansWrapper getBeansWrapper(int exposureLevel) {
        DefaultObjectWrapper wrapper = new DefaultObjectWrapper();
        wrapper.setExposureLevel(exposureLevel);
        return wrapper;
    }

    protected Map<String, Object> getPageTemplateValues(VitroRequest vreq) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ApplicationBean appBean = vreq.getAppBean();
        map.put("title", this.getTitle(vreq.getAppBean().getApplicationName(), vreq));
        map.put("siteName", vreq.getAppBean().getApplicationName());
        map.put("urls", this.buildRequestUrls(vreq));
        map.put("menu", this.getDisplayModelMenu(vreq));
        map.put("user", new User(vreq));
        String flashMessage = DisplayMessage.getMessageAndClear((HttpServletRequest)vreq);
        if (!flashMessage.isEmpty()) {
            map.put("flash", flashMessage);
        }
        map.put("currentServlet", this.normalizeServletName(vreq.getServletPath().replaceFirst("/", "")));
        map.put("copyright", this.getCopyrightInfo(appBean));
        map.put("stylesheets", new Tags().wrap());
        map.put("scripts", new Tags().wrap());
        map.put("headScripts", new Tags().wrap());
        return map;
    }

    private String normalizeServletName(String name) {
        return name.length() == 0 || name.equals("index.jsp") ? "home" : name;
    }

    protected MainMenu getDisplayModelMenu(VitroRequest vreq) {
        String url = vreq.getRequestURI().substring(vreq.getContextPath().length());
        return vreq.getWebappDaoFactory().getMenuDao().getMainMenu(url);
    }

    private final Map<String, Object> getCopyrightInfo(ApplicationBean appBean) {
        HashMap<String, Object> copyright = null;
        String copyrightText = appBean.getCopyrightAnchor();
        if (!StringUtils.isEmpty((String)copyrightText)) {
            copyright = new HashMap<String, Object>();
            copyright.put("text", copyrightText);
            int thisYear = Calendar.getInstance().get(1);
            copyright.put("year", thisYear);
            copyright.put("url", appBean.getCopyrightURL());
        }
        return copyright;
    }

    protected String getTitle(String siteName, VitroRequest vreq) {
        return siteName;
    }

    protected StringWriter processTemplate(String templateName, Map<String, Object> map, HttpServletRequest request) throws TemplateProcessingHelper.TemplateProcessingException {
        TemplateProcessingHelper helper = new TemplateProcessingHelper(request, this.getServletContext());
        return helper.processTemplate(templateName, map);
    }

    protected String processTemplateToString(String templateName, Map<String, Object> map, HttpServletRequest request) throws TemplateProcessingHelper.TemplateProcessingException {
        return this.processTemplate(templateName, map, request).toString();
    }

    protected void writePage(Map<String, Object> root, HttpServletRequest request, HttpServletResponse response, int statusCode, ResponseValues rv) throws TemplateProcessingHelper.TemplateProcessingException {
        String pageTemplateName = rv instanceof ExceptionResponseValues ? Template.PAGE_DEFAULT.toString() : this.getPageTemplateName();
        this.writeTemplate(pageTemplateName, root, request, response, statusCode);
    }

    protected void writeTemplate(String templateName, Map<String, Object> map, HttpServletRequest request, HttpServletResponse response) throws TemplateProcessingHelper.TemplateProcessingException {
        this.writeTemplate(templateName, map, request, response, 0);
    }

    protected void writeTemplate(String templateName, Map<String, Object> map, HttpServletRequest request, HttpServletResponse response, int statusCode) throws TemplateProcessingHelper.TemplateProcessingException {
        StringWriter sw = this.processTemplate(templateName, map, request);
        this.write(sw, response, statusCode);
    }

    protected void write(StringWriter sw, HttpServletResponse response, int statusCode) {
        try {
            this.setResponseStatus(response, statusCode);
            PrintWriter out = response.getWriter();
            out.print(sw);
        }
        catch (IOException e) {
            log.error((Object)"FreeMarkerHttpServlet cannot write output", (Throwable)e);
        }
    }

    protected String getPageTemplateName() {
        return Template.PAGE_DEFAULT.toString();
    }

    public static void getFreemarkerComponentsForJsp(HttpServletRequest request) {
        new FreemarkerComponentGenerator(request);
    }

    protected static enum Template {
        SETUP("setup.ftl"),
        PAGE_DEFAULT("page.ftl"),
        ERROR_DISPLAY("error-display.ftl"),
        ERROR_EMAIL("error-email.ftl"),
        ERROR_MESSAGE("error-message.ftl"),
        STANDARD_ERROR("error-standard.ftl"),
        TITLED_ERROR_MESSAGE("error-titled.ftl"),
        MESSAGE("message.ftl"),
        TITLED_MESSAGE("message-titled.ftl");

        private final String filename;

        private Template(String filename) {
            this.filename = filename;
        }

        public String toString() {
            return this.filename;
        }
    }
}

