/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.grefine;

import com.hp.hpl.jena.vocabulary.OWL;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class GrefinePropertyListServlet
extends VitroHttpServlet {
    private int MAXDEPTH = 7;
    public static final int MAX_QUERY_LENGTH = 500;
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog((String)GrefinePropertyListServlet.class.getName());

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPost(req, resp);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doGet(req, resp);
        resp.setContentType("application/json");
        VitroRequest vreq = new VitroRequest(req);
        try {
            String callbackStr = vreq.getParameter("callback") == null ? "" : vreq.getParameter("callback");
            ServletOutputStream out = resp.getOutputStream();
            VClassDao vcDao = vreq.getUnfilteredWebappDaoFactory().getVClassDao();
            DataPropertyDao dao = vreq.getUnfilteredWebappDaoFactory().getDataPropertyDao();
            String topUri = vreq.getParameter("type");
            VClass topClass = vcDao.getVClassByURI(topUri);
            HashSet<String> propURIs = new HashSet<String>();
            HashMap<VClass, List<DataProperty>> classPropertiesMap = this.populateClassPropertiesMap(vcDao, dao, topUri, propURIs);
            JSONObject completeJson = new JSONObject();
            JSONArray propertiesJsonArr = new JSONArray();
            if (classPropertiesMap.size() > 0) {
                for (VClass vc : classPropertiesMap.keySet()) {
                    ArrayList vcProps = (ArrayList)classPropertiesMap.get(vc);
                    for (DataProperty prop : vcProps) {
                        String nameStr = prop.getPublicName() == null ? (prop.getName() == null ? null : prop.getName()) : prop.getPublicName();
                        JSONObject propertiesItemJson = new JSONObject();
                        JSONObject rootSchemaJson = new JSONObject();
                        rootSchemaJson.put("id", vc.getURI());
                        rootSchemaJson.put("name", vc.getName());
                        rootSchemaJson.put("alias", new JSONArray());
                        propertiesItemJson.put("schema", rootSchemaJson);
                        propertiesItemJson.put("id", prop.getURI());
                        propertiesItemJson.put("name", nameStr);
                        propertiesItemJson.put("alias", new JSONArray());
                        JSONObject expectsJson = new JSONObject();
                        expectsJson.put("id", prop.getURI());
                        expectsJson.put("name", nameStr);
                        expectsJson.put("alias", new JSONArray());
                        propertiesItemJson.put("expects", expectsJson);
                        propertiesJsonArr.put(propertiesItemJson);
                    }
                }
            }
            ArrayList<VClass> lvl2Classes = new ArrayList<VClass>();
            LinkedList<VClass> roots = null;
            String requestType = vreq.getParameter("type");
            if (requestType != null) {
                roots = new LinkedList<VClass>();
                roots.add(vcDao.getVClassByURI(requestType));
            }
            if (roots != null) {
                String ontologyUri = null;
                Collections.sort(roots);
                Iterator rootIt = roots.iterator();
                if (rootIt.hasNext()) {
                    while (rootIt.hasNext()) {
                        VClass root = (VClass)rootIt.next();
                        if (root == null) continue;
                        ArrayList<VClass> lvl2ChildClasses = new ArrayList<VClass>();
                        this.addChildren(vcDao, vreq.getUnfilteredWebappDaoFactory(), root, lvl2ChildClasses, 0, ontologyUri);
                        lvl2Classes.addAll(lvl2ChildClasses);
                    }
                }
            }
            for (VClass lvl2Class : lvl2Classes) {
                HashMap<VClass, List<DataProperty>> lvl2ClassPropertiesMap = this.populateClassPropertiesMap(vcDao, dao, lvl2Class.getURI(), propURIs);
                if (lvl2ClassPropertiesMap.size() <= 0) continue;
                for (VClass vc : lvl2ClassPropertiesMap.keySet()) {
                    ArrayList vcProps = (ArrayList)lvl2ClassPropertiesMap.get(vc);
                    for (DataProperty prop : vcProps) {
                        String nameStr = prop.getPublicName() == null ? (prop.getName() == null ? null : prop.getName()) : prop.getPublicName();
                        JSONObject propertiesItemJson = new JSONObject();
                        JSONObject rootSchemaJson = new JSONObject();
                        rootSchemaJson.put("id", topClass.getURI());
                        rootSchemaJson.put("name", topClass.getName());
                        rootSchemaJson.put("alias", new JSONArray());
                        propertiesItemJson.put("schema", rootSchemaJson);
                        propertiesItemJson.put("id", vc.getURI());
                        propertiesItemJson.put("name", vc.getName());
                        propertiesItemJson.put("alias", new JSONArray());
                        propertiesItemJson.put("id2", prop.getURI());
                        propertiesItemJson.put("name2", nameStr);
                        propertiesItemJson.put("alias2", new JSONArray());
                        JSONObject expectsJson = new JSONObject();
                        expectsJson.put("id", prop.getURI());
                        expectsJson.put("name", nameStr);
                        expectsJson.put("alias", new JSONArray());
                        propertiesItemJson.put("expects", expectsJson);
                        propertiesJsonArr.put(propertiesItemJson);
                    }
                }
            }
            completeJson.put("properties", propertiesJsonArr);
            out.print(callbackStr + "(" + completeJson.toString() + ")");
        }
        catch (Exception ex) {
            log.warn((Object)ex, (Throwable)ex);
        }
    }

    private HashMap<VClass, List<DataProperty>> populateClassPropertiesMap(VClassDao vcDao, DataPropertyDao dao, String uri, HashSet<String> propURIs) {
        HashMap<VClass, List<DataProperty>> classPropertiesMap = new HashMap<VClass, List<DataProperty>>();
        ArrayList<DataProperty> props = new ArrayList<DataProperty>();
        VClass topVc = vcDao.getVClassByURI(uri);
        List<DataProperty> dataProps = dao.getDataPropertiesForVClass(uri);
        for (DataProperty dp : dataProps) {
            if (propURIs.contains(dp.getURI())) continue;
            propURIs.add(dp.getURI());
            DataProperty prop = dao.getDataPropertyByURI(dp.getURI());
            if (prop == null) continue;
            props.add(prop);
        }
        if (props.size() > 0) {
            Collections.sort(props);
            for (DataProperty prop : props) {
                Object nameStr = prop.getPublicName() == null ? (prop.getName() == null ? null : prop.getName()) : prop.getPublicName();
                if (nameStr == null) continue;
                if (prop.getDomainClassURI() != null) {
                    VClass vc = vcDao.getVClassByURI(prop.getDomainClassURI());
                    if (classPropertiesMap.get(vc) != null) {
                        ArrayList existingList = (ArrayList)classPropertiesMap.get(vc);
                        existingList.add(prop);
                        continue;
                    }
                    ArrayList<DataProperty> newList = new ArrayList<DataProperty>();
                    newList.add(prop);
                    classPropertiesMap.put(vc, newList);
                    continue;
                }
                if (classPropertiesMap.get(topVc) != null) {
                    ArrayList existingList = (ArrayList)classPropertiesMap.get(topVc);
                    existingList.add(prop);
                    continue;
                }
                ArrayList<DataProperty> newList = new ArrayList<DataProperty>();
                newList.add(prop);
                classPropertiesMap.put(topVc, newList);
            }
        }
        return classPropertiesMap;
    }

    private void addChildren(VClassDao vcDao, WebappDaoFactory wadf, VClass parent, List<VClass> list, int position, String ontologyUri) {
        List<VClass> rowElts = this.addVClassDataToResultsList(wadf, parent, position, ontologyUri);
        int childShift = rowElts.size() > 0 ? 1 : 0;
        list.addAll(rowElts);
        List<String> childURIstrs = vcDao.getSubClassURIs(parent.getURI());
        if (childURIstrs.size() > 0 && position < this.MAXDEPTH) {
            ArrayList<VClass> childClasses = new ArrayList<VClass>();
            for (String URIstr : childURIstrs) {
                try {
                    VClass child = vcDao.getVClassByURI(URIstr);
                    if (child.getURI().equals(OWL.Nothing.getURI())) continue;
                    childClasses.add(child);
                }
                catch (Exception child) {}
            }
            Collections.sort(childClasses);
            for (VClass child : childClasses) {
                this.addChildren(vcDao, wadf, child, list, position + childShift, ontologyUri);
            }
        }
    }

    private List<VClass> addVClassDataToResultsList(WebappDaoFactory wadf, VClass vcw, int position, String ontologyUri) {
        ArrayList<VClass> results = new ArrayList<VClass>();
        if (ontologyUri == null || vcw.getNamespace() != null && vcw.getNamespace().equals(ontologyUri)) {
            results.add(vcw);
        }
        return results;
    }

    private Integer addColToResults(String value, List results, Integer colIndex) {
        if (colIndex > 0) {
            results.add(value);
        }
        return colIndex - 1;
    }
}

