/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.filtering;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyInstance;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyInstanceIface;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyInstanceDao;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.filters.VitroFilters;
import java.util.Collection;
import java.util.LinkedList;
import net.sf.jga.algorithms.Filter;
import net.sf.jga.fn.UnaryFunctor;

public class FilteringPropertyInstanceDao
implements PropertyInstanceDao {
    private final PropertyInstanceDao innerPropertyInstanceDao;
    private final VitroFilters filters;
    private final UnaryFunctor<PropertyInstance, Boolean> propertyInstanceFilter;
    private final IndividualDao individualDao;
    private final ObjectPropertyDao objectPropDao;

    public FilteringPropertyInstanceDao(PropertyInstanceDao propertyInstanceDao, final ObjectPropertyDao objectPropDao, final IndividualDao individualDao, final VitroFilters filters) {
        if (propertyInstanceDao == null) {
            throw new IllegalArgumentException("Must pass a non null PropertyInstanceDao to constructor");
        }
        if (filters == null) {
            throw new IllegalArgumentException("Must pass a non-null VitroFilters to constructor");
        }
        this.innerPropertyInstanceDao = propertyInstanceDao;
        this.filters = filters;
        this.individualDao = individualDao;
        this.objectPropDao = objectPropDao;
        this.propertyInstanceFilter = new UnaryFunctor<PropertyInstance, Boolean>(){

            public Boolean fn(PropertyInstance inst) {
                if (inst == null) {
                    return false;
                }
                if (inst.getSubjectEntURI() == null && inst.getPropertyURI() == null && inst.getRangeClassURI() == null) {
                    return false;
                }
                if (inst.getSubjectEntURI() == null && inst.getObjectEntURI() == null && inst.getPropertyURI() != null) {
                    ObjectProperty op = objectPropDao.getObjectPropertyByURI(inst.getPropertyURI());
                    if (op == null) {
                        return false;
                    }
                    return (Boolean)filters.getObjectPropertyFilter().fn((Object)op);
                }
                Individual sub = individualDao.getIndividualByURI(inst.getSubjectEntURI());
                if (!((Boolean)filters.getIndividualFilter().fn((Object)sub)).booleanValue()) {
                    return false;
                }
                Individual obj = individualDao.getIndividualByURI(inst.getObjectEntURI());
                if (!((Boolean)filters.getIndividualFilter().fn((Object)obj)).booleanValue()) {
                    return false;
                }
                ObjectProperty prop = objectPropDao.getObjectPropertyByURI(inst.getPropertyURI());
                if (!((Boolean)filters.getObjectPropertyFilter().fn((Object)prop)).booleanValue()) {
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    public Collection<PropertyInstance> getAllPossiblePropInstForIndividual(String individualURI) {
        Collection<PropertyInstance> innerInst = this.innerPropertyInstanceDao.getAllPossiblePropInstForIndividual(individualURI);
        LinkedList<PropertyInstance> out = new LinkedList<PropertyInstance>();
        Filter.filter(innerInst, this.propertyInstanceFilter, out);
        return out;
    }

    @Override
    public Collection<PropertyInstance> getAllPropInstByVClass(String classURI) {
        Collection<PropertyInstance> innerInst = this.innerPropertyInstanceDao.getAllPropInstByVClass(classURI);
        LinkedList<PropertyInstance> out = new LinkedList<PropertyInstance>();
        Filter.filter(innerInst, this.propertyInstanceFilter, out);
        return out;
    }

    @Override
    public Collection<PropertyInstance> getExistingProperties(String entityURI, String propertyURI) {
        Collection<PropertyInstance> innerInst = this.innerPropertyInstanceDao.getExistingProperties(entityURI, propertyURI);
        LinkedList<PropertyInstance> out = new LinkedList<PropertyInstance>();
        Filter.filter(innerInst, this.propertyInstanceFilter, out);
        return out;
    }

    @Override
    public PropertyInstance getProperty(String subjectURI, String predicateURI, String objectURI) {
        PropertyInstance propInst = this.innerPropertyInstanceDao.getProperty(subjectURI, predicateURI, objectURI);
        if (((Boolean)this.propertyInstanceFilter.fn((Object)propInst)).booleanValue()) {
            return propInst;
        }
        return null;
    }

    @Override
    public void deleteObjectPropertyStatement(String subjectURI, String propertyURI, String objectURI) {
        this.innerPropertyInstanceDao.deleteObjectPropertyStatement(subjectURI, propertyURI, objectURI);
    }

    @Override
    public void deletePropertyInstance(PropertyInstance prop) {
        this.innerPropertyInstanceDao.deletePropertyInstance(prop);
    }

    @Override
    public int insertProp(PropertyInstanceIface prop) {
        return this.innerPropertyInstanceDao.insertProp(prop);
    }

    @Override
    public void insertPropertyInstance(PropertyInstance prop) {
        this.innerPropertyInstanceDao.insertPropertyInstance(prop);
    }
}

