/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.filtering.filters;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jga.fn.UnaryFunctor;

public class EntityPropertyListFilter
extends UnaryFunctor<List<Property>, List<Property>> {
    private static final com.hp.hpl.jena.rdf.model.Property MASKS_PROPERTY = ResourceFactory.createProperty((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#masksProperty");
    private Map<String, Collection<String>> propertyMaskMap = new HashMap<String, Collection<String>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityPropertyListFilter(OntModel ontModel) {
        ontModel.enterCriticalSection(true);
        try {
            StmtIterator maskStmtIt = ontModel.listStatements((Resource)null, MASKS_PROPERTY, (RDFNode)null);
            while (maskStmtIt.hasNext()) {
                Statement maskStmt = maskStmtIt.nextStatement();
                if (maskStmt.getSubject().isAnon() || !maskStmt.getObject().isResource() || ((Resource)maskStmt.getObject()).isAnon()) continue;
                String maskedPropertyURI = ((Resource)maskStmt.getObject()).getURI();
                String maskingPropertyURI = maskStmt.getSubject().getURI();
                Collection<String> collectionOfMaskers = this.propertyMaskMap.get(maskedPropertyURI);
                if (collectionOfMaskers == null) {
                    collectionOfMaskers = new LinkedList<String>();
                }
                if (!collectionOfMaskers.contains(maskingPropertyURI)) {
                    collectionOfMaskers.add(maskingPropertyURI);
                }
                this.propertyMaskMap.put(maskedPropertyURI, collectionOfMaskers);
            }
        }
        finally {
            ontModel.leaveCriticalSection();
        }
    }

    public List<Property> fn(List<Property> propertyList) {
        ArrayList<Property> filteredList = new ArrayList<Property>();
        HashMap<String, Property> urisToProps = new HashMap<String, Property>();
        for (Property p : propertyList) {
            urisToProps.put(p.getURI(), p);
        }
        for (Property p : propertyList) {
            Collection<String> maskingPropertyURIs = this.propertyMaskMap.get(p.getURI());
            if (maskingPropertyURIs == null) {
                filteredList.add(p);
                continue;
            }
            Property maskingProp = null;
            for (String maskingURI : maskingPropertyURIs) {
                if (!urisToProps.keySet().contains(maskingURI)) continue;
                maskingProp = (Property)urisToProps.get(maskingURI);
                break;
            }
            boolean propHasStatements = false;
            boolean maskerHasStatements = false;
            if (maskingProp != null) {
                List<Object> stmtList;
                if (p instanceof ObjectProperty) {
                    stmtList = ((ObjectProperty)p).getObjectPropertyStatements();
                    propHasStatements = stmtList != null && stmtList.size() > 0;
                } else if (p instanceof DataProperty) {
                    stmtList = ((DataProperty)p).getDataPropertyStatements();
                    boolean bl = propHasStatements = stmtList != null && stmtList.size() > 0;
                }
                if (maskingProp instanceof ObjectProperty) {
                    stmtList = ((ObjectProperty)maskingProp).getObjectPropertyStatements();
                    maskerHasStatements = stmtList != null && stmtList.size() > 0;
                } else if (maskingProp instanceof DataProperty) {
                    stmtList = ((DataProperty)maskingProp).getDataPropertyStatements();
                    boolean bl = maskerHasStatements = stmtList != null && stmtList.size() > 0;
                }
            }
            if (maskingProp != null && !(propHasStatements & !maskerHasStatements)) continue;
            filteredList.add(p);
        }
        return filteredList;
    }
}

