/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceGraph;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RDFServiceGraphBulkUpdater
implements BulkUpdateHandler {
    private static final Log log = LogFactory.getLog(RDFServiceGraphBulkUpdater.class);
    private final RDFServiceGraph graph;
    private final GraphEventManager manager;

    public RDFServiceGraphBulkUpdater(RDFServiceGraph graph) {
        this.graph = graph;
        this.manager = graph.getEventManager();
    }

    @Deprecated
    public void add(Triple[] arg0) {
        Graph g = GraphFactory.createPlainGraph();
        for (int i = 0; i < arg0.length; ++i) {
            g.add(arg0[i]);
        }
        this.add(g);
    }

    @Deprecated
    public void add(List<Triple> arg0) {
        Graph g = GraphFactory.createPlainGraph();
        for (Triple t : arg0) {
            g.add(t);
        }
        this.add(g);
    }

    @Deprecated
    public void add(Iterator<Triple> arg0) {
        Graph g = GraphFactory.createPlainGraph();
        while (arg0.hasNext()) {
            Triple t = arg0.next();
            g.add(t);
        }
        this.add(g);
    }

    @Deprecated
    public void add(Graph arg0) {
        this.add(arg0, false);
    }

    @Deprecated
    public void add(Graph g, boolean arg1) {
        Model[] model = this.separateStatementsWithBlankNodes(g);
        this.addModel(model[1]);
        this.addModel(model[0]);
    }

    private Model[] separateStatementsWithBlankNodes(Graph g) {
        Model gm = ModelFactory.createModelForGraph((Graph)g);
        Model blankNodeModel = ModelFactory.createDefaultModel();
        Model nonBlankNodeModel = ModelFactory.createDefaultModel();
        StmtIterator sit = gm.listStatements();
        while (sit.hasNext()) {
            Statement stmt = sit.nextStatement();
            if (!stmt.getSubject().isAnon() && !stmt.getObject().isAnon()) {
                nonBlankNodeModel.add(stmt);
                continue;
            }
            blankNodeModel.add(stmt);
        }
        Model[] result = new Model[]{blankNodeModel, nonBlankNodeModel};
        return result;
    }

    @Deprecated
    public void delete(Triple[] arg0) {
        Graph g = GraphFactory.createPlainGraph();
        for (int i = 0; i < arg0.length; ++i) {
            g.add(arg0[i]);
        }
        this.delete(g);
    }

    @Deprecated
    public void delete(List<Triple> arg0) {
        Graph g = GraphFactory.createPlainGraph();
        for (Triple t : arg0) {
            g.add(t);
        }
        this.delete(g);
    }

    @Deprecated
    public void delete(Iterator<Triple> arg0) {
        Graph g = GraphFactory.createPlainGraph();
        while (arg0.hasNext()) {
            Triple t = arg0.next();
            g.add(t);
        }
        this.delete(g);
    }

    @Deprecated
    public void delete(Graph g, boolean withReifications) {
        this.delete(g);
    }

    @Deprecated
    public void delete(Graph g) {
        this.deleteModel(ModelFactory.createModelForGraph((Graph)g));
    }

    public void addModel(Model model) {
        ChangeSet changeSet = this.graph.getRDFService().manufactureChangeSet();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        model.write((OutputStream)out, "N-TRIPLE");
        changeSet.addAddition(new ByteArrayInputStream(out.toByteArray()), RDFService.ModelSerializationFormat.N3, this.graph.getGraphURI());
        try {
            this.graph.getRDFService().changeSetUpdate(changeSet);
        }
        catch (RDFServiceException rdfse) {
            throw new RuntimeException(rdfse);
        }
    }

    public void deleteModel(Model model) {
        ChangeSet changeSet = this.graph.getRDFService().manufactureChangeSet();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        model.write((OutputStream)out, "N-TRIPLE");
        changeSet.addRemoval(new ByteArrayInputStream(out.toByteArray()), RDFService.ModelSerializationFormat.N3, this.graph.getGraphURI());
        try {
            this.graph.getRDFService().changeSetUpdate(changeSet);
        }
        catch (RDFServiceException rdfse) {
            throw new RuntimeException(rdfse);
        }
    }

    @Deprecated
    public void removeAll() {
        RDFServiceGraphBulkUpdater.removeAll((Graph)this.graph, null, null, null);
        this.notifyRemoveAll();
    }

    protected void notifyRemoveAll() {
        this.manager.notifyEvent((Graph)this.graph, (Object)GraphEvents.removeAll);
    }

    @Deprecated
    public void remove(Node s, Node p, Node o) {
        RDFServiceGraphBulkUpdater.removeAll((Graph)this.graph, s, p, o);
        this.manager.notifyEvent((Graph)this.graph, (Object)GraphEvents.remove((Node)s, (Node)p, (Node)o));
    }

    private static void removeAll(Graph g, Node s, Node p, Node o) {
        log.debug((Object)("removeAll: g=" + ToString.graphToString(g) + ", s=" + s + ", p=" + p + ", o=" + o));
        if (!(g instanceof RDFServiceGraph)) {
            RDFServiceGraphBulkUpdater.removeAllTripleByTriple(g, s, p, o);
            return;
        }
        RDFServiceGraph graph = (RDFServiceGraph)g;
        String graphURI = graph.getGraphURI();
        StringBuffer findPattern = new StringBuffer().append(RDFServiceGraphBulkUpdater.sparqlNode(s, "?s")).append(" ").append(RDFServiceGraphBulkUpdater.sparqlNode(p, "?p")).append(" ").append(RDFServiceGraphBulkUpdater.sparqlNode(o, "?o"));
        StringBuffer findQuery = new StringBuffer("CONSTRUCT { ").append(findPattern).append(" } WHERE { \n");
        if (graphURI != null) {
            findQuery.append("  GRAPH <" + graphURI + "> { ");
        }
        findQuery.append(findPattern);
        if (graphURI != null) {
            findQuery.append(" } ");
        }
        findQuery.append("\n}");
        String queryString = findQuery.toString();
        int chunkSize = 50000;
        boolean done = false;
        while (!done) {
            String chunkQueryString = queryString + " LIMIT " + chunkSize;
            try {
                Model chunkToRemove = RDFServiceUtils.parseModel(graph.getRDFService().sparqlConstructQuery(chunkQueryString, RDFService.ModelSerializationFormat.N3), RDFService.ModelSerializationFormat.N3);
                if (chunkToRemove.size() > 0L) {
                    ChangeSet cs = graph.getRDFService().manufactureChangeSet();
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    chunkToRemove.write((OutputStream)out, "N-TRIPLE");
                    cs.addRemoval(new ByteArrayInputStream(out.toByteArray()), RDFService.ModelSerializationFormat.N3, graphURI);
                    graph.getRDFService().changeSetUpdate(cs);
                    continue;
                }
                done = true;
            }
            catch (RDFServiceException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static String sparqlNode(Node node, String varName) {
        if (node == null || node.isVariable() || node.isBlank()) {
            return varName;
        }
        if (node.isURI()) {
            StringBuffer uriBuff = new StringBuffer();
            return uriBuff.append("<").append(node.getURI()).append(">").toString();
        }
        if (node.isLiteral()) {
            StringBuffer literalBuff = new StringBuffer();
            literalBuff.append("\"");
            RDFServiceGraphBulkUpdater.pyString(literalBuff, node.getLiteralLexicalForm());
            literalBuff.append("\"");
            if (node.getLiteralDatatypeURI() != null) {
                literalBuff.append("^^<").append(node.getLiteralDatatypeURI()).append(">");
            } else if (node.getLiteralLanguage() != null && node.getLiteralLanguage() != "") {
                literalBuff.append("@").append(node.getLiteralLanguage());
            }
            return literalBuff.toString();
        }
        return varName;
    }

    private static void pyString(StringBuffer sbuff, String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '\"') {
                sbuff.append('\\');
                sbuff.append(c);
                continue;
            }
            if (c == '\n') {
                sbuff.append("\\n");
                continue;
            }
            if (c == '\t') {
                sbuff.append("\\t");
                continue;
            }
            if (c == '\r') {
                sbuff.append("\\r");
                continue;
            }
            if (c == '\f') {
                sbuff.append("\\f");
                continue;
            }
            if (c == '\b') {
                sbuff.append("\\b");
                continue;
            }
            if (c == '\u0007') {
                sbuff.append("\\a");
                continue;
            }
            sbuff.append(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeAllTripleByTriple(Graph g, Node s, Node p, Node o) {
        try (ExtendedIterator it = g.find(s, p, o);){
            while (it.hasNext()) {
                Triple t = (Triple)it.next();
                g.delete(t);
                it.remove();
            }
        }
    }
}

