/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SparqlEvaluateVTwo {
    private static Log log = LogFactory.getLog(SparqlEvaluateVTwo.class);
    Model model;

    public SparqlEvaluateVTwo(Model model) {
        if (model == null) {
            throw new Error("SparqlEvaluate must be passed a Model");
        }
        this.model = model;
    }

    public void evaluateForAdditionalUris(EditConfigurationVTwo editConfig) {
        log.debug((Object)"Evaluating for Additional URIS");
        Map<String, List<String>> varsToUris = this.sparqlEvaluateForUris(editConfig, editConfig.getSparqlForAdditionalUrisInScope());
        editConfig.getUrisInScope().putAll(varsToUris);
    }

    public void evalulateForAdditionalLiterals(EditConfigurationVTwo editConfig) {
        log.debug((Object)"Evaluating for Additional Literals");
        Map<String, List<Literal>> varsToLiterals = this.sparqlEvaluateForLiterals(editConfig, editConfig.getSparqlForAdditionalLiteralsInScope());
        editConfig.getLiteralsInScope().putAll(varsToLiterals);
    }

    public void evaluateForExistingUris(EditConfigurationVTwo editConfig) {
        log.debug((Object)"Evaluating for existing URIS");
        Map<String, List<String>> varsToUris = this.sparqlEvaluateForUris(editConfig, editConfig.getSparqlForExistingUris());
        editConfig.getUrisInScope().putAll(varsToUris);
    }

    public void evaluateForExistingLiterals(EditConfigurationVTwo editConfig) {
        log.debug((Object)"Evaluating for existing literals");
        Map<String, List<Literal>> varsToLiterals = this.sparqlEvaluateForLiterals(editConfig, editConfig.getSparqlForExistingLiterals());
        editConfig.getLiteralsInScope().putAll(varsToLiterals);
    }

    public Map<String, List<Literal>> sparqlEvaluateForLiterals(EditConfigurationVTwo editConfig, Map<String, String> varToSparql) {
        Map<String, List<String>> uriScope = editConfig.getUrisInScope();
        Map<String, List<Literal>> literalScope = editConfig.getLiteralsInScope();
        HashMap<String, List<Literal>> varToLiterals = new HashMap<String, List<Literal>>();
        for (String var : varToSparql.keySet()) {
            String query = varToSparql.get(var);
            log.debug((Object)("Var name " + var + " and query = " + query));
            if (query == null || "USE_SYSTEM_VALUE".equals(query)) {
                log.debug((Object)"Query is null or using system value so will not continue with rest of method");
                continue;
            }
            ArrayList<String> queryStrings = new ArrayList<String>();
            queryStrings.add(query);
            editConfig.getN3Generator().subInMultiUris(uriScope, queryStrings);
            log.debug((Object)("Query after substituting uris in scope: " + ((Object)queryStrings).toString()));
            editConfig.getN3Generator().subInMultiLiterals(literalScope, queryStrings);
            log.debug((Object)("Query after substituting literals in scope: " + ((Object)queryStrings).toString()));
            varToLiterals.put(var, this.queryToLiteral((String)queryStrings.get(0)));
        }
        return varToLiterals;
    }

    public Map<String, List<String>> sparqlEvaluateForUris(EditConfigurationVTwo editConfig, Map<String, String> varToSparql) {
        Map<String, List<String>> uriScope = editConfig.getUrisInScope();
        Map<String, List<Literal>> literalScope = editConfig.getLiteralsInScope();
        HashMap<String, List<String>> varToUris = new HashMap<String, List<String>>();
        for (String var : varToSparql.keySet()) {
            String query = varToSparql.get(var);
            log.debug((Object)("Var name " + var + " and query = " + query));
            if (query == null || "USE_SYSTEM_VALUE".equals(query)) {
                log.debug((Object)"Query is null or using system value so will not continue with rest of method");
                continue;
            }
            ArrayList<String> queryStrings = new ArrayList<String>();
            queryStrings.add(query);
            editConfig.getN3Generator().subInMultiUris(uriScope, queryStrings);
            log.debug((Object)("Query after substituting uris in scope: " + ((Object)queryStrings).toString()));
            editConfig.getN3Generator().subInMultiLiterals(literalScope, queryStrings);
            log.debug((Object)("Query after substituting literals in scope: " + ((Object)queryStrings).toString()));
            List<String> uriFromQuery = this.queryToUri((String)queryStrings.get(0));
            if (uriFromQuery != null) {
                varToUris.put(var, uriFromQuery);
                continue;
            }
            log.debug((Object)("sparqlEvaluateForUris(): for var " + var + " the following query evaluated to null:\n" + (String)queryStrings.get(0) + "\n(end of query)\n"));
        }
        return varToUris;
    }

    public List<String> queryToUri(String querystr) {
        ArrayList<String> values;
        block12: {
            log.debug((Object)("Query string in queryToUri():" + querystr));
            String value = null;
            values = new ArrayList<String>();
            try (QueryExecution qe = null;){
                Query query = QueryFactory.create((String)querystr);
                qe = QueryExecutionFactory.create((Query)query, (Model)this.model);
                if (query.isSelectType()) {
                    ResultSet results = null;
                    results = qe.execSelect();
                    if (results.hasNext()) {
                        List vars = results.getResultVars();
                        if (vars == null) {
                            throw new Error("sparql had no result variables");
                        }
                        for (String var : vars) {
                            QuerySolution qs = results.nextSolution();
                            Resource resource = qs.getResource(var);
                            value = resource.getURI();
                            values.add(value);
                        }
                        break block12;
                    }
                    log.debug((Object)"Query had no results");
                    List<String> list = null;
                    return list;
                }
                throw new Error("only SELECT type SPARQL queries are supported");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("queryToUri() query: '" + querystr + "'\nvalue: '" + ((Object)values).toString() + "'"));
        }
        return values;
    }

    public List<Literal> queryToLiteral(String querystr) {
        ArrayList<Literal> values;
        block12: {
            log.debug((Object)("Executing query " + querystr));
            Literal value = null;
            values = new ArrayList<Literal>();
            try (QueryExecution qe = null;){
                Query query = QueryFactory.create((String)querystr);
                qe = QueryExecutionFactory.create((Query)query, (Model)this.model);
                if (query.isSelectType()) {
                    ResultSet results = null;
                    results = qe.execSelect();
                    if (results.hasNext()) {
                        List vars = results.getResultVars();
                        if (vars == null) {
                            throw new Error("sparql had no result variables");
                        }
                        for (String var : vars) {
                            QuerySolution qs = results.nextSolution();
                            value = qs.getLiteral(var);
                            values.add(value);
                        }
                        break block12;
                    }
                    log.debug((Object)"Query had no results");
                    List<Literal> list = null;
                    return list;
                }
                throw new Error("only SELECT type SPARQL queries are supported");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("queryToLiteral() query: '" + querystr + "'\nvalue: '" + ((Object)values).toString() + "'"));
        }
        return values;
    }
}

