/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.adapters;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.compose.Union;
import com.hp.hpl.jena.graph.impl.GraphWithPerform;
import com.hp.hpl.jena.graph.impl.WrappedBulkUpdateHandler;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.impl.OntModelImpl;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.BulkUpdatingModel;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.BulkUpdatingOntModel;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VitroModelFactory {
    private static final Log log = LogFactory.getLog(VitroModelFactory.class);

    public static Model createModel() {
        return ModelFactory.createDefaultModel();
    }

    public static OntModel createOntologyModel() {
        return ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
    }

    public static OntModel createOntologyModel(Model model) {
        Graph graph = model.getGraph();
        ModelCom bareModel = new ModelCom(graph);
        OntModelImpl ontModel = new OntModelImpl(OntModelSpec.OWL_MEM, (Model)bareModel);
        return new BulkUpdatingOntModel((OntModel)ontModel);
    }

    public static Model createUnion(Model baseModel, Model plusModel) {
        Graph baseGraph = baseModel.getGraph();
        Graph plusGraph = plusModel.getGraph();
        BulkUpdatingUnion unionGraph = new BulkUpdatingUnion(baseGraph, plusGraph);
        BulkUpdateHandler buh = VitroModelFactory.getBulkUpdateHandler((Graph)unionGraph);
        Model unionModel = ModelFactory.createModelForGraph((Graph)unionGraph);
        return new BulkUpdatingModel(unionModel, buh);
    }

    public static OntModel createUnion(OntModel baseModel, OntModel plusModel) {
        Graph baseGraph = baseModel.getGraph();
        Graph plusGraph = plusModel.getGraph();
        BulkUpdatingUnion unionGraph = new BulkUpdatingUnion(baseGraph, plusGraph);
        Model unionModel = ModelFactory.createModelForGraph((Graph)unionGraph);
        OntModel unionOntModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, (Model)unionModel);
        return new BulkUpdatingOntModel(unionOntModel);
    }

    public static Model createModelForGraph(Graph g) {
        BulkUpdateHandler buh = VitroModelFactory.getBulkUpdateHandler(g);
        return new BulkUpdatingModel(ModelFactory.createModelForGraph((Graph)g), buh);
    }

    private static BulkUpdateHandler getBulkUpdateHandler(Graph graph) {
        return graph.getBulkUpdateHandler();
    }

    private static class BulkUpdatingUnion
    extends Union {
        public BulkUpdatingUnion(Graph L, Graph R) {
            super(L, R);
            this.bulkHandler = new WrappedBulkUpdateHandler((GraphWithPerform)this, L.getBulkUpdateHandler());
        }

        public String toString() {
            return "BulkUpdatingUnion[" + ToString.hashHex((Object)this) + ", L=" + ToString.graphToString(this.L) + ", R=" + ToString.graphToString(this.R) + "]";
        }
    }
}

