/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.sdb;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.sdb.SDBFactory;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.StoreDesc;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DatasetWrapper;
import edu.cornell.mannlib.vitro.webapp.dao.jena.StaticDatasetFactory;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.RDFServiceJena;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RDFServiceSDB
extends RDFServiceJena
implements RDFService {
    private static final Log log = LogFactory.getLog(RDFServiceSDB.class);
    private DataSource ds;
    private StoreDesc storeDesc;
    private Connection conn;
    private StaticDatasetFactory staticDatasetFactory;

    public RDFServiceSDB(DataSource dataSource, StoreDesc storeDesc) {
        this.ds = dataSource;
        this.storeDesc = storeDesc;
    }

    public RDFServiceSDB(Connection conn, StoreDesc storeDesc) {
        this.conn = conn;
        this.storeDesc = storeDesc;
        this.staticDatasetFactory = new StaticDatasetFactory(this.getDataset(new SDBConnection(conn)));
    }

    @Override
    protected DatasetWrapper getDatasetWrapper() {
        try {
            if (this.staticDatasetFactory != null) {
                return this.staticDatasetFactory.getDatasetWrapper();
            }
            SDBConnection sdbConn = new SDBConnection(this.ds.getConnection());
            return new DatasetWrapper(this.getDataset(sdbConn), sdbConn);
        }
        catch (SQLException sqle) {
            log.error((Object)sqle, (Throwable)sqle);
            throw new RuntimeException(sqle);
        }
    }

    @Override
    public boolean changeSetUpdate(ChangeSet changeSet) throws RDFServiceException {
        if (changeSet.getPreconditionQuery() != null && !this.isPreconditionSatisfied(changeSet.getPreconditionQuery(), changeSet.getPreconditionQueryType())) {
            return false;
        }
        SDBConnection sdbConn = this.getSDBConnection();
        Dataset dataset = this.getDataset(sdbConn);
        try {
            this.insureThatInputStreamsAreResettable(changeSet);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.beginTransaction(sdbConn);
            this.notifyListenersOfPreChangeEvents(changeSet);
            this.applyChangeSetToModel(changeSet, dataset);
            this.commitTransaction(sdbConn);
            this.notifyListenersOfChanges(changeSet);
            this.notifyListenersOfPostChangeEvents(changeSet);
            boolean e = true;
            return e;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            this.abortTransaction(sdbConn);
            throw new RDFServiceException(e);
        }
        finally {
            this.close(sdbConn);
        }
    }

    private SDBConnection getSDBConnection() throws RDFServiceException {
        try {
            Connection c = this.conn != null ? this.conn : this.ds.getConnection();
            return new SDBConnection(c);
        }
        catch (SQLException sqle) {
            log.error((Object)sqle, (Throwable)sqle);
            throw new RDFServiceException(sqle);
        }
    }

    private void close(SDBConnection sdbConn) {
        if (!sdbConn.getSqlConnection().equals(this.conn)) {
            sdbConn.close();
        }
    }

    private Dataset getDataset(SDBConnection sdbConn) {
        Store store = SDBFactory.connectStore((SDBConnection)sdbConn, (StoreDesc)this.storeDesc);
        store.getLoader().setUseThreading(false);
        return SDBFactory.connectDataset((Store)store);
    }

    private void beginTransaction(SDBConnection sdbConn) {
        if (sdbConn.getTransactionHandler().transactionsSupported()) {
            sdbConn.getTransactionHandler().begin();
        }
    }

    private void commitTransaction(SDBConnection sdbConn) {
        if (sdbConn.getTransactionHandler().transactionsSupported()) {
            sdbConn.getTransactionHandler().commit();
        }
    }

    private void abortTransaction(SDBConnection sdbConn) {
        if (sdbConn.getTransactionHandler().transactionsSupported()) {
            sdbConn.getTransactionHandler().abort();
        }
    }

    @Override
    protected QueryExecution createQueryExecution(String queryString, Query q, Dataset d) {
        return QueryExecutionFactory.create((Query)q, (Dataset)d);
    }

    @Override
    public void close() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }
}

