/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex.indexing;

import com.hp.hpl.jena.rdf.model.Statement;
import edu.cornell.mannlib.vitro.webapp.searchindex.indexing.IndexingUriFinder;
import edu.cornell.mannlib.vitro.webapp.searchindex.indexing.IndexingUriFinderList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndexingUriFinderListBasic
implements IndexingUriFinderList {
    private static final Log log = LogFactory.getLog(IndexingUriFinderListBasic.class);
    private final List<IndexingUriFinder> finders;

    public IndexingUriFinderListBasic(Collection<? extends IndexingUriFinder> finders) {
        this.finders = Collections.synchronizedList(new ArrayList<IndexingUriFinder>(finders));
    }

    @Override
    public void startIndexing() {
        for (IndexingUriFinder finder : this.finders) {
            finder.startIndexing();
        }
    }

    @Override
    public void stopIndexing() {
        for (IndexingUriFinder finder : this.finders) {
            finder.endIndexing();
        }
    }

    @Override
    public Set<String> findAdditionalUris(Statement stmt) {
        HashSet<String> uris = new HashSet<String>();
        for (IndexingUriFinder uriFinder : this.finders) {
            List<String> additions = uriFinder.findAdditionalURIsToIndex(stmt);
            if (log.isDebugEnabled() && !additions.isEmpty()) {
                log.debug((Object)(uriFinder + " found " + additions.size() + " additions " + additions + " for this statement " + stmt));
            }
            for (String addition : additions) {
                if (addition == null) {
                    log.warn((Object)("Finder " + uriFinder + " returned a null URI."));
                    continue;
                }
                uris.add(addition);
            }
        }
        return uris;
    }
}

