/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.sparql;

import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyDao;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetClazzDataProperties
extends BaseEditController {
    private static final Log log = LogFactory.getLog(GetClazzDataProperties.class);

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isAuthorizedToDisplayPage(request, response, SimplePermission.USE_MISCELLANEOUS_PAGES.ACTION)) {
            return;
        }
        VitroRequest vreq = new VitroRequest(request);
        String vClassURI = vreq.getParameter("vClassURI");
        if (vClassURI == null || vClassURI.trim().equals("")) {
            return;
        }
        String respo = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        respo = respo + "<options>";
        respo = respo + "<option><key>label</key><value>http://www.w3.org/2000/01/rdf-schema#label</value></option>";
        DataPropertyDao ddao = vreq.getUnfilteredWebappDaoFactory().getDataPropertyDao();
        List<DataProperty> dataProps = ddao.getDataPropertiesForVClass(vClassURI);
        Iterator dataPropIt = dataProps.iterator();
        HashSet<String> dpropURIs = new HashSet<String>();
        while (dataPropIt.hasNext()) {
            DataProperty dp = (DataProperty)dataPropIt.next();
            if (dpropURIs.contains(dp.getURI())) continue;
            dpropURIs.add(dp.getURI());
            DataProperty dprop = ddao.getDataPropertyByURI(dp.getURI());
            if (dprop == null) continue;
            respo = respo + "<option><key>" + dprop.getLocalName() + "</key>" + "<value>" + dprop.getURI() + "</value>" + "</option>";
        }
        respo = respo + "</options>";
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        out.println(respo);
        out.flush();
        out.close();
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

