/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.tboxreasoner.impl;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import edu.cornell.mannlib.vitro.webapp.dao.jena.event.EditEvent;
import edu.cornell.mannlib.vitro.webapp.modules.tboxreasoner.TBoxReasonerStatus;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.ConfiguredReasonerListener;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.InferenceModelUpdater;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.PatternListBuilder;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.ReasonerConfiguration;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.ReasonerStatementPattern;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.TBoxChanges;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.TBoxReasoner;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.TBoxReasonerDriver;
import edu.cornell.mannlib.vitro.webapp.utils.jena.criticalsection.LockableModel;
import edu.cornell.mannlib.vitro.webapp.utils.jena.criticalsection.LockableOntModel;
import edu.cornell.mannlib.vitro.webapp.utils.jena.criticalsection.LockedOntModel;
import edu.cornell.mannlib.vitro.webapp.utils.threads.VitroBackgroundThread;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasicTBoxReasonerDriver
implements TBoxReasonerDriver {
    private static final Log log = LogFactory.getLog(BasicTBoxReasonerDriver.class);
    private final LockableOntModel lockableAssertionsModel;
    private final LockableModel lockableInferencesModel;
    private final LockableOntModel lockableFullModel;
    private final ReasonerConfiguration reasonerConfiguration;
    private final ConfiguredReasonerListener listener;
    private final Set<TBoxChanges> pendingChangeSets;
    private final ExecutorService executorService;
    private final TBoxReasoner reasoner;
    private TBoxReasoner.Status innerStatus;

    public BasicTBoxReasonerDriver(OntModel assertionsModel, Model inferencesModel, OntModel fullModel, TBoxReasoner reasoner, ReasonerConfiguration reasonerConfiguration) {
        this.lockableAssertionsModel = new LockableOntModel(assertionsModel);
        this.lockableInferencesModel = new LockableModel(inferencesModel);
        this.lockableFullModel = new LockableOntModel(fullModel);
        this.reasoner = reasoner;
        this.reasonerConfiguration = reasonerConfiguration;
        this.listener = new ConfiguredReasonerListener(reasonerConfiguration, this);
        this.pendingChangeSets = Collections.synchronizedSet(new HashSet());
        this.executorService = Executors.newFixedThreadPool(1, new VitroBackgroundThread.Factory("TBoxReasoner"));
        assertionsModel.getBaseModel().register((ModelChangedListener)this.listener);
        fullModel.getBaseModel().register((ModelChangedListener)this.listener);
        this.doInitialReasoning();
    }

    private void doInitialReasoning() {
        try (LockedOntModel assertionsModel = this.lockableAssertionsModel.read();){
            for (ReasonerStatementPattern pat : this.reasonerConfiguration.getInferenceDrivingPatternAllowSet()) {
                this.listener.addedStatements(assertionsModel.listStatements((Resource)null, pat.getPredicate(), (RDFNode)null));
            }
        }
        this.listener.notifyEvent(null, new EditEvent(null, false));
    }

    @Override
    public TBoxReasonerStatus getStatus() {
        return new FullStatus(this.innerStatus, !this.pendingChangeSets.isEmpty());
    }

    @Override
    public void runSynchronizer(TBoxChanges changeSet) {
        if (!changeSet.isEmpty()) {
            this.executorService.execute(new ReasoningTask(changeSet));
        }
    }

    public void shutdown() {
        this.executorService.shutdown();
        for (int waited = 0; waited < 60 && !this.executorService.isTerminated(); waited += 5) {
            try {
                log.info((Object)"Waiting for TBox reasoner to terminate.");
                this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                break;
            }
        }
        if (!this.executorService.isTerminated()) {
            log.warn((Object)"Forcing TBox reasoner to terminate.");
            this.executorService.shutdownNow();
        }
        if (!this.executorService.isTerminated()) {
            log.error((Object)"TBox reasoner did not terminate.");
        }
    }

    private static class FullStatus
    implements TBoxReasonerStatus {
        private final TBoxReasoner.Status reasonerStatus;
        private final boolean reasoning;

        public FullStatus(TBoxReasoner.Status reasonerStatus, boolean reasoning) {
            this.reasonerStatus = reasonerStatus;
            this.reasoning = reasoning;
        }

        @Override
        public boolean isReasoning() {
            return this.reasoning;
        }

        @Override
        public boolean isConsistent() {
            return this.reasonerStatus.isConsistent();
        }

        @Override
        public boolean isInErrorState() {
            return this.reasonerStatus.isInErrorState();
        }

        @Override
        public String getExplanation() {
            String explanation = this.reasonerStatus.getExplanation();
            return explanation == null ? "" : explanation;
        }
    }

    private class ReasoningTask
    implements Runnable {
        private final TBoxChanges changes;
        private List<ReasonerStatementPattern> patternList;

        public ReasoningTask(TBoxChanges changes) {
            this.changes = changes;
            BasicTBoxReasonerDriver.this.pendingChangeSets.add(changes);
        }

        @Override
        public void run() {
            try {
                this.setWorking();
                BasicTBoxReasonerDriver.this.reasoner.updateReasonerModel(this.changes);
                BasicTBoxReasonerDriver.this.innerStatus = BasicTBoxReasonerDriver.this.reasoner.performReasoning();
                this.buildPatternList();
                this.updateInferencesModel();
                this.setIdle();
            }
            finally {
                BasicTBoxReasonerDriver.this.pendingChangeSets.remove(this.changes);
            }
        }

        private void setWorking() {
            Thread current = Thread.currentThread();
            if (current instanceof VitroBackgroundThread) {
                ((VitroBackgroundThread)current).setWorkLevel(VitroBackgroundThread.WorkLevel.WORKING, new String[0]);
            }
        }

        private void setIdle() {
            Thread current = Thread.currentThread();
            if (current instanceof VitroBackgroundThread) {
                ((VitroBackgroundThread)current).setWorkLevel(VitroBackgroundThread.WorkLevel.IDLE, new String[0]);
            }
        }

        private void buildPatternList() {
            PatternListBuilder patternListBuilder = new PatternListBuilder(BasicTBoxReasonerDriver.this.reasonerConfiguration, BasicTBoxReasonerDriver.this.reasoner, this.changes);
            this.patternList = patternListBuilder.build();
        }

        private void updateInferencesModel() {
            InferenceModelUpdater inferenceModelUpdater = new InferenceModelUpdater(BasicTBoxReasonerDriver.this.reasoner, BasicTBoxReasonerDriver.this.lockableInferencesModel, BasicTBoxReasonerDriver.this.lockableFullModel, BasicTBoxReasonerDriver.this.listener);
            inferenceModelUpdater.update(this.patternList);
        }
    }
}

