/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.beanswrappers;

import freemarker.ext.beans.BeansWrapper;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReadOnlyBeansWrapper
extends BeansWrapper {
    private static final Log log = LogFactory.getLog(ReadOnlyBeansWrapper.class);

    public ReadOnlyBeansWrapper() {
        this.setExposureLevel(1);
    }

    protected void finetuneMethodAppearance(Class cls, Method method, BeansWrapper.MethodAppearanceDecision decision) {
        if (method.getName().startsWith("set")) {
            decision.setExposeMethodAs(null);
        } else if (method.getReturnType().getName().equals("void")) {
            decision.setExposeMethodAs(null);
        } else {
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass.equals(Object.class)) {
                decision.setExposeMethodAs(null);
            } else {
                Package pkg = declaringClass.getPackage();
                if (pkg.getName().equals("java.util")) {
                    decision.setExposeMethodAs(null);
                }
            }
        }
    }
}

