/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels;

import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.BaseTemplateModel;
import org.apache.commons.lang.StringEscapeUtils;

public class LinkTemplateModel
extends BaseTemplateModel {
    private String url;
    private String text;

    public LinkTemplateModel() {
    }

    public LinkTemplateModel(String text, String path) {
        this.setText(text);
        this.setUrl(path);
    }

    public LinkTemplateModel(String text, String path, String ... params) {
        this.setText(text);
        this.setUrl(path, params);
    }

    public LinkTemplateModel(String text, String path, UrlBuilder.ParamMap params) {
        this.setText(text);
        this.setUrl(path, params);
    }

    protected void setUrl(String path) {
        this.url = UrlBuilder.getUrl(path);
    }

    protected void setUrl(String path, String ... params) {
        this.url = UrlBuilder.getUrl(path, params);
    }

    protected void setUrl(String path, UrlBuilder.ParamMap params) {
        this.url = UrlBuilder.getUrl(path, params);
    }

    protected void setText(String text) {
        this.text = StringEscapeUtils.escapeHtml((String)text);
    }

    public String getUrl() {
        return this.cleanTextForDisplay(this.url);
    }

    public String getText() {
        return this.cleanTextForDisplay(this.text);
    }
}

