/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual;

import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.DropObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.EditObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.ObjectPropertyTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.PropertyStatementTemplateModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectPropertyStatementTemplateModel
extends PropertyStatementTemplateModel {
    private static final Log log = LogFactory.getLog(ObjectPropertyStatementTemplateModel.class);
    private final Map<String, String> data;
    private final String objectUri;
    private final String templateName;
    private final String objectKey;
    private final String editUrl;
    private final String deleteUrl;

    public ObjectPropertyStatementTemplateModel(String subjectUri, ObjectProperty property, String objectKey, Map<String, String> data, String templateName, VitroRequest vreq) {
        super(subjectUri, property, vreq);
        this.data = Collections.unmodifiableMap(new HashMap<String, String>(data));
        this.objectUri = data.get(objectKey);
        this.templateName = templateName;
        this.objectKey = objectKey;
        this.deleteUrl = this.makeDeleteUrl();
        this.editUrl = this.makeEditUrl();
    }

    private String makeDeleteUrl() {
        if (this.property.isDeleteLinkSuppressed()) {
            return "";
        }
        DropObjectPropertyStatement action = new DropObjectPropertyStatement(this.vreq.getJenaOntModel(), this.subjectUri, this.property, this.objectUri);
        if (!PolicyHelper.isAuthorizedForActions((HttpServletRequest)this.vreq, new AuthorizationRequest[]{action})) {
            return "";
        }
        if ("http://vitro.mannlib.cornell.edu/ns/vitro/public#mainImage".equals(this.property.getURI())) {
            return ObjectPropertyTemplateModel.getImageUploadUrl(this.subjectUri, "delete");
        }
        UrlBuilder.ParamMap params = new UrlBuilder.ParamMap("subjectUri", this.subjectUri, "predicateUri", this.property.getURI(), "objectUri", this.objectUri, "cmd", "delete", "objectKey", this.objectKey);
        for (String key : this.data.keySet()) {
            String value = this.data.get(key);
            if (value == null) continue;
            params.put("statement_" + key, this.data.get(key));
        }
        if (this.property != null && this.property.getDomainVClassURI() != null) {
            params.put("domainUri", this.property.getDomainVClassURI());
        }
        if (this.property != null && this.property.getRangeVClassURI() != null) {
            params.put("rangeUri", this.property.getRangeVClassURI());
        }
        params.put("templateName", this.templateName);
        params.putAll(UrlBuilder.getModelParams(this.vreq));
        return UrlBuilder.getUrl("editRequestDispatch", params);
    }

    private String makeEditUrl() {
        if (this.property.isEditLinkSuppressed()) {
            return "";
        }
        EditObjectPropertyStatement action = new EditObjectPropertyStatement(this.vreq.getJenaOntModel(), this.subjectUri, this.property, this.objectUri);
        if (!PolicyHelper.isAuthorizedForActions((HttpServletRequest)this.vreq, new AuthorizationRequest[]{action})) {
            return "";
        }
        if ("http://vitro.mannlib.cornell.edu/ns/vitro/public#mainImage".equals(this.property.getURI())) {
            return ObjectPropertyTemplateModel.getImageUploadUrl(this.subjectUri, "edit");
        }
        UrlBuilder.ParamMap params = new UrlBuilder.ParamMap("subjectUri", this.subjectUri, "predicateUri", this.property.getURI(), "objectUri", this.objectUri);
        if (this.deleteUrl.isEmpty()) {
            params.put("deleteProhibited", "prohibited");
        }
        if (this.property != null && this.property.getDomainVClassURI() != null) {
            params.put("domainUri", this.property.getDomainVClassURI());
        }
        if (this.property != null && this.property.getRangeVClassURI() != null) {
            params.put("rangeUri", this.property.getRangeVClassURI());
        }
        params.putAll(UrlBuilder.getModelParams(this.vreq));
        return UrlBuilder.getUrl("editRequestDispatch", params);
    }

    public Object get(String key) {
        return this.cleanTextForDisplay(this.data.get(key));
    }

    public String uri(String key) {
        return this.cleanURIForDisplay(this.data.get(key));
    }

    public Map<String, String> getAllData() {
        return this.data;
    }

    @Override
    public String getDeleteUrl() {
        return this.deleteUrl;
    }

    @Override
    public String getEditUrl() {
        return this.editUrl;
    }
}

