/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.grefine;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.controller.grefine.JSONReconcileServlet;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchQuery;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.modules.ApplicationStub;
import stubs.edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngineStub;
import stubs.javax.servlet.ServletContextStub;
import stubs.javax.servlet.http.HttpServletRequestStub;
import stubs.javax.servlet.http.HttpServletResponseStub;

public class JSONReconcileServletTest
extends AbstractTestClass {
    private HttpServletRequestStub request;
    private HttpServletResponseStub response;
    private JSONReconcileServlet reconcile;

    @Before
    public void setup() throws Exception {
        ApplicationStub.setup(new ServletContextStub(), new SearchEngineStub());
        this.request = new HttpServletRequestStub();
        this.request.setRequestUrl(new URL("http://vivo.this.that/reconcile"));
        this.request.setMethod("POST");
        this.response = new HttpServletResponseStub();
        this.reconcile = new JSONReconcileServlet();
    }

    @Test
    public void getMetadata() {
        int serverPort = 8080;
        String defaultNamespace = "http://vivo.this.that/individual/";
        String defaultTypeList = null;
        String serverName = null;
        String schemaSpaceOutput = null;
        JSONObject jsonResult = null;
        try {
            jsonResult = this.reconcile.getMetadata((HttpServletRequest)this.request, (HttpServletResponse)this.response, defaultNamespace, defaultTypeList, serverName, serverPort);
            schemaSpaceOutput = jsonResult.getString("schemaSpace");
        }
        catch (ServletException e) {
            System.err.println("JSONReconcileServletTest getMetadata ServletException: " + (Object)((Object)e));
        }
        catch (JSONException e) {
            System.err.println("JSONReconcileServletTest getMetadata JSONException: " + (Object)((Object)e));
        }
        Assert.assertNotNull((String)"output should not be null", (Object)jsonResult);
        Assert.assertEquals((String)"schemaSpaceOutput", (Object)defaultNamespace, (Object)schemaSpaceOutput);
    }

    @Test
    public void getQuery() {
        int rowNum = 3;
        String nameStr = "Joe";
        String nameType = "http://xmlns.com/foaf/0.1/Person";
        ArrayList<String[]> propertiesList = new ArrayList<String[]>();
        String orgStr = "Something";
        String orgType = "http://xmlns.com/foaf/0.1/Organization";
        String[] properties = new String[]{orgType, orgStr};
        propertiesList.add(properties);
        SearchQuery searchQuery = this.reconcile.getQuery(nameStr, nameType, rowNum, propertiesList);
        String messagePrefix = "Query should contain the text: ";
        this.testAssertTrue(messagePrefix + orgStr, orgStr, searchQuery.toString());
        this.testAssertTrue(messagePrefix + nameStr, nameStr, searchQuery.toString());
        this.testAssertTrue(messagePrefix + orgType, orgType, searchQuery.toString());
        this.testAssertTrue(messagePrefix + nameType, orgType, searchQuery.toString());
    }

    private void testAssertTrue(String message, String inputStr, String resultStr) {
        try {
            Pattern regex = Pattern.compile(inputStr, 2);
            Matcher regexMatcher = regex.matcher(resultStr);
            Assert.assertTrue((String)message, (boolean)regexMatcher.find());
        }
        catch (PatternSyntaxException e) {
            System.err.println("JSONReconcileServletTest testAssertTrue PatternSyntaxException: " + e);
        }
    }
}

