/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.reasoner;

import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import edu.cornell.mannlib.vitro.webapp.reasoner.SimpleReasoner;
import edu.cornell.mannlib.vitro.webapp.reasoner.SimpleReasonerTBoxHelper;
import edu.cornell.mannlib.vitro.webapp.reasoner.SimpleReasonerTBoxListener;
import edu.cornell.mannlib.vitro.webapp.utils.threads.VitroBackgroundThread;
import java.io.OutputStream;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class SimpleReasonerTest
extends SimpleReasonerTBoxHelper {
    private static final String mostSpecificTypePropertyURI = "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#mostSpecificType";
    long delay = 50L;

    @Before
    public void suppressErrorOutput() {
        this.suppressSyserr();
        SimpleReasonerTest.setLoggerLevel(SimpleReasoner.class, Level.OFF);
        SimpleReasonerTest.setLoggerLevel(SimpleReasonerTBoxListener.class, Level.OFF);
    }

    @Test
    public void addABoxTypeAssertion1Test() {
        this.addABoxTypeAssertion1(true);
    }

    @Test
    public void addABoxTypeAssertion1NoSameAsTest() {
        this.addABoxTypeAssertion1(false);
    }

    public void addABoxTypeAssertion1(boolean sameAsEnabled) {
        OntModel tBox = this.createTBoxModel();
        OntClass classA = this.createClass(tBox, "http://test.vivo/A", "class A");
        OntClass classB = this.createClass(tBox, "http://test.vivo/B", "class B");
        classA.addSubClass((Resource)classB);
        Model inf = ModelFactory.createDefaultModel();
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        SimpleReasoner simpleReasoner = new SimpleReasoner(tBox, aBox, inf);
        simpleReasoner.setSameAsEnabled(sameAsEnabled);
        aBox.register((ModelChangedListener)simpleReasoner);
        Resource ind_x = aBox.createResource("http://test.vivo/x");
        Statement xisb = ResourceFactory.createStatement((Resource)ind_x, (Property)RDF.type, (RDFNode)classB);
        aBox.add(xisb);
        Assert.assertFalse((boolean)inf.contains(xisb));
    }

    @Test
    public void addABoxTypeAssertion2Test() {
        this.addABoxTypeAssertion2(true);
    }

    @Test
    public void addABoxTypeAssertion2NoSameAs() {
        this.addABoxTypeAssertion2(false);
    }

    public void addABoxTypeAssertion2(boolean enableSameAs) {
        OntModel tBox = this.createTBoxModel();
        OntClass classA = this.createClass(tBox, "http://test.vivo/A", "class A");
        OntClass classB = this.createClass(tBox, "http://test.vivo/B", "class B");
        OntClass classC = this.createClass(tBox, "http://test.vivo/C", "class C");
        OntClass classD = this.createClass(tBox, "http://test.vivo/D", "class D");
        OntClass classE = this.createClass(tBox, "http://test.vivo/E", "class E");
        this.addSubclass(classA, classB);
        this.addSubclass(classA, classC);
        this.addSubclass(classC, classD);
        this.addSubclass(classC, classE);
        Model inf = ModelFactory.createDefaultModel();
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        SimpleReasoner sr = new SimpleReasoner(tBox, aBox, inf);
        sr.setSameAsEnabled(enableSameAs);
        aBox.register((ModelChangedListener)sr);
        Resource ind_x = aBox.createResource("http://test.vivo/x");
        aBox.add(ind_x, RDF.type, (RDFNode)classE);
        Statement xisc = ResourceFactory.createStatement((Resource)ind_x, (Property)RDF.type, (RDFNode)classC);
        Assert.assertTrue((boolean)inf.contains(xisc));
        Statement xisa = ResourceFactory.createStatement((Resource)ind_x, (Property)RDF.type, (RDFNode)classA);
        Assert.assertTrue((boolean)inf.contains(xisa));
    }

    @Test
    public void addABoxTypeAssertion3Test() throws InterruptedException {
        this.addABoxTypeAssertion3(true);
    }

    @Test
    public void addABoxTypeAssertion3NoSameAs() throws InterruptedException {
        this.addABoxTypeAssertion3(false);
    }

    public void addABoxTypeAssertion3(boolean enableSameAs) throws InterruptedException {
        OntModel tBox = this.createTBoxModel();
        OntClass classA = this.createClass(tBox, "http://test.vivo/A", "class A");
        OntClass classB = this.createClass(tBox, "http://test.vivo/B", "class B");
        OntClass classC = this.createClass(tBox, "http://test.vivo/C", "class C");
        this.addSubclass(classA, classC);
        this.setEquivalent(classA, classB);
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        Model inf = ModelFactory.createDefaultModel();
        SimpleReasoner sr = new SimpleReasoner(tBox, aBox, inf);
        sr.setSameAsEnabled(enableSameAs);
        SimpleReasoner simpleReasoner = sr;
        aBox.register((ModelChangedListener)simpleReasoner);
        SimpleReasonerTBoxListener simpleReasonerTBoxListener = this.getTBoxListener(simpleReasoner);
        tBox.register((ModelChangedListener)simpleReasonerTBoxListener);
        while (!VitroBackgroundThread.getLivingThreads().isEmpty()) {
            Thread.sleep(this.delay);
        }
        Resource ind_x = aBox.createResource("http://test.vivo/x");
        aBox.add(ind_x, RDF.type, (RDFNode)classC);
        Statement xisa = ResourceFactory.createStatement((Resource)ind_x, (Property)RDF.type, (RDFNode)classA);
        Assert.assertTrue((boolean)inf.contains(xisa));
        Statement xisb = ResourceFactory.createStatement((Resource)ind_x, (Property)RDF.type, (RDFNode)classB);
        Assert.assertTrue((boolean)inf.contains(xisb));
        simpleReasonerTBoxListener.setStopRequested();
    }

    @Test
    public void addABoxTypeAssertion4Test() throws InterruptedException {
        this.addABoxTypeAssertion4(true);
    }

    @Test
    public void addABoxTypeAssertion4NoSameAs() throws InterruptedException {
        this.addABoxTypeAssertion4(false);
    }

    public void addABoxTypeAssertion4(boolean enableSameAs) throws InterruptedException {
        OntModel tBox = this.createTBoxModel();
        OntClass classA = this.createClass(tBox, "http://test.vivo/A", "class A");
        OntClass classB = this.createClass(tBox, "http://test.vivo/B", "class B");
        this.setEquivalent(classA, classB);
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        Model inf = ModelFactory.createDefaultModel();
        SimpleReasoner sr = new SimpleReasoner(tBox, aBox, inf);
        sr.setSameAsEnabled(enableSameAs);
        SimpleReasoner simpleReasoner = sr;
        aBox.register((ModelChangedListener)simpleReasoner);
        SimpleReasonerTBoxListener simpleReasonerTBoxListener = this.getTBoxListener(simpleReasoner);
        tBox.register((ModelChangedListener)simpleReasonerTBoxListener);
        while (!VitroBackgroundThread.getLivingThreads().isEmpty()) {
            Thread.sleep(this.delay);
        }
        Resource ind_x = aBox.createResource("http://test.vivo/x");
        aBox.add(ind_x, RDF.type, (RDFNode)classB);
        Statement xisa = ResourceFactory.createStatement((Resource)ind_x, (Property)RDF.type, (RDFNode)classA);
        Assert.assertTrue((boolean)inf.contains(xisa));
        simpleReasonerTBoxListener.setStopRequested();
    }

    @Test
    public void addABoxTypeAssertion5Test() throws InterruptedException {
        this.addABoxTypeAssertion5(true);
    }

    @Test
    public void addABoxTypeAssertion5NoSameAs() throws InterruptedException {
        this.addABoxTypeAssertion5(false);
    }

    public void addABoxTypeAssertion5(boolean enableSameAs) throws InterruptedException {
        OntModel tBox = this.createTBoxModel();
        OntClass classA = this.createClass(tBox, "http://test.vivo/A", "class A");
        OntClass classB = this.createClass(tBox, "http://test.vivo/B", "class B");
        this.setEquivalent(classA, classB);
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        Model inf = ModelFactory.createDefaultModel();
        SimpleReasoner sr = new SimpleReasoner(tBox, aBox, inf);
        sr.setSameAsEnabled(enableSameAs);
        SimpleReasoner simpleReasoner = sr;
        aBox.register((ModelChangedListener)simpleReasoner);
        SimpleReasonerTBoxListener simpleReasonerTBoxListener = this.getTBoxListener(simpleReasoner);
        tBox.register((ModelChangedListener)simpleReasonerTBoxListener);
        while (!VitroBackgroundThread.getLivingThreads().isEmpty()) {
            Thread.sleep(this.delay);
        }
        Resource ind_x = aBox.createResource("http://test.vivo/x");
        aBox.add(ind_x, RDF.type, (RDFNode)classB);
        Statement xisa = ResourceFactory.createStatement((Resource)ind_x, (Property)RDF.type, (RDFNode)classA);
        Assert.assertTrue((boolean)inf.contains(xisa));
        aBox.remove(ind_x, RDF.type, (RDFNode)classB);
        Assert.assertFalse((boolean)inf.contains(xisa));
        simpleReasonerTBoxListener.setStopRequested();
    }

    @Test
    public void removeABoxTypeAssertion1Test() {
        this.removeABoxTypeAssertion1(true);
    }

    @Test
    public void removeABoxTypeAssertion1NoSameAs() {
        this.removeABoxTypeAssertion1(false);
    }

    public void removeABoxTypeAssertion1(boolean enableSameAs) {
        OntModel tBox = this.createTBoxModel();
        OntClass classA = this.createClass(tBox, "http://test.vivo/A", "class A");
        OntClass classB = this.createClass(tBox, "http://test.vivo/B", "class B");
        OntClass classC = this.createClass(tBox, "http://test.vivo/C", "class C");
        this.addSubclass(classB, classC);
        this.addSubclass(classA, classB);
        Model inf = ModelFactory.createDefaultModel();
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        SimpleReasoner sr = new SimpleReasoner(tBox, aBox, inf);
        sr.setSameAsEnabled(enableSameAs);
        aBox.register((ModelChangedListener)sr);
        Resource ind_x = aBox.createResource("http://test.vivo/x");
        aBox.add(ind_x, RDF.type, (RDFNode)classC);
        aBox.add(ind_x, RDF.type, (RDFNode)classB);
        aBox.remove(ind_x, RDF.type, (RDFNode)classC);
        Statement xisa = ResourceFactory.createStatement((Resource)ind_x, (Property)RDF.type, (RDFNode)classA);
        Assert.assertTrue((boolean)inf.contains(xisa));
        Statement xisb = ResourceFactory.createStatement((Resource)ind_x, (Property)RDF.type, (RDFNode)classB);
        Assert.assertFalse((boolean)inf.contains(xisb));
    }

    @Test
    public void addTBoxSubClassAssertion1Test() throws InterruptedException {
        this.addTBoxSubClassAssertion1(true);
    }

    @Test
    public void addTBoxSubClassAssertion1NoSameAs() throws InterruptedException {
        this.addTBoxSubClassAssertion1(false);
    }

    public void addTBoxSubClassAssertion1(boolean enableSameAs) throws InterruptedException {
        OntModel tBox = this.createTBoxModel();
        OntClass classA = this.createClass(tBox, "http://test.vivo/A", "class A");
        OntClass classB = this.createClass(tBox, "http://test.vivo/B", "class B");
        OntClass classC = this.createClass(tBox, "http://test.vivo/C", "class C");
        OntClass classD = this.createClass(tBox, "http://test.vivo/D", "class D");
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        Model inf = ModelFactory.createDefaultModel();
        SimpleReasoner sr = new SimpleReasoner(tBox, aBox, inf);
        sr.setSameAsEnabled(enableSameAs);
        SimpleReasoner simpleReasoner = sr;
        aBox.register((ModelChangedListener)simpleReasoner);
        SimpleReasonerTBoxListener simpleReasonerTBoxListener = this.getTBoxListener(simpleReasoner);
        tBox.register((ModelChangedListener)simpleReasonerTBoxListener);
        Resource ind_x = aBox.createResource("http://test.vivo/x");
        aBox.add(ind_x, RDF.type, (RDFNode)classC);
        this.addSubclass(classA, classC);
        while (!VitroBackgroundThread.getLivingThreads().isEmpty()) {
            Thread.sleep(this.delay);
        }
        Statement xisa = ResourceFactory.createStatement((Resource)ind_x, (Property)RDF.type, (RDFNode)classA);
        Assert.assertTrue((boolean)inf.contains(xisa));
        Statement xisb = ResourceFactory.createStatement((Resource)ind_x, (Property)RDF.type, (RDFNode)classB);
        Assert.assertFalse((boolean)inf.contains(xisb));
        Statement xisd = ResourceFactory.createStatement((Resource)ind_x, (Property)RDF.type, (RDFNode)classD);
        Assert.assertFalse((boolean)inf.contains(xisd));
        simpleReasonerTBoxListener.setStopRequested();
    }

    @Test
    public void addTBoxSubClassAssertion2Test() throws InterruptedException {
        this.addTBoxSubClassAssertion2(true);
    }

    @Test
    public void addTBoxSubClassAssertion2NoSameAs() throws InterruptedException {
        this.addTBoxSubClassAssertion2(false);
    }

    public void addTBoxSubClassAssertion2(boolean enableSameAs) throws InterruptedException {
        OntModel tBox = this.createTBoxModel();
        OntClass classA = this.createClass(tBox, "http://test.vivo/A", "class A");
        OntClass classB = this.createClass(tBox, "http://test.vivo/B", "class B");
        OntClass classC = this.createClass(tBox, "http://test.vivo/C", "class C");
        OntClass classD = this.createClass(tBox, "http://test.vivo/D", "class D");
        this.addSubclass(classC, classD);
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        Model inf = ModelFactory.createDefaultModel();
        SimpleReasoner sr = new SimpleReasoner(tBox, aBox, inf);
        sr.setSameAsEnabled(enableSameAs);
        SimpleReasoner simpleReasoner = sr;
        aBox.register((ModelChangedListener)simpleReasoner);
        SimpleReasonerTBoxListener simpleReasonerTBoxListener = this.getTBoxListener(simpleReasoner);
        tBox.register((ModelChangedListener)simpleReasonerTBoxListener);
        while (!VitroBackgroundThread.getLivingThreads().isEmpty()) {
            Thread.sleep(this.delay);
        }
        Resource ind_x = aBox.createResource("http://test.vivo/x");
        aBox.add(ind_x, RDF.type, (RDFNode)classD);
        this.addSubclass(classA, classC);
        while (!VitroBackgroundThread.getLivingThreads().isEmpty()) {
            Thread.sleep(this.delay);
        }
        Statement xisa = ResourceFactory.createStatement((Resource)ind_x, (Property)RDF.type, (RDFNode)classA);
        Assert.assertTrue((boolean)inf.contains(xisa));
        simpleReasonerTBoxListener.setStopRequested();
    }

    @Test
    public void removeTBoxSubClassAssertion1Test() throws InterruptedException {
        this.removeTBoxSubClassAssertion1(true);
    }

    @Test
    public void removeTBoxSubClassAssertion1NoSameAs() throws InterruptedException {
        this.removeTBoxSubClassAssertion1(false);
    }

    public void removeTBoxSubClassAssertion1(boolean enableSameAs) throws InterruptedException {
        OntModel tBox = this.createTBoxModel();
        OntClass classA = this.createClass(tBox, "http://test.vivo/A", "class A");
        OntClass classB = this.createClass(tBox, "http://test.vivo/B", "class B");
        OntClass classC = this.createClass(tBox, "http://test.vivo/C", "class C");
        OntClass classD = this.createClass(tBox, "http://test.vivo/D", "class D");
        OntClass classE = this.createClass(tBox, "http://test.vivo/E", "class E");
        OntClass classF = this.createClass(tBox, "http://test.vivo/F", "class F");
        OntClass classG = this.createClass(tBox, "http://test.vivo/G", "class G");
        OntClass classH = this.createClass(tBox, "http://test.vivo/H", "class H");
        this.addSubclass(classA, classB);
        this.addSubclass(classA, classC);
        this.addSubclass(classA, classD);
        this.addSubclass(classB, classE);
        this.addSubclass(classC, classF);
        this.addSubclass(classC, classG);
        this.addSubclass(classD, classH);
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        Model inf = ModelFactory.createDefaultModel();
        SimpleReasoner sr = new SimpleReasoner(tBox, aBox, inf);
        sr.setSameAsEnabled(enableSameAs);
        SimpleReasoner simpleReasoner = sr;
        aBox.register((ModelChangedListener)simpleReasoner);
        SimpleReasonerTBoxListener simpleReasonerTBoxListener = this.getTBoxListener(simpleReasoner);
        tBox.register((ModelChangedListener)simpleReasonerTBoxListener);
        while (!VitroBackgroundThread.getLivingThreads().isEmpty()) {
            Thread.sleep(this.delay);
        }
        Resource ind_x = aBox.createResource("http://test.vivo/x");
        aBox.add(ind_x, RDF.type, (RDFNode)classE);
        this.removeSubclass(classA, classB);
        while (!VitroBackgroundThread.getLivingThreads().isEmpty()) {
            Thread.sleep(this.delay);
        }
        Statement xisa = ResourceFactory.createStatement((Resource)ind_x, (Property)RDF.type, (RDFNode)classA);
        Assert.assertFalse((boolean)inf.contains(xisa));
        Statement xisb = ResourceFactory.createStatement((Resource)ind_x, (Property)RDF.type, (RDFNode)classB);
        Assert.assertTrue((boolean)inf.contains(xisb));
        Resource ind_y = aBox.createResource("http://test.vivo/y");
        aBox.add(ind_y, RDF.type, (RDFNode)classF);
        aBox.add(ind_y, RDF.type, (RDFNode)classH);
        classA.removeSubClass((Resource)classC);
        while (!VitroBackgroundThread.getLivingThreads().isEmpty()) {
            Thread.sleep(this.delay);
        }
        Statement yisa = ResourceFactory.createStatement((Resource)ind_y, (Property)RDF.type, (RDFNode)classA);
        Assert.assertTrue((boolean)inf.contains(yisa));
        simpleReasonerTBoxListener.setStopRequested();
    }

    @Ignore(value=" needs TBoxReasoner infrastructure which is not in this suite.")
    @Test
    public void bcdTest() throws InterruptedException {
        this.bcd(true);
    }

    @Ignore(value=" needs TBoxReasoner infrastructure which is not in this suite.")
    @Test
    public void bcdNoSameAsTest() throws InterruptedException {
        this.bcd(false);
    }

    public void bcd(boolean enableSameAs) throws InterruptedException {
        OntModel tBox = this.createTBoxModel();
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        Model inf = ModelFactory.createDefaultModel();
        SimpleReasoner simpleReasoner = new SimpleReasoner(tBox, aBox, inf);
        simpleReasoner.setSameAsEnabled(enableSameAs);
        aBox.register((ModelChangedListener)simpleReasoner);
        SimpleReasonerTBoxListener simpleReasonerTBoxListener = this.getTBoxListener(simpleReasoner);
        tBox.register((ModelChangedListener)simpleReasonerTBoxListener);
        OntClass LivingThing = this.createClass(tBox, "http://test.vivo/LivingThing", "Living Thing");
        OntClass Flora = this.createClass(tBox, "http://test.vivo/Flora", "Flora");
        OntClass Brassica = this.createClass(tBox, "http://test.vivo/Brassica", "Brassica");
        this.addSubclass(LivingThing, Flora);
        this.addSubclass(Flora, Brassica);
        tBox.rebind();
        tBox.prepare();
        while (!VitroBackgroundThread.getLivingThreads().isEmpty()) {
            Thread.sleep(this.delay);
        }
        Resource kale = aBox.createResource("http://test.vivo/kale");
        aBox.add(kale, RDF.type, (RDFNode)Brassica);
        Flora.removeSubClass((Resource)Brassica);
        tBox.rebind();
        tBox.prepare();
        while (!VitroBackgroundThread.getLivingThreads().isEmpty()) {
            Thread.sleep(this.delay);
        }
        Statement kaleIsFlora = ResourceFactory.createStatement((Resource)kale, (Property)RDF.type, (RDFNode)Flora);
        Assert.assertFalse((boolean)inf.contains(kaleIsFlora));
        Statement kaleIsLivingThing = ResourceFactory.createStatement((Resource)kale, (Property)RDF.type, (RDFNode)LivingThing);
        Assert.assertFalse((boolean)inf.contains(kaleIsLivingThing));
        simpleReasonerTBoxListener.setStopRequested();
    }

    @Test
    public void mstTest1Test() throws InterruptedException {
        this.mstTest1(true);
    }

    @Test
    public void mstTest1NoSameAs() throws InterruptedException {
        this.mstTest1(false);
    }

    public void mstTest1(boolean enableSameAs) throws InterruptedException {
        OntModel tBox = this.createTBoxModel();
        OntClass classA = this.createClass(tBox, "http://test.vivo/A", "class A");
        OntClass classB = this.createClass(tBox, "http://test.vivo/B", "class B");
        OntClass classC = this.createClass(tBox, "http://test.vivo/C", "class C");
        OntClass classD = this.createClass(tBox, "http://test.vivo/D", "class D");
        OntClass classE = this.createClass(tBox, "http://test.vivo/E", "class E");
        OntClass classY = this.createClass(tBox, "http://test.vivo/Y", "class Y");
        this.addSubclass(classA, classC);
        this.addSubclass(classY, classC);
        this.addSubclass(classC, classD);
        this.addSubclass(classC, classE);
        this.addSubclass(classD, classB);
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        Model inf = ModelFactory.createDefaultModel();
        SimpleReasoner sr = new SimpleReasoner(tBox, aBox, inf);
        sr.setSameAsEnabled(enableSameAs);
        SimpleReasoner simpleReasoner = sr;
        aBox.register((ModelChangedListener)simpleReasoner);
        SimpleReasonerTBoxListener simpleReasonerTBoxListener = this.getTBoxListener(simpleReasoner);
        tBox.register((ModelChangedListener)simpleReasonerTBoxListener);
        AnnotationProperty mostSpecificType = tBox.createAnnotationProperty(mostSpecificTypePropertyURI);
        while (!VitroBackgroundThread.getLivingThreads().isEmpty()) {
            Thread.sleep(this.delay);
        }
        Resource ind_x = aBox.createResource("http://test.vivo/x");
        aBox.add(ind_x, RDF.type, (RDFNode)classD);
        Assert.assertTrue((boolean)inf.contains(ind_x, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classD.getURI())));
        Assert.assertFalse((boolean)aBox.contains(ind_x, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classA.getURI())));
        Assert.assertFalse((boolean)aBox.contains(ind_x, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classY.getURI())));
        Assert.assertFalse((boolean)aBox.contains(ind_x, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classC.getURI())));
        Assert.assertFalse((boolean)aBox.contains(ind_x, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classE.getURI())));
        Assert.assertFalse((boolean)aBox.contains(ind_x, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classB.getURI())));
        aBox.remove(ind_x, RDF.type, (RDFNode)classD);
        Assert.assertFalse((boolean)inf.contains(ind_x, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classD.getURI())));
        simpleReasonerTBoxListener.setStopRequested();
    }

    @Test
    public void mstTest2Test() throws InterruptedException {
        this.mstTest2(true);
    }

    @Test
    public void mstTest2NoSameAs() throws InterruptedException {
        this.mstTest2(false);
    }

    public void mstTest2(boolean enableSameAs) throws InterruptedException {
        OntModel tBox = this.createTBoxModel();
        OntClass classA = this.createClass(tBox, "http://test.vivo/A", "class A");
        OntClass classB = this.createClass(tBox, "http://test.vivo/B", "class B");
        OntClass classC = this.createClass(tBox, "http://test.vivo/C", "class C");
        this.setEquivalent(classA, classB);
        this.setEquivalent(classB, classC);
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        Model inf = ModelFactory.createDefaultModel();
        SimpleReasoner sr = new SimpleReasoner(tBox, aBox, inf);
        sr.setSameAsEnabled(enableSameAs);
        SimpleReasoner simpleReasoner = sr;
        aBox.register((ModelChangedListener)simpleReasoner);
        SimpleReasonerTBoxListener simpleReasonerTBoxListener = this.getTBoxListener(simpleReasoner);
        tBox.register((ModelChangedListener)simpleReasonerTBoxListener);
        AnnotationProperty mostSpecificType = tBox.createAnnotationProperty(mostSpecificTypePropertyURI);
        while (!VitroBackgroundThread.getLivingThreads().isEmpty()) {
            Thread.sleep(this.delay);
        }
        Resource ind_x = aBox.createResource("http://test.vivo/x");
        aBox.add(ind_x, RDF.type, (RDFNode)classB);
        Assert.assertTrue((boolean)inf.contains(ind_x, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classA.getURI())));
        Assert.assertTrue((boolean)inf.contains(ind_x, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classB.getURI())));
        Assert.assertTrue((boolean)inf.contains(ind_x, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classC.getURI())));
        simpleReasonerTBoxListener.setStopRequested();
    }

    @Test
    public void mstTest3Test() throws InterruptedException {
        this.mstTest3(true);
    }

    @Test
    public void mstTest3NoSameAs() throws InterruptedException {
        this.mstTest3(false);
    }

    public void mstTest3(boolean enableSameAs) throws InterruptedException {
        OntModel tBox = this.createTBoxModel();
        OntClass classA = this.createClass(tBox, "http://test.vivo/A", "class A");
        OntClass classB = this.createClass(tBox, "http://test.vivo/B", "class B");
        OntClass classC = this.createClass(tBox, "http://test.vivo/C", "class C");
        OntClass classD = this.createClass(tBox, "http://test.vivo/D", "class D");
        OntClass classE = this.createClass(tBox, "http://test.vivo/E", "class E");
        OntClass classF = this.createClass(tBox, "http://test.vivo/F", "class F");
        OntClass classG = this.createClass(tBox, "http://test.vivo/G", "class G");
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        Model inf = ModelFactory.createDefaultModel();
        SimpleReasoner sr = new SimpleReasoner(tBox, aBox, inf);
        sr.setSameAsEnabled(enableSameAs);
        SimpleReasoner simpleReasoner = sr;
        aBox.register((ModelChangedListener)simpleReasoner);
        SimpleReasonerTBoxListener simpleReasonerTBoxListener = this.getTBoxListener(simpleReasoner);
        tBox.register((ModelChangedListener)simpleReasonerTBoxListener);
        OntClass OWL_THING = tBox.createClass(OWL.Thing.getURI());
        AnnotationProperty mostSpecificType = tBox.createAnnotationProperty(mostSpecificTypePropertyURI);
        while (!VitroBackgroundThread.getLivingThreads().isEmpty()) {
            Thread.sleep(this.delay);
        }
        Resource ind_x = aBox.createResource("http://test.vivo/x");
        Resource ind_y = aBox.createResource("http://test.vivo/y");
        aBox.add(ind_x, RDF.type, (RDFNode)OWL_THING);
        aBox.add(ind_y, RDF.type, (RDFNode)classD);
        Assert.assertTrue((boolean)inf.contains(ind_x, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)OWL.Thing.getURI())));
        Assert.assertTrue((boolean)inf.contains(ind_y, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classD.getURI())));
        aBox.add(ind_x, RDF.type, (RDFNode)classC);
        aBox.add(ind_y, RDF.type, (RDFNode)classF);
        Assert.assertFalse((boolean)inf.contains(ind_x, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)OWL.Thing.getURI())));
        Assert.assertTrue((boolean)inf.contains(ind_x, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classC.getURI())));
        Assert.assertTrue((boolean)inf.contains(ind_y, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classD.getURI())));
        Assert.assertTrue((boolean)inf.contains(ind_y, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classF.getURI())));
        this.addSubclass(classA, classB);
        this.addSubclass(classA, classC);
        this.addSubclass(classA, classD);
        this.addSubclass(classC, classE);
        this.addSubclass(classD, classF);
        this.addSubclass(classD, classG);
        while (!VitroBackgroundThread.getLivingThreads().isEmpty()) {
            Thread.sleep(this.delay);
        }
        Assert.assertFalse((boolean)inf.contains(ind_y, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classD.getURI())));
        Assert.assertTrue((boolean)inf.contains(ind_y, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classF.getURI())));
        this.removeSubclass(classD, classF);
        while (!VitroBackgroundThread.getLivingThreads().isEmpty()) {
            Thread.sleep(this.delay);
        }
        Assert.assertTrue((boolean)inf.contains(ind_y, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classD.getURI())));
        simpleReasonerTBoxListener.setStopRequested();
    }

    SimpleReasonerTBoxListener getTBoxListener(SimpleReasoner simpleReasoner) {
        return new SimpleReasonerTBoxListener(simpleReasoner, new Exception().getStackTrace()[1].getMethodName());
    }

    void printModel(Model model, String modelName) {
        System.out.println("\nThe " + modelName + " model has " + model.size() + " statements:");
        System.out.println("---------------------------------------------------------------------");
        model.write((OutputStream)System.out);
    }

    void printModel(OntModel ontModel, String modelName) {
        System.out.println("\nThe " + modelName + " model has " + ontModel.size() + " statements:");
        System.out.println("---------------------------------------------------------------------");
        ontModel.writeAll((OutputStream)System.out, "N3", null);
    }
}

