/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchengine.base;

import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchInputField;
import edu.cornell.mannlib.vitro.webapp.searchengine.base.BaseSearchInputDocument;
import edu.cornell.mannlib.vitro.webapp.searchengine.base.BaseSearchInputField;
import java.util.Collection;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class BaseSearchInputDocumentTest {
    @Test
    public void copyConstructor() {
        BaseSearchInputDocument doc = new BaseSearchInputDocument();
        doc.setDocumentBoost(42.6f);
        BaseSearchInputField field1 = new BaseSearchInputField("testField");
        field1.addValues(new Object[]{"value1", "value2"});
        field1.setBoost(1.1f);
        doc.addField((SearchInputField)field1);
        BaseSearchInputField field2 = new BaseSearchInputField("anotherField");
        field2.setBoost(-16.0f);
        doc.addField((SearchInputField)field2);
        BaseSearchInputDocument other = new BaseSearchInputDocument(doc);
        Assert.assertEquals((Object)doc, (Object)other);
        Assert.assertEquals((float)doc.getDocumentBoost(), (float)other.getDocumentBoost(), (float)0.01f);
        Map docMap = doc.getFieldMap();
        Map otherMap = other.getFieldMap();
        Assert.assertEquals((Object)docMap, (Object)otherMap);
        Assert.assertNotSame((Object)docMap, (Object)otherMap);
        for (String fieldName : docMap.keySet()) {
            SearchInputField docField = doc.getField(fieldName);
            SearchInputField otherField = other.getField(fieldName);
            Assert.assertEquals((Object)docField, (Object)otherField);
            Assert.assertNotSame((Object)docField, (Object)otherField);
            Collection docFieldValues = docField.getValues();
            Collection otherFieldValues = otherField.getValues();
            Assert.assertEquals((Object)docFieldValues, (Object)otherFieldValues);
        }
    }
}

