/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.json;

import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.json.JsonObjectProducer;
import edu.cornell.mannlib.vitro.webapp.dao.VClassGroupsForRequest;
import edu.cornell.mannlib.vitro.webapp.dao.jena.VClassGroupCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;

public class GetAllVClasses
extends JsonObjectProducer {
    private static final Log log = LogFactory.getLog(GetAllVClasses.class);

    public GetAllVClasses(VitroRequest vreq) {
        super(vreq);
    }

    @Override
    protected JSONObject process() throws Exception {
        JSONObject map = new JSONObject();
        ArrayList<VClass> vclasses = new ArrayList<VClass>();
        VClassGroupsForRequest vcgc = VClassGroupCache.getVClassGroups((HttpServletRequest)this.vreq);
        List<VClassGroup> groups = vcgc.getGroups();
        for (VClassGroup vcg : groups) {
            for (VClass vc : vcg) {
                vclasses.add(vc);
            }
        }
        Collections.sort(vclasses);
        ArrayList<JSONObject> classes = new ArrayList<JSONObject>(vclasses.size());
        for (VClass vc : vclasses) {
            JSONObject vcObj = new JSONObject();
            vcObj.put("name", vc.getName());
            vcObj.put("URI", vc.getURI());
            classes.add(vcObj);
        }
        map.put("classes", classes);
        return map;
    }
}

