/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.login;

import edu.cornell.mannlib.vitro.webapp.i18n.I18n;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoginProcessBean {
    private static final Log log = LogFactory.getLog(LoginProcessBean.class);
    private static Object[] NO_ARGUMENTS = new Object[0];
    private static final String SESSION_ATTRIBUTE = LoginProcessBean.class.getName();
    private State currentState = State.NOWHERE;
    private volatile String loginPageUrl;
    private volatile String afterLoginUrl;
    private final Object messageSynchronizer = new Object();
    private Message message = Message.NO_MESSAGE;
    private Object[] messageArguments = NO_ARGUMENTS;
    private String username = "";

    public static boolean isBean(HttpServletRequest request) {
        return null != LoginProcessBean.getBeanFromSession(request);
    }

    public static LoginProcessBean getBean(HttpServletRequest request) {
        if (LoginProcessBean.isBean(request)) {
            return LoginProcessBean.getBeanFromSession(request);
        }
        LoginProcessBean.setBean(request, new LoginProcessBean());
        return LoginProcessBean.getBeanFromSession(request);
    }

    public static void setBean(HttpServletRequest request, LoginProcessBean bean) {
        HttpSession session = request.getSession();
        session.setAttribute(SESSION_ATTRIBUTE, (Object)bean);
    }

    public static void removeBean(HttpServletRequest request) {
        if (LoginProcessBean.isBean(request)) {
            request.getSession().removeAttribute(SESSION_ATTRIBUTE);
        }
    }

    private static LoginProcessBean getBeanFromSession(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        Object bean = session.getAttribute(SESSION_ATTRIBUTE);
        if (bean == null) {
            return null;
        }
        if (!(bean instanceof LoginProcessBean)) {
            log.warn((Object)("Tried to get login process bean, but found an instance of " + bean.getClass().getName() + ": " + bean));
            return null;
        }
        return (LoginProcessBean)bean;
    }

    public void setState(State newState) {
        this.currentState = newState;
    }

    public State getState() {
        return this.currentState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMessage() {
        Object object = this.messageSynchronizer;
        synchronized (object) {
            this.message = Message.NO_MESSAGE;
            this.messageArguments = NO_ARGUMENTS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessage(Message message) {
        Object object = this.messageSynchronizer;
        synchronized (object) {
            this.message = message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessage(HttpServletRequest req, MLevel level, String textKey, Object ... parameters) {
        Object object = this.messageSynchronizer;
        synchronized (object) {
            this.message = new Message(req, level, textKey, parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInfoMessageAndClear() {
        Object object = this.messageSynchronizer;
        synchronized (object) {
            String text = "";
            if (this.message.getMessageLevel() == MLevel.INFO) {
                text = this.message.getText();
                this.clearMessage();
            }
            return text;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getErrorMessageAndClear() {
        Object object = this.messageSynchronizer;
        synchronized (object) {
            String text = "";
            if (this.message.getMessageLevel() == MLevel.ERROR) {
                text = this.message.getText();
                this.clearMessage();
            }
            return text;
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getLoginPageUrl() {
        return this.loginPageUrl;
    }

    public void setLoginPageUrl(String loginPageUrl) {
        this.loginPageUrl = loginPageUrl;
    }

    public String getAfterLoginUrl() {
        return this.afterLoginUrl;
    }

    public void setAfterLoginUrl(String afterLoginUrl) {
        this.afterLoginUrl = afterLoginUrl;
    }

    public String toString() {
        return "LoginProcessBean(" + this.hashCode() + ")[state=" + (Object)((Object)this.currentState) + ", message=" + this.message + ", messageArguments=" + Arrays.deepToString(this.messageArguments) + ", username=" + this.username + ", loginPageUrl=" + this.loginPageUrl + ", afterLoginUrl=" + this.afterLoginUrl + "]";
    }

    public static class Message {
        public static final Message NO_MESSAGE = new Message();
        private final String text;
        private final MLevel messageLevel;

        public Message() {
            this.messageLevel = MLevel.NONE;
            this.text = "";
        }

        public Message(HttpServletRequest req, MLevel messageLevel, String textKey, Object ... parameters) {
            this.messageLevel = messageLevel;
            this.text = I18n.bundle(req).text(textKey, parameters);
        }

        public MLevel getMessageLevel() {
            return this.messageLevel;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return "Message[" + (Object)((Object)this.messageLevel) + ", '" + this.text + "']";
        }
    }

    public static enum MLevel {
        NONE,
        INFO,
        ERROR;

    }

    public static enum State {
        NOWHERE,
        LOGGING_IN,
        FORCED_PASSWORD_CHANGE,
        LOGGED_IN;

    }
}

