/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.listeners.StatementListener;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;

public class CumulativeDeltaModeler
extends StatementListener {
    private Model additionsModel = ModelFactory.createDefaultModel();
    private Model retractionsModel = ModelFactory.createDefaultModel();

    public CumulativeDeltaModeler() {
    }

    public CumulativeDeltaModeler(Model model) {
        this();
        model.register((ModelChangedListener)this);
    }

    public CumulativeDeltaModeler(OntModel ontModel) {
        this();
        ontModel.getBaseModel().register((ModelChangedListener)this);
    }

    public Model getAdditions() {
        return this.additionsModel;
    }

    public Model getRetractions() {
        return this.retractionsModel;
    }

    public void addedStatement(Statement s) {
        if (this.retractionsModel.contains(s)) {
            this.retractionsModel.remove(s);
        } else {
            this.additionsModel.add(s);
        }
    }

    public void removedStatement(Statement s) {
        if (this.additionsModel.contains(s)) {
            this.additionsModel.remove(s);
        } else {
            this.retractionsModel.add(s);
        }
    }
}

