/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.controller;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.shared.InvalidPropertyURIException;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.RedirectResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.NewURIMakerVitro;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.edit.EditLiteral;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.AdditionsAndRetractions;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditSubmissionUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.MultiValueEditSubmission;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3EditUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.ProcessRdfForm;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.RdfLiteralHash;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.controller.PostEditCleanupController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProcessRdfFormController
extends FreemarkerHttpServlet {
    private Log log = LogFactory.getLog(ProcessRdfFormController.class);

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return SimplePermission.DO_FRONT_END_EDITING.ACTION;
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        AdditionsAndRetractions changes;
        EditConfigurationVTwo configuration = EditConfigurationUtils.getEditConfiguration((HttpServletRequest)vreq);
        if (configuration == null) {
            return this.handleMissingConfiguration(vreq);
        }
        MultiValueEditSubmission submission = new MultiValueEditSubmission(vreq.getParameterMap(), configuration);
        EditSubmissionUtils.putEditSubmissionInSession(vreq.getSession(), submission);
        ResponseValues errorResponse = this.doValidationErrors(vreq, configuration, submission);
        if (errorResponse != null) {
            return errorResponse;
        }
        Model queryModel = configuration.getQueryModelSelector().getModel((HttpServletRequest)vreq, this.getServletContext());
        Model writeModel = configuration.getWriteModelSelector().getModel((HttpServletRequest)vreq, this.getServletContext());
        boolean isBackButton = this.checkForBackButtonConfusion(configuration, vreq, queryModel);
        if (isBackButton) {
            return this.doProcessBackButton(configuration, submission, vreq);
        }
        try {
            ProcessRdfForm prf = new ProcessRdfForm(configuration, new NewURIMakerVitro(vreq.getWebappDaoFactory()));
            changes = prf.process(configuration, submission, vreq);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        if (configuration.isUseDependentResourceDelete()) {
            changes = ProcessRdfForm.addDependentDeletes(changes, queryModel);
        }
        N3EditUtils.preprocessModels(changes, configuration, vreq);
        ProcessRdfForm.applyChangesToWriteModel(changes, queryModel, writeModel, N3EditUtils.getEditorUri((HttpServletRequest)vreq));
        String entityToReturnTo = N3EditUtils.processEntityToReturnTo(configuration, submission, vreq);
        N3EditUtils.updateEditConfigurationForBackButton(configuration, submission, vreq, writeModel);
        PostEditCleanupController.doPostEditCleanup(vreq);
        return PostEditCleanupController.doPostEditRedirect(vreq, entityToReturnTo);
    }

    private ResponseValues doProcessBackButton(EditConfigurationVTwo configuration, MultiValueEditSubmission submission, VitroRequest vreq) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("errorMessage", "Back button confusion has occurred");
        TemplateResponseValues values = new TemplateResponseValues("error-message.ftl", map);
        return values;
    }

    private boolean checkForBackButtonConfusion(EditConfigurationVTwo editConfig, VitroRequest vreq, Model model) {
        if (EditConfigurationUtils.isObjectProperty(editConfig.getPredicateUri(), vreq)) {
            return false;
        }
        WebappDaoFactory wdf = vreq.getWebappDaoFactory();
        if (!editConfig.isDataPropertyUpdate()) {
            return false;
        }
        Integer dpropHash = editConfig.getDatapropKey();
        DataPropertyStatement dps = RdfLiteralHash.getPropertyStmtByHash(editConfig.getSubjectUri(), editConfig.getPredicateUri(), dpropHash, model);
        if (dps != null) {
            return false;
        }
        DataProperty dp = wdf.getDataPropertyDao().getDataPropertyByURI(editConfig.getPredicateUri());
        if (dp != null) {
            return dp.getDisplayLimit() != 1;
        }
        return false;
    }

    private ResponseValues doValidationErrors(VitroRequest vreq, EditConfigurationVTwo editConfiguration, MultiValueEditSubmission submission) {
        Map<String, String> errors = submission.getValidationErrors();
        if (errors != null && !errors.isEmpty()) {
            String form = editConfiguration.getFormUrl();
            vreq.setAttribute("formUrl", form);
            vreq.setAttribute("view", vreq.getParameter("view"));
            String formUrl = editConfiguration.getFormUrl();
            formUrl = formUrl + "&editKey=" + editConfiguration.getEditKey();
            return new RedirectResponseValues(formUrl);
        }
        return null;
    }

    protected ResponseValues handleMissingConfiguration(VitroRequest vreq) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("params", vreq.getParameterMap());
        return new TemplateResponseValues("missingEditConfig.ftl", map);
    }

    public static class Utilities {
        private static Log log = LogFactory.getLog(ProcessRdfFormController.class);
        public static String assertionsType = "assertions";
        public static String retractionsType = "retractions";

        public static boolean isDataProperty(EditConfigurationVTwo configuration, VitroRequest vreq) {
            return EditConfigurationUtils.isDataProperty(configuration.getPredicateUri(), vreq);
        }

        public static boolean isObjectProperty(EditConfigurationVTwo configuration, VitroRequest vreq) {
            return EditConfigurationUtils.isObjectProperty(configuration.getPredicateUri(), vreq);
        }

        public static List<String> makeListCopy(List<String> list) {
            ArrayList<String> copyOfN3 = new ArrayList<String>();
            for (String str : list) {
                copyOfN3.add(str);
            }
            return copyOfN3;
        }

        public static boolean hasFieldChanged(String fieldName, EditConfigurationVTwo editConfig, MultiValueEditSubmission submission) {
            List<Literal> newLit;
            boolean fieldChanged;
            List<String> orgValue = editConfig.getUrisInScope().get(fieldName);
            List<String> newValue = submission.getUrisFromForm().get(fieldName);
            if (orgValue != null) {
                Collections.sort(orgValue);
            }
            if (newValue != null) {
                Collections.sort(newValue);
            }
            if (orgValue != null && newValue != null) {
                return !orgValue.equals(newValue);
            }
            List<Literal> orgLit = editConfig.getLiteralsInScope().get(fieldName);
            boolean bl = fieldChanged = !orgLit.equals(newLit = submission.getLiteralsFromForm().get(fieldName));
            if (!fieldChanged) {
                int newLen;
                int orgLen = orgLit.size();
                if (orgLen != (newLen = newLit.size())) {
                    fieldChanged = true;
                } else {
                    for (int i = 0; i < orgLen; ++i) {
                        if (EditLiteral.equalLiterals(orgLit.get(i), newLit.get(i))) continue;
                        fieldChanged = true;
                        break;
                    }
                }
            }
            log.debug((Object)("field " + fieldName + " " + (fieldChanged ? "did Change" : "did NOT change")));
            return fieldChanged;
        }

        public static String getPredicateLocalName(EditConfigurationVTwo editConfig) {
            String predicateUri;
            String predicateLocalName = null;
            if (editConfig != null && (predicateUri = editConfig.getPredicateUri()) != null) {
                try {
                    Property prop = ResourceFactory.createProperty((String)predicateUri);
                    predicateLocalName = prop.getLocalName();
                }
                catch (InvalidPropertyURIException e) {
                    log.debug((Object)"could not convert predicateUri into a valid URI", (Throwable)e);
                }
            }
            return predicateLocalName;
        }

        public static String getPostEditUrlPattern(VitroRequest vreq, EditConfigurationVTwo editConfig) {
            String cancel = vreq.getParameter("cancel");
            String urlPattern = null;
            String urlPatternToReturnTo = null;
            String urlPatternToCancelTo = null;
            if (editConfig != null) {
                urlPatternToReturnTo = editConfig.getUrlPatternToReturnTo();
                urlPatternToCancelTo = vreq.getParameter("url");
            }
            urlPattern = cancel != null && cancel.equals("true") && !StringUtils.isEmpty((String)urlPatternToCancelTo) ? urlPatternToCancelTo : (!StringUtils.isEmpty((String)urlPatternToReturnTo) ? urlPatternToReturnTo : "/individual");
            return urlPattern;
        }

        public static String getResourceToRedirect(VitroRequest vreq, EditConfigurationVTwo editConfig, String entityToReturnTo) {
            String resourceToRedirectTo = null;
            if (editConfig != null && ((resourceToRedirectTo = editConfig.getEntityToReturnTo() != null && editConfig.getEntityToReturnTo().startsWith("?") ? entityToReturnTo : editConfig.getEntityToReturnTo()) == null || resourceToRedirectTo.length() == 0)) {
                resourceToRedirectTo = editConfig.getSubjectUri();
            }
            return resourceToRedirectTo;
        }
    }
}

