/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.ontology.update;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import edu.cornell.mannlib.vitro.webapp.ontology.update.ChangeRecord;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleChangeRecord
implements ChangeRecord {
    private static final Log log = LogFactory.getLog(SimpleChangeRecord.class);
    private static final String RDF_SYNTAX = "N3";
    private Model additionsModel = ModelFactory.createDefaultModel();
    private Model retractionsModel = ModelFactory.createDefaultModel();
    private File additionsFile;
    private File retractionsFile;
    private int additionsCount = 0;
    private int retractionsCount = 0;

    public SimpleChangeRecord(String additionsFile, String retractionsFile) {
        this.additionsFile = new File(additionsFile);
        try {
            FileWriter fileWriter = new FileWriter(additionsFile);
        }
        catch (IOException ioe) {
            throw new RuntimeException(this.getClass().getName() + " unable to create required file at " + additionsFile);
        }
        this.retractionsFile = new File(retractionsFile);
        try {
            FileWriter ioe = new FileWriter(retractionsFile);
        }
        catch (IOException ioe) {
            throw new RuntimeException(this.getClass().getName() + " unable to create required file at " + retractionsFile);
        }
    }

    @Override
    public void recordAdditions(Model incrementalAdditions) {
        this.additionsModel.add(incrementalAdditions);
        this.additionsCount = (int)((long)this.additionsCount + incrementalAdditions.size());
    }

    @Override
    public void recordRetractions(Model incrementalRetractions) {
        this.retractionsModel.add(incrementalRetractions);
        this.retractionsCount = (int)((long)this.retractionsCount + incrementalRetractions.size());
    }

    private void write(Model model, File file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            model.write((OutputStream)fos, RDF_SYNTAX);
        }
        catch (FileNotFoundException fnfe) {
            log.error((Object)(this.getClass().getName() + " unable to write to RDF file"), (Throwable)fnfe);
        }
    }

    @Override
    public void writeChanges() {
        if (this.additionsModel.size() > 0L) {
            this.write(this.additionsModel, this.additionsFile);
        }
        if (this.retractionsModel.size() > 0L) {
            this.write(this.retractionsModel, this.retractionsFile);
        }
    }

    @Override
    public boolean hasRecordedChanges() {
        return this.additionsCount > 0 || this.retractionsCount > 0;
    }
}

