/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeListener;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public interface RDFService {
    public boolean changeSetUpdate(ChangeSet var1) throws RDFServiceException;

    public void newIndividual(String var1, String var2) throws RDFServiceException;

    public void newIndividual(String var1, String var2, String var3) throws RDFServiceException;

    public InputStream sparqlConstructQuery(String var1, ModelSerializationFormat var2) throws RDFServiceException;

    public void sparqlConstructQuery(String var1, Model var2) throws RDFServiceException;

    public InputStream sparqlDescribeQuery(String var1, ModelSerializationFormat var2) throws RDFServiceException;

    public InputStream sparqlSelectQuery(String var1, ResultFormat var2) throws RDFServiceException;

    public void sparqlSelectQuery(String var1, ResultSetConsumer var2) throws RDFServiceException;

    public boolean sparqlAskQuery(String var1) throws RDFServiceException;

    public List<String> getGraphURIs() throws RDFServiceException;

    public void getGraphMetadata() throws RDFServiceException;

    public String getDefaultWriteGraphURI() throws RDFServiceException;

    public void serializeAll(OutputStream var1) throws RDFServiceException;

    public void serializeGraph(String var1, OutputStream var2) throws RDFServiceException;

    public boolean isEquivalentGraph(String var1, InputStream var2, ModelSerializationFormat var3) throws RDFServiceException;

    public boolean isEquivalentGraph(String var1, Model var2) throws RDFServiceException;

    public void registerJenaModelChangedListener(ModelChangedListener var1) throws RDFServiceException;

    public void unregisterJenaModelChangedListener(ModelChangedListener var1) throws RDFServiceException;

    public void registerListener(ChangeListener var1) throws RDFServiceException;

    public void unregisterListener(ChangeListener var1) throws RDFServiceException;

    public ChangeSet manufactureChangeSet();

    public void close();

    public static enum ResultFormat {
        JSON,
        CSV,
        XML,
        TEXT;

    }

    public static enum ModelSerializationFormat {
        RDFXML,
        N3,
        NTRIPLE;

    }

    public static enum SPARQLQueryType {
        SELECT,
        CONSTRUCT,
        DESCRIBE,
        ASK;

    }
}

