/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.services.shortview;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public interface ShortViewService {
    public String renderShortView(Individual var1, ShortViewContext var2, Map<String, Object> var3, VitroRequest var4);

    public TemplateAndSupplementalData getShortViewInfo(Individual var1, ShortViewContext var2, VitroRequest var3);

    public static enum ShortViewContext {
        SEARCH("view-search-default.ftl"),
        INDEX("view-index-default.ftl"),
        BROWSE("view-browse-default.ftl");

        private final String defaultTemplateName;

        private ShortViewContext(String defaultTemplateName) {
            this.defaultTemplateName = defaultTemplateName;
        }

        public String getDefaultTemplateName() {
            return this.defaultTemplateName;
        }

        public static ShortViewContext fromString(String string) {
            for (ShortViewContext c : ShortViewContext.values()) {
                if (!c.name().equalsIgnoreCase(string)) continue;
                return c;
            }
            return null;
        }

        public static String valueList() {
            return StringUtils.join((Object[])ShortViewContext.values(), (String)", ");
        }
    }

    public static interface TemplateAndSupplementalData {
        public String getTemplateName();

        public Map<String, Object> getSupplementalData();
    }
}

